/*
 * Decompiled with CFR 0.152.
 */
package com.rnnestedscrollview;

import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.facebook.react.views.scroll.FpsListener;
import com.facebook.react.views.scroll.ReactScrollViewCommandHelper;
import com.facebook.react.views.scroll.ScrollEventType;
import com.facebook.yoga.YogaConstants;
import com.rnnestedscrollview.ReactNestedScrollView;
import com.rnnestedscrollview.ReactNestedScrollViewHelper;
import java.util.Map;
import javax.annotation.Nullable;

@ReactModule(name="RCTNestedScrollView")
public class ReactNestedScrollViewManager
extends ViewGroupManager<ReactNestedScrollView>
implements ReactScrollViewCommandHelper.ScrollCommandHandler<ReactNestedScrollView> {
    protected static final String REACT_CLASS = "RCTNestedScrollView";
    private static final int[] SPACING_TYPES = new int[]{8, 0, 2, 1, 3};
    @Nullable
    private FpsListener mFpsListener = null;

    public ReactNestedScrollViewManager() {
        this(null);
    }

    public ReactNestedScrollViewManager(@Nullable FpsListener fpsListener) {
        this.mFpsListener = fpsListener;
    }

    public String getName() {
        return REACT_CLASS;
    }

    public ReactNestedScrollView createViewInstance(ThemedReactContext context) {
        return new ReactNestedScrollView((ReactContext)context, this.mFpsListener);
    }

    @ReactProp(name="scrollEnabled", defaultBoolean=true)
    public void setScrollEnabled(ReactNestedScrollView view, boolean value) {
        view.setScrollEnabled(value);
    }

    @ReactProp(name="showsVerticalScrollIndicator")
    public void setShowsVerticalScrollIndicator(ReactNestedScrollView view, boolean value) {
        view.setVerticalScrollBarEnabled(value);
    }

    @ReactProp(name="removeClippedSubviews")
    public void setRemoveClippedSubviews(ReactNestedScrollView view, boolean removeClippedSubviews) {
        view.setRemoveClippedSubviews(removeClippedSubviews);
    }

    @ReactProp(name="sendMomentumEvents")
    public void setSendMomentumEvents(ReactNestedScrollView view, boolean sendMomentumEvents) {
        view.setSendMomentumEvents(sendMomentumEvents);
    }

    @ReactProp(name="scrollPerfTag")
    public void setScrollPerfTag(ReactNestedScrollView view, String scrollPerfTag) {
        view.setScrollPerfTag(scrollPerfTag);
    }

    @ReactProp(name="endFillColor", defaultInt=0, customType="Color")
    public void setBottomFillColor(ReactNestedScrollView view, int color) {
        view.setEndFillColor(color);
    }

    @ReactProp(name="overScrollMode")
    public void setOverScrollMode(ReactNestedScrollView view, String value) {
        view.setOverScrollMode(ReactNestedScrollViewHelper.parseOverScrollMode(value));
    }

    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return ReactScrollViewCommandHelper.getCommandsMap();
    }

    public void receiveCommand(ReactNestedScrollView scrollView, int commandId, @Nullable ReadableArray args) {
        ReactScrollViewCommandHelper.receiveCommand((ReactScrollViewCommandHelper.ScrollCommandHandler)this, (Object)((Object)scrollView), (int)commandId, (ReadableArray)args);
    }

    public void scrollTo(ReactNestedScrollView scrollView, ReactScrollViewCommandHelper.ScrollToCommandData data) {
        if (data.mAnimated) {
            scrollView.smoothScrollTo(data.mDestX, data.mDestY);
        } else {
            scrollView.scrollTo(data.mDestX, data.mDestY);
        }
    }

    @ReactPropGroup(names={"borderRadius", "borderTopLeftRadius", "borderTopRightRadius", "borderBottomRightRadius", "borderBottomLeftRadius"}, defaultFloat=NaNf)
    public void setBorderRadius(ReactNestedScrollView view, int index, float borderRadius) {
        if (!YogaConstants.isUndefined((float)borderRadius)) {
            borderRadius = PixelUtil.toPixelFromDIP((float)borderRadius);
        }
        if (index == 0) {
            view.setBorderRadius(borderRadius);
        } else {
            view.setBorderRadius(borderRadius, index - 1);
        }
    }

    @ReactProp(name="borderStyle")
    public void setBorderStyle(ReactNestedScrollView view, @Nullable String borderStyle) {
        view.setBorderStyle(borderStyle);
    }

    @ReactPropGroup(names={"borderWidth", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth"}, defaultFloat=NaNf)
    public void setBorderWidth(ReactNestedScrollView view, int index, float width) {
        if (!YogaConstants.isUndefined((float)width)) {
            width = PixelUtil.toPixelFromDIP((float)width);
        }
        view.setBorderWidth(SPACING_TYPES[index], width);
    }

    @ReactPropGroup(names={"borderColor", "borderLeftColor", "borderRightColor", "borderTopColor", "borderBottomColor"}, customType="Color")
    public void setBorderColor(ReactNestedScrollView view, int index, Integer color) {
        float rgbComponent = color == null ? Float.NaN : (float)(color & 0xFFFFFF);
        float alphaComponent = color == null ? Float.NaN : (float)(color >>> 24);
        view.setBorderColor(SPACING_TYPES[index], rgbComponent, alphaComponent);
    }

    public void scrollToEnd(ReactNestedScrollView scrollView, ReactScrollViewCommandHelper.ScrollToEndCommandData data) {
        int bottom = scrollView.getChildAt(0).getHeight() + scrollView.getPaddingBottom();
        if (data.mAnimated) {
            scrollView.smoothScrollTo(scrollView.getScrollX(), bottom);
        } else {
            scrollView.scrollTo(scrollView.getScrollX(), bottom);
        }
    }

    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        return ReactNestedScrollViewManager.createExportedCustomDirectEventTypeConstants();
    }

    public static Map createExportedCustomDirectEventTypeConstants() {
        return MapBuilder.builder().put((Object)ScrollEventType.SCROLL.getJSEventName(), (Object)MapBuilder.of((Object)"registrationName", (Object)"onScroll")).put((Object)ScrollEventType.BEGIN_DRAG.getJSEventName(), (Object)MapBuilder.of((Object)"registrationName", (Object)"onScrollBeginDrag")).put((Object)ScrollEventType.END_DRAG.getJSEventName(), (Object)MapBuilder.of((Object)"registrationName", (Object)"onScrollEndDrag")).put((Object)ScrollEventType.ANIMATION_END.getJSEventName(), (Object)MapBuilder.of((Object)"registrationName", (Object)"onScrollAnimationEnd")).put((Object)ScrollEventType.MOMENTUM_BEGIN.getJSEventName(), (Object)MapBuilder.of((Object)"registrationName", (Object)"onMomentumScrollBegin")).put((Object)ScrollEventType.MOMENTUM_END.getJSEventName(), (Object)MapBuilder.of((Object)"registrationName", (Object)"onMomentumScrollEnd")).build();
    }
}

