/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.support.annotation.RequiresApi;
import android.support.transition.TransitionImpl;
import android.support.transition.TransitionInterface;
import android.support.transition.TransitionInterfaceListener;
import android.support.transition.TransitionValues;
import android.transition.Transition;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(value=19)
@TargetApi(value=19)
class TransitionKitKat
extends TransitionImpl {
    Transition mTransition;
    TransitionInterface mExternalTransition;
    private CompatListener mCompatListener;

    TransitionKitKat() {
    }

    static void copyValues(android.transition.TransitionValues source, TransitionValues dest) {
        if (source == null) {
            return;
        }
        dest.view = source.view;
        if (source.values.size() > 0) {
            dest.values.putAll(source.values);
        }
    }

    static void copyValues(TransitionValues source, android.transition.TransitionValues dest) {
        if (source == null) {
            return;
        }
        dest.view = source.view;
        if (source.values.size() > 0) {
            dest.values.putAll(source.values);
        }
    }

    static void wrapCaptureStartValues(TransitionInterface transition, android.transition.TransitionValues transitionValues) {
        TransitionValues externalValues = new TransitionValues();
        TransitionKitKat.copyValues(transitionValues, externalValues);
        transition.captureStartValues(externalValues);
        TransitionKitKat.copyValues(externalValues, transitionValues);
    }

    static void wrapCaptureEndValues(TransitionInterface transition, android.transition.TransitionValues transitionValues) {
        TransitionValues externalValues = new TransitionValues();
        TransitionKitKat.copyValues(transitionValues, externalValues);
        transition.captureEndValues(externalValues);
        TransitionKitKat.copyValues(externalValues, transitionValues);
    }

    static TransitionValues convertToSupport(android.transition.TransitionValues values) {
        if (values == null) {
            return null;
        }
        TransitionValues supportValues = new TransitionValues();
        TransitionKitKat.copyValues(values, supportValues);
        return supportValues;
    }

    static android.transition.TransitionValues convertToPlatform(TransitionValues values) {
        if (values == null) {
            return null;
        }
        android.transition.TransitionValues platformValues = new android.transition.TransitionValues();
        TransitionKitKat.copyValues(values, platformValues);
        return platformValues;
    }

    @Override
    public void init(TransitionInterface external, Object internal) {
        this.mExternalTransition = external;
        this.mTransition = internal == null ? new TransitionWrapper(external) : (Transition)internal;
    }

    @Override
    public TransitionImpl addListener(TransitionInterfaceListener listener) {
        if (this.mCompatListener == null) {
            this.mCompatListener = new CompatListener();
            this.mTransition.addListener((Transition.TransitionListener)this.mCompatListener);
        }
        this.mCompatListener.addListener(listener);
        return this;
    }

    @Override
    public TransitionImpl removeListener(TransitionInterfaceListener listener) {
        if (this.mCompatListener == null) {
            return this;
        }
        this.mCompatListener.removeListener(listener);
        if (this.mCompatListener.isEmpty()) {
            this.mTransition.removeListener((Transition.TransitionListener)this.mCompatListener);
            this.mCompatListener = null;
        }
        return this;
    }

    @Override
    public TransitionImpl addTarget(View target) {
        this.mTransition.addTarget(target);
        return this;
    }

    @Override
    public TransitionImpl addTarget(int targetId) {
        this.mTransition.addTarget(targetId);
        return this;
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        android.transition.TransitionValues internalValues = new android.transition.TransitionValues();
        TransitionKitKat.copyValues(transitionValues, internalValues);
        this.mTransition.captureEndValues(internalValues);
        TransitionKitKat.copyValues(internalValues, transitionValues);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        android.transition.TransitionValues internalValues = new android.transition.TransitionValues();
        TransitionKitKat.copyValues(transitionValues, internalValues);
        this.mTransition.captureStartValues(internalValues);
        TransitionKitKat.copyValues(internalValues, transitionValues);
    }

    @Override
    public Animator createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        android.transition.TransitionValues internalEndValues;
        android.transition.TransitionValues internalStartValues;
        if (startValues != null) {
            internalStartValues = new android.transition.TransitionValues();
            TransitionKitKat.copyValues(startValues, internalStartValues);
        } else {
            internalStartValues = null;
        }
        if (endValues != null) {
            internalEndValues = new android.transition.TransitionValues();
            TransitionKitKat.copyValues(endValues, internalEndValues);
        } else {
            internalEndValues = null;
        }
        return this.mTransition.createAnimator(sceneRoot, internalStartValues, internalEndValues);
    }

    @Override
    public TransitionImpl excludeChildren(View target, boolean exclude) {
        this.mTransition.excludeChildren(target, exclude);
        return this;
    }

    @Override
    public TransitionImpl excludeChildren(int targetId, boolean exclude) {
        this.mTransition.excludeChildren(targetId, exclude);
        return this;
    }

    @Override
    public TransitionImpl excludeChildren(Class type, boolean exclude) {
        this.mTransition.excludeChildren(type, exclude);
        return this;
    }

    @Override
    public TransitionImpl excludeTarget(View target, boolean exclude) {
        this.mTransition.excludeTarget(target, exclude);
        return this;
    }

    @Override
    public TransitionImpl excludeTarget(int targetId, boolean exclude) {
        this.mTransition.excludeTarget(targetId, exclude);
        return this;
    }

    @Override
    public TransitionImpl excludeTarget(Class type, boolean exclude) {
        this.mTransition.excludeTarget(type, exclude);
        return this;
    }

    @Override
    public long getDuration() {
        return this.mTransition.getDuration();
    }

    @Override
    public TransitionImpl setDuration(long duration) {
        this.mTransition.setDuration(duration);
        return this;
    }

    @Override
    public TimeInterpolator getInterpolator() {
        return this.mTransition.getInterpolator();
    }

    @Override
    public TransitionImpl setInterpolator(TimeInterpolator interpolator) {
        this.mTransition.setInterpolator(interpolator);
        return this;
    }

    @Override
    public String getName() {
        return this.mTransition.getName();
    }

    @Override
    public long getStartDelay() {
        return this.mTransition.getStartDelay();
    }

    @Override
    public TransitionImpl setStartDelay(long startDelay) {
        this.mTransition.setStartDelay(startDelay);
        return this;
    }

    @Override
    public List<Integer> getTargetIds() {
        return this.mTransition.getTargetIds();
    }

    @Override
    public List<View> getTargets() {
        return this.mTransition.getTargets();
    }

    @Override
    public String[] getTransitionProperties() {
        return this.mTransition.getTransitionProperties();
    }

    @Override
    public TransitionValues getTransitionValues(View view, boolean start) {
        TransitionValues values = new TransitionValues();
        TransitionKitKat.copyValues(this.mTransition.getTransitionValues(view, start), values);
        return values;
    }

    @Override
    public TransitionImpl removeTarget(View target) {
        this.mTransition.removeTarget(target);
        return this;
    }

    @Override
    public TransitionImpl removeTarget(int targetId) {
        if (targetId > 0) {
            this.getTargetIds().remove((Object)targetId);
        }
        return this;
    }

    public String toString() {
        return this.mTransition.toString();
    }

    private class CompatListener
    implements Transition.TransitionListener {
        private final ArrayList<TransitionInterfaceListener> mListeners = new ArrayList();

        CompatListener() {
        }

        void addListener(TransitionInterfaceListener listener) {
            this.mListeners.add(listener);
        }

        void removeListener(TransitionInterfaceListener listener) {
            this.mListeners.remove(listener);
        }

        boolean isEmpty() {
            return this.mListeners.isEmpty();
        }

        public void onTransitionStart(Transition transition) {
            for (TransitionInterfaceListener listener : this.mListeners) {
                listener.onTransitionStart(TransitionKitKat.this.mExternalTransition);
            }
        }

        public void onTransitionEnd(Transition transition) {
            for (TransitionInterfaceListener listener : this.mListeners) {
                listener.onTransitionEnd(TransitionKitKat.this.mExternalTransition);
            }
        }

        public void onTransitionCancel(Transition transition) {
            for (TransitionInterfaceListener listener : this.mListeners) {
                listener.onTransitionCancel(TransitionKitKat.this.mExternalTransition);
            }
        }

        public void onTransitionPause(Transition transition) {
            for (TransitionInterfaceListener listener : this.mListeners) {
                listener.onTransitionPause(TransitionKitKat.this.mExternalTransition);
            }
        }

        public void onTransitionResume(Transition transition) {
            for (TransitionInterfaceListener listener : this.mListeners) {
                listener.onTransitionResume(TransitionKitKat.this.mExternalTransition);
            }
        }
    }

    private static class TransitionWrapper
    extends Transition {
        private TransitionInterface mTransition;

        public TransitionWrapper(TransitionInterface transition) {
            this.mTransition = transition;
        }

        public void captureStartValues(android.transition.TransitionValues transitionValues) {
            TransitionKitKat.wrapCaptureStartValues(this.mTransition, transitionValues);
        }

        public void captureEndValues(android.transition.TransitionValues transitionValues) {
            TransitionKitKat.wrapCaptureEndValues(this.mTransition, transitionValues);
        }

        public Animator createAnimator(ViewGroup sceneRoot, android.transition.TransitionValues startValues, android.transition.TransitionValues endValues) {
            return this.mTransition.createAnimator(sceneRoot, TransitionKitKat.convertToSupport(startValues), TransitionKitKat.convertToSupport(endValues));
        }
    }
}

