/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge.queue;

import android.os.Build;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.queue.MessageQueueThreadSpec;
import javax.annotation.Nullable;

public class ReactQueueConfigurationSpec {
    private static final long LEGACY_STACK_SIZE_BYTES = 2000000L;
    @Nullable
    private final MessageQueueThreadSpec mUIBackgroundQueueThreadSpec;
    private final MessageQueueThreadSpec mNativeModulesQueueThreadSpec;
    private final MessageQueueThreadSpec mJSQueueThreadSpec;

    private ReactQueueConfigurationSpec(@Nullable MessageQueueThreadSpec uiBackgroundQueueThreadSpec, MessageQueueThreadSpec nativeModulesQueueThreadSpec, MessageQueueThreadSpec jsQueueThreadSpec) {
        this.mUIBackgroundQueueThreadSpec = uiBackgroundQueueThreadSpec;
        this.mNativeModulesQueueThreadSpec = nativeModulesQueueThreadSpec;
        this.mJSQueueThreadSpec = jsQueueThreadSpec;
    }

    @Nullable
    public MessageQueueThreadSpec getUIBackgroundQueueThreadSpec() {
        return this.mUIBackgroundQueueThreadSpec;
    }

    public MessageQueueThreadSpec getNativeModulesQueueThreadSpec() {
        return this.mNativeModulesQueueThreadSpec;
    }

    public MessageQueueThreadSpec getJSQueueThreadSpec() {
        return this.mJSQueueThreadSpec;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ReactQueueConfigurationSpec createDefault() {
        MessageQueueThreadSpec spec = Build.VERSION.SDK_INT < 21 ? MessageQueueThreadSpec.newBackgroundThreadSpec("native_modules", 2000000L) : MessageQueueThreadSpec.newBackgroundThreadSpec("native_modules");
        return ReactQueueConfigurationSpec.builder().setJSQueueThreadSpec(MessageQueueThreadSpec.newBackgroundThreadSpec("js")).setNativeModulesQueueThreadSpec(spec).build();
    }

    public static ReactQueueConfigurationSpec createWithSeparateUIBackgroundThread() {
        MessageQueueThreadSpec spec = Build.VERSION.SDK_INT < 21 ? MessageQueueThreadSpec.newBackgroundThreadSpec("native_modules", 2000000L) : MessageQueueThreadSpec.newBackgroundThreadSpec("native_modules");
        return ReactQueueConfigurationSpec.builder().setJSQueueThreadSpec(MessageQueueThreadSpec.newBackgroundThreadSpec("js")).setNativeModulesQueueThreadSpec(spec).setUIBackgroundQueueThreadSpec(MessageQueueThreadSpec.newUIBackgroundTreadSpec("ui_background")).build();
    }

    public static class Builder {
        @Nullable
        private MessageQueueThreadSpec mUIBackgroundQueueSpec;
        @Nullable
        private MessageQueueThreadSpec mNativeModulesQueueSpec;
        @Nullable
        private MessageQueueThreadSpec mJSQueueSpec;

        public Builder setUIBackgroundQueueThreadSpec(MessageQueueThreadSpec spec) {
            Assertions.assertCondition((this.mUIBackgroundQueueSpec == null ? 1 : 0) != 0, (String)"Setting UI background queue multiple times!");
            this.mUIBackgroundQueueSpec = spec;
            return this;
        }

        public Builder setNativeModulesQueueThreadSpec(MessageQueueThreadSpec spec) {
            Assertions.assertCondition((this.mNativeModulesQueueSpec == null ? 1 : 0) != 0, (String)"Setting native modules queue spec multiple times!");
            this.mNativeModulesQueueSpec = spec;
            return this;
        }

        public Builder setJSQueueThreadSpec(MessageQueueThreadSpec spec) {
            Assertions.assertCondition((this.mJSQueueSpec == null ? 1 : 0) != 0, (String)"Setting JS queue multiple times!");
            this.mJSQueueSpec = spec;
            return this;
        }

        public ReactQueueConfigurationSpec build() {
            return new ReactQueueConfigurationSpec(this.mUIBackgroundQueueSpec, (MessageQueueThreadSpec)Assertions.assertNotNull((Object)this.mNativeModulesQueueSpec), (MessageQueueThreadSpec)Assertions.assertNotNull((Object)this.mJSQueueSpec));
        }
    }
}

