/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.Nullable;
import android.support.design.R;
import android.support.design.widget.AnimationUtils;
import android.support.design.widget.CircularBorderDrawable;
import android.support.design.widget.ShadowViewDelegate;
import android.support.design.widget.ValueAnimatorCompat;
import android.support.design.widget.VisibilityAwareImageButton;
import android.support.v4.content.ContextCompat;
import android.view.ViewTreeObserver;
import android.view.animation.Interpolator;

abstract class FloatingActionButtonImpl {
    static final Interpolator ANIM_INTERPOLATOR = AnimationUtils.FAST_OUT_LINEAR_IN_INTERPOLATOR;
    static final long PRESSED_ANIM_DURATION = 100L;
    static final long PRESSED_ANIM_DELAY = 100L;
    static final int ANIM_STATE_NONE = 0;
    static final int ANIM_STATE_HIDING = 1;
    static final int ANIM_STATE_SHOWING = 2;
    int mAnimState = 0;
    Drawable mShapeDrawable;
    Drawable mRippleDrawable;
    CircularBorderDrawable mBorderDrawable;
    Drawable mContentBackground;
    float mElevation;
    float mPressedTranslationZ;
    static final int SHOW_HIDE_ANIM_DURATION = 200;
    static final int[] PRESSED_ENABLED_STATE_SET = new int[]{16842919, 16842910};
    static final int[] FOCUSED_ENABLED_STATE_SET = new int[]{16842908, 16842910};
    static final int[] ENABLED_STATE_SET = new int[]{16842910};
    static final int[] EMPTY_STATE_SET = new int[0];
    final VisibilityAwareImageButton mView;
    final ShadowViewDelegate mShadowViewDelegate;
    final ValueAnimatorCompat.Creator mAnimatorCreator;
    private final Rect mTmpRect = new Rect();
    private ViewTreeObserver.OnPreDrawListener mPreDrawListener;

    FloatingActionButtonImpl(VisibilityAwareImageButton view, ShadowViewDelegate shadowViewDelegate, ValueAnimatorCompat.Creator animatorCreator) {
        this.mView = view;
        this.mShadowViewDelegate = shadowViewDelegate;
        this.mAnimatorCreator = animatorCreator;
    }

    abstract void setBackgroundDrawable(ColorStateList var1, PorterDuff.Mode var2, int var3, int var4);

    abstract void setBackgroundTintList(ColorStateList var1);

    abstract void setBackgroundTintMode(PorterDuff.Mode var1);

    abstract void setRippleColor(int var1);

    final void setElevation(float elevation) {
        if (this.mElevation != elevation) {
            this.mElevation = elevation;
            this.onElevationsChanged(elevation, this.mPressedTranslationZ);
        }
    }

    abstract float getElevation();

    final void setPressedTranslationZ(float translationZ) {
        if (this.mPressedTranslationZ != translationZ) {
            this.mPressedTranslationZ = translationZ;
            this.onElevationsChanged(this.mElevation, translationZ);
        }
    }

    abstract void onElevationsChanged(float var1, float var2);

    abstract void onDrawableStateChanged(int[] var1);

    abstract void jumpDrawableToCurrentState();

    abstract void hide(@Nullable InternalVisibilityChangedListener var1, boolean var2);

    abstract void show(@Nullable InternalVisibilityChangedListener var1, boolean var2);

    final Drawable getContentBackground() {
        return this.mContentBackground;
    }

    abstract void onCompatShadowChanged();

    final void updatePadding() {
        Rect rect = this.mTmpRect;
        this.getPadding(rect);
        this.onPaddingUpdated(rect);
        this.mShadowViewDelegate.setShadowPadding(rect.left, rect.top, rect.right, rect.bottom);
    }

    abstract void getPadding(Rect var1);

    void onPaddingUpdated(Rect padding) {
    }

    void onAttachedToWindow() {
        if (this.requirePreDrawListener()) {
            this.ensurePreDrawListener();
            this.mView.getViewTreeObserver().addOnPreDrawListener(this.mPreDrawListener);
        }
    }

    void onDetachedFromWindow() {
        if (this.mPreDrawListener != null) {
            this.mView.getViewTreeObserver().removeOnPreDrawListener(this.mPreDrawListener);
            this.mPreDrawListener = null;
        }
    }

    boolean requirePreDrawListener() {
        return false;
    }

    CircularBorderDrawable createBorderDrawable(int borderWidth, ColorStateList backgroundTint) {
        Context context = this.mView.getContext();
        CircularBorderDrawable borderDrawable = this.newCircularDrawable();
        borderDrawable.setGradientColors(ContextCompat.getColor((Context)context, (int)R.color.design_fab_stroke_top_outer_color), ContextCompat.getColor((Context)context, (int)R.color.design_fab_stroke_top_inner_color), ContextCompat.getColor((Context)context, (int)R.color.design_fab_stroke_end_inner_color), ContextCompat.getColor((Context)context, (int)R.color.design_fab_stroke_end_outer_color));
        borderDrawable.setBorderWidth(borderWidth);
        borderDrawable.setBorderTint(backgroundTint);
        return borderDrawable;
    }

    CircularBorderDrawable newCircularDrawable() {
        return new CircularBorderDrawable();
    }

    void onPreDraw() {
    }

    private void ensurePreDrawListener() {
        if (this.mPreDrawListener == null) {
            this.mPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    FloatingActionButtonImpl.this.onPreDraw();
                    return true;
                }
            };
        }
    }

    GradientDrawable createShapeDrawable() {
        GradientDrawable d = this.newGradientDrawableForShape();
        d.setShape(1);
        d.setColor(-1);
        return d;
    }

    GradientDrawable newGradientDrawableForShape() {
        return new GradientDrawable();
    }

    boolean isOrWillBeShown() {
        if (this.mView.getVisibility() != 0) {
            return this.mAnimState == 2;
        }
        return this.mAnimState != 1;
    }

    boolean isOrWillBeHidden() {
        if (this.mView.getVisibility() == 0) {
            return this.mAnimState == 1;
        }
        return this.mAnimState != 2;
    }

    static interface InternalVisibilityChangedListener {
        public void onShown();

        public void onHidden();
    }
}

