/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.content.Context;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.MathUtils;
import android.support.design.widget.ViewOffsetBehavior;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ScrollerCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;

abstract class HeaderBehavior<V extends View>
extends ViewOffsetBehavior<V> {
    private static final int INVALID_POINTER = -1;
    private Runnable mFlingRunnable;
    ScrollerCompat mScroller;
    private boolean mIsBeingDragged;
    private int mActivePointerId = -1;
    private int mLastMotionY;
    private int mTouchSlop = -1;
    private VelocityTracker mVelocityTracker;

    public HeaderBehavior() {
    }

    public HeaderBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public boolean onInterceptTouchEvent(CoordinatorLayout parent, V child, MotionEvent ev) {
        int action;
        if (this.mTouchSlop < 0) {
            this.mTouchSlop = ViewConfiguration.get((Context)parent.getContext()).getScaledTouchSlop();
        }
        if ((action = ev.getAction()) == 2 && this.mIsBeingDragged) {
            return true;
        }
        switch (MotionEventCompat.getActionMasked((MotionEvent)ev)) {
            case 0: {
                this.mIsBeingDragged = false;
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                if (!this.canDragView(child) || !parent.isPointInChildBounds((View)child, x, y)) break;
                this.mLastMotionY = y;
                this.mActivePointerId = ev.getPointerId(0);
                this.ensureVelocityTracker();
                break;
            }
            case 2: {
                int y;
                int yDiff;
                int pointerIndex;
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1 || (pointerIndex = ev.findPointerIndex(activePointerId)) == -1 || (yDiff = Math.abs((y = (int)ev.getY(pointerIndex)) - this.mLastMotionY)) <= this.mTouchSlop) break;
                this.mIsBeingDragged = true;
                this.mLastMotionY = y;
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.addMovement(ev);
        }
        return this.mIsBeingDragged;
    }

    @Override
    public boolean onTouchEvent(CoordinatorLayout parent, V child, MotionEvent ev) {
        if (this.mTouchSlop < 0) {
            this.mTouchSlop = ViewConfiguration.get((Context)parent.getContext()).getScaledTouchSlop();
        }
        switch (MotionEventCompat.getActionMasked((MotionEvent)ev)) {
            case 0: {
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                if (parent.isPointInChildBounds((View)child, x, y) && this.canDragView(child)) {
                    this.mLastMotionY = y;
                    this.mActivePointerId = ev.getPointerId(0);
                    this.ensureVelocityTracker();
                    break;
                }
                return false;
            }
            case 2: {
                int activePointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (activePointerIndex == -1) {
                    return false;
                }
                int y = (int)ev.getY(activePointerIndex);
                int dy = this.mLastMotionY - y;
                if (!this.mIsBeingDragged && Math.abs(dy) > this.mTouchSlop) {
                    this.mIsBeingDragged = true;
                    dy = dy > 0 ? (dy -= this.mTouchSlop) : (dy += this.mTouchSlop);
                }
                if (!this.mIsBeingDragged) break;
                this.mLastMotionY = y;
                this.scroll(parent, child, dy, this.getMaxDragOffset(child), 0);
                break;
            }
            case 1: {
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.addMovement(ev);
                    this.mVelocityTracker.computeCurrentVelocity(1000);
                    float yvel = VelocityTrackerCompat.getYVelocity((VelocityTracker)this.mVelocityTracker, (int)this.mActivePointerId);
                    this.fling(parent, child, -this.getScrollRangeForDragFling(child), 0, yvel);
                }
            }
            case 3: {
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.addMovement(ev);
        }
        return true;
    }

    int setHeaderTopBottomOffset(CoordinatorLayout parent, V header, int newOffset) {
        return this.setHeaderTopBottomOffset(parent, header, newOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    int setHeaderTopBottomOffset(CoordinatorLayout parent, V header, int newOffset, int minOffset, int maxOffset) {
        int curOffset = this.getTopAndBottomOffset();
        int consumed = 0;
        if (minOffset != 0 && curOffset >= minOffset && curOffset <= maxOffset && curOffset != (newOffset = MathUtils.constrain(newOffset, minOffset, maxOffset))) {
            this.setTopAndBottomOffset(newOffset);
            consumed = curOffset - newOffset;
        }
        return consumed;
    }

    int getTopBottomOffsetForScrollingSibling() {
        return this.getTopAndBottomOffset();
    }

    final int scroll(CoordinatorLayout coordinatorLayout, V header, int dy, int minOffset, int maxOffset) {
        return this.setHeaderTopBottomOffset(coordinatorLayout, header, this.getTopBottomOffsetForScrollingSibling() - dy, minOffset, maxOffset);
    }

    final boolean fling(CoordinatorLayout coordinatorLayout, V layout2, int minOffset, int maxOffset, float velocityY) {
        if (this.mFlingRunnable != null) {
            layout2.removeCallbacks(this.mFlingRunnable);
            this.mFlingRunnable = null;
        }
        if (this.mScroller == null) {
            this.mScroller = ScrollerCompat.create((Context)layout2.getContext());
        }
        this.mScroller.fling(0, this.getTopAndBottomOffset(), 0, Math.round(velocityY), 0, 0, minOffset, maxOffset);
        if (this.mScroller.computeScrollOffset()) {
            this.mFlingRunnable = new FlingRunnable(this, coordinatorLayout, layout2);
            ViewCompat.postOnAnimation(layout2, (Runnable)this.mFlingRunnable);
            return true;
        }
        this.onFlingFinished(coordinatorLayout, layout2);
        return false;
    }

    void onFlingFinished(CoordinatorLayout parent, V layout2) {
    }

    boolean canDragView(V view) {
        return false;
    }

    int getMaxDragOffset(V view) {
        return -view.getHeight();
    }

    int getScrollRangeForDragFling(V view) {
        return view.getHeight();
    }

    private void ensureVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private static class FlingRunnable
    implements Runnable {
        private final CoordinatorLayout mParent;
        private final V mLayout;
        final /* synthetic */ HeaderBehavior this$0;

        FlingRunnable(CoordinatorLayout parent, V layout2) {
            this.this$0 = var1_1;
            this.mParent = parent;
            this.mLayout = layout2;
        }

        @Override
        public void run() {
            if (this.mLayout != null && this.this$0.mScroller != null) {
                if (this.this$0.mScroller.computeScrollOffset()) {
                    this.this$0.setHeaderTopBottomOffset(this.mParent, this.mLayout, this.this$0.mScroller.getCurrY());
                    ViewCompat.postOnAnimation(this.mLayout, (Runnable)this);
                } else {
                    this.this$0.onFlingFinished(this.mParent, this.mLayout);
                }
            }
        }
    }
}

