/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.Closeables;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.common.memory.PooledByteBufferOutputStream;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.TriState;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.nativecode.JpegTranscoder;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.DownsampleUtil;
import com.facebook.imagepipeline.producers.JobScheduler;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public class ResizeAndRotateProducer
implements Producer<EncodedImage> {
    public static final String PRODUCER_NAME = "ResizeAndRotateProducer";
    private static final String ORIGINAL_SIZE_KEY = "Original size";
    private static final String REQUESTED_SIZE_KEY = "Requested size";
    private static final String DOWNSAMPLE_ENUMERATOR_KEY = "downsampleEnumerator";
    private static final String SOFTWARE_ENUMERATOR_KEY = "softwareEnumerator";
    private static final String ROTATION_ANGLE_KEY = "rotationAngle";
    private static final String FRACTION_KEY = "Fraction";
    private static final int FULL_ROUND = 360;
    @VisibleForTesting
    static final int DEFAULT_JPEG_QUALITY = 85;
    @VisibleForTesting
    static final int MAX_JPEG_SCALE_NUMERATOR = 8;
    @VisibleForTesting
    static final int MIN_TRANSFORM_INTERVAL_MS = 100;
    private final Executor mExecutor;
    private final PooledByteBufferFactory mPooledByteBufferFactory;
    private final boolean mResizingEnabled;
    private final Producer<EncodedImage> mInputProducer;
    private final boolean mUseDownsamplingRatio;

    public ResizeAndRotateProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, boolean resizingEnabled, Producer<EncodedImage> inputProducer, boolean useDownsamplingRatio) {
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.mPooledByteBufferFactory = (PooledByteBufferFactory)Preconditions.checkNotNull((Object)pooledByteBufferFactory);
        this.mResizingEnabled = resizingEnabled;
        this.mInputProducer = (Producer)Preconditions.checkNotNull(inputProducer);
        this.mUseDownsamplingRatio = useDownsamplingRatio;
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext context) {
        this.mInputProducer.produceResults(new TransformingConsumer(consumer, context), context);
    }

    private static TriState shouldTransform(ImageRequest request, EncodedImage encodedImage, boolean resizingEnabled) {
        if (encodedImage == null || encodedImage.getImageFormat() == ImageFormat.UNKNOWN) {
            return TriState.UNSET;
        }
        if (encodedImage.getImageFormat() != DefaultImageFormats.JPEG) {
            return TriState.NO;
        }
        return TriState.valueOf((ResizeAndRotateProducer.shouldRotate(request.getRotationOptions(), encodedImage) || ResizeAndRotateProducer.shouldResize(ResizeAndRotateProducer.getSoftwareNumerator(request, encodedImage, resizingEnabled)) ? 1 : 0) != 0);
    }

    @VisibleForTesting
    static float determineResizeRatio(ResizeOptions resizeOptions, int width, int height) {
        if (resizeOptions == null) {
            return 1.0f;
        }
        float widthRatio = (float)resizeOptions.width / (float)width;
        float heightRatio = (float)resizeOptions.height / (float)height;
        float ratio = Math.max(widthRatio, heightRatio);
        if ((float)width * ratio > resizeOptions.maxBitmapSize) {
            ratio = resizeOptions.maxBitmapSize / (float)width;
        }
        if ((float)height * ratio > resizeOptions.maxBitmapSize) {
            ratio = resizeOptions.maxBitmapSize / (float)height;
        }
        return ratio;
    }

    @VisibleForTesting
    static int roundNumerator(float maxRatio, float roundUpFraction) {
        return (int)(roundUpFraction + maxRatio * 8.0f);
    }

    private static int getSoftwareNumerator(ImageRequest imageRequest, EncodedImage encodedImage, boolean resizingEnabled) {
        int heightAfterRotation;
        if (!resizingEnabled) {
            return 8;
        }
        ResizeOptions resizeOptions = imageRequest.getResizeOptions();
        if (resizeOptions == null) {
            return 8;
        }
        int rotationAngle = ResizeAndRotateProducer.getRotationAngle(imageRequest.getRotationOptions(), encodedImage);
        boolean swapDimensions = rotationAngle == 90 || rotationAngle == 270;
        int widthAfterRotation = swapDimensions ? encodedImage.getHeight() : encodedImage.getWidth();
        float ratio = ResizeAndRotateProducer.determineResizeRatio(resizeOptions, widthAfterRotation, heightAfterRotation = swapDimensions ? encodedImage.getWidth() : encodedImage.getHeight());
        int numerator = ResizeAndRotateProducer.roundNumerator(ratio, resizeOptions.roundUpFraction);
        if (numerator > 8) {
            return 8;
        }
        return numerator < 1 ? 1 : numerator;
    }

    private static int getRotationAngle(RotationOptions rotationOptions, EncodedImage encodedImage) {
        if (!rotationOptions.rotationEnabled()) {
            return 0;
        }
        int rotationFromMetadata = ResizeAndRotateProducer.extractOrientationFromMetadata(encodedImage);
        if (rotationOptions.useImageMetadata()) {
            return rotationFromMetadata;
        }
        return (rotationFromMetadata + rotationOptions.getForcedAngle()) % 360;
    }

    private static int extractOrientationFromMetadata(EncodedImage encodedImage) {
        switch (encodedImage.getRotationAngle()) {
            case 90: 
            case 180: 
            case 270: {
                return encodedImage.getRotationAngle();
            }
        }
        return 0;
    }

    private static boolean shouldResize(int numerator) {
        return numerator < 8;
    }

    private static boolean shouldRotate(RotationOptions rotationOptions, EncodedImage encodedImage) {
        return !rotationOptions.canDeferUntilRendered() && ResizeAndRotateProducer.getRotationAngle(rotationOptions, encodedImage) != 0;
    }

    @VisibleForTesting
    static int calculateDownsampleNumerator(int downsampleRatio) {
        return Math.max(1, 8 / downsampleRatio);
    }

    private class TransformingConsumer
    extends DelegatingConsumer<EncodedImage, EncodedImage> {
        private final ProducerContext mProducerContext;
        private boolean mIsCancelled;
        private final JobScheduler mJobScheduler;

        public TransformingConsumer(final Consumer<EncodedImage> consumer, ProducerContext producerContext) {
            super(consumer);
            this.mIsCancelled = false;
            this.mProducerContext = producerContext;
            JobScheduler.JobRunnable job = new JobScheduler.JobRunnable(){

                @Override
                public void run(EncodedImage encodedImage, boolean isLast) {
                    TransformingConsumer.this.doTransform(encodedImage, isLast);
                }
            };
            this.mJobScheduler = new JobScheduler(ResizeAndRotateProducer.this.mExecutor, job, 100);
            this.mProducerContext.addCallbacks(new BaseProducerContextCallbacks(){

                @Override
                public void onIsIntermediateResultExpectedChanged() {
                    if (TransformingConsumer.this.mProducerContext.isIntermediateResultExpected()) {
                        TransformingConsumer.this.mJobScheduler.scheduleJob();
                    }
                }

                @Override
                public void onCancellationRequested() {
                    TransformingConsumer.this.mJobScheduler.clearJob();
                    TransformingConsumer.this.mIsCancelled = true;
                    consumer.onCancellation();
                }
            });
        }

        @Override
        protected void onNewResultImpl(@Nullable EncodedImage newResult, boolean isLast) {
            if (this.mIsCancelled) {
                return;
            }
            if (newResult == null) {
                if (isLast) {
                    this.getConsumer().onNewResult(null, true);
                }
                return;
            }
            TriState shouldTransform = ResizeAndRotateProducer.shouldTransform(this.mProducerContext.getImageRequest(), newResult, ResizeAndRotateProducer.this.mResizingEnabled);
            if (!isLast && shouldTransform == TriState.UNSET) {
                return;
            }
            if (shouldTransform != TriState.YES) {
                this.getConsumer().onNewResult(newResult, isLast);
                return;
            }
            if (!this.mJobScheduler.updateJob(newResult, isLast)) {
                return;
            }
            if (isLast || this.mProducerContext.isIntermediateResultExpected()) {
                this.mJobScheduler.scheduleJob();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doTransform(EncodedImage encodedImage, boolean isLast) {
            this.mProducerContext.getListener().onProducerStart(this.mProducerContext.getId(), ResizeAndRotateProducer.PRODUCER_NAME);
            ImageRequest imageRequest = this.mProducerContext.getImageRequest();
            PooledByteBufferOutputStream outputStream = ResizeAndRotateProducer.this.mPooledByteBufferFactory.newOutputStream();
            Map<String, String> extraMap = null;
            EncodedImage ret = null;
            InputStream is = null;
            try {
                int softwareNumerator = ResizeAndRotateProducer.getSoftwareNumerator(imageRequest, encodedImage, ResizeAndRotateProducer.this.mResizingEnabled);
                int downsampleRatio = DownsampleUtil.determineSampleSize(imageRequest, encodedImage);
                int downsampleNumerator = ResizeAndRotateProducer.calculateDownsampleNumerator(downsampleRatio);
                int numerator = ResizeAndRotateProducer.this.mUseDownsamplingRatio ? downsampleNumerator : softwareNumerator;
                int rotationAngle = ResizeAndRotateProducer.getRotationAngle(imageRequest.getRotationOptions(), encodedImage);
                extraMap = this.getExtraMap(encodedImage, imageRequest, numerator, downsampleNumerator, softwareNumerator, rotationAngle);
                is = encodedImage.getInputStream();
                JpegTranscoder.transcodeJpeg(is, (OutputStream)outputStream, rotationAngle, numerator, 85);
                CloseableReference ref = CloseableReference.of((Closeable)outputStream.toByteBuffer());
                try {
                    ret = new EncodedImage(ref);
                    ret.setImageFormat(DefaultImageFormats.JPEG);
                    try {
                        ret.parseMetaData();
                        this.mProducerContext.getListener().onProducerFinishWithSuccess(this.mProducerContext.getId(), ResizeAndRotateProducer.PRODUCER_NAME, extraMap);
                        this.getConsumer().onNewResult(ret, isLast);
                    }
                    finally {
                        EncodedImage.closeSafely((EncodedImage)ret);
                    }
                }
                finally {
                    CloseableReference.closeSafely((CloseableReference)ref);
                }
                Closeables.closeQuietly((InputStream)is);
            }
            catch (Exception e) {
                this.mProducerContext.getListener().onProducerFinishWithFailure(this.mProducerContext.getId(), ResizeAndRotateProducer.PRODUCER_NAME, e, extraMap);
                this.getConsumer().onFailure(e);
                return;
            }
            finally {
                Closeables.closeQuietly(is);
                outputStream.close();
            }
            outputStream.close();
        }

        private Map<String, String> getExtraMap(EncodedImage encodedImage, ImageRequest imageRequest, int numerator, int downsampleNumerator, int softwareNumerator, int rotationAngle) {
            if (!this.mProducerContext.getListener().requiresExtraMap(this.mProducerContext.getId())) {
                return null;
            }
            String originalSize = encodedImage.getWidth() + "x" + encodedImage.getHeight();
            String requestedSize = imageRequest.getResizeOptions() != null ? imageRequest.getResizeOptions().width + "x" + imageRequest.getResizeOptions().height : "Unspecified";
            String fraction = numerator > 0 ? numerator + "/8" : "";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(ResizeAndRotateProducer.ORIGINAL_SIZE_KEY, originalSize);
            map.put(ResizeAndRotateProducer.REQUESTED_SIZE_KEY, requestedSize);
            map.put(ResizeAndRotateProducer.FRACTION_KEY, fraction);
            map.put("queueTime", String.valueOf(this.mJobScheduler.getQueuedTime()));
            map.put(ResizeAndRotateProducer.DOWNSAMPLE_ENUMERATOR_KEY, Integer.toString(downsampleNumerator));
            map.put(ResizeAndRotateProducer.SOFTWARE_ENUMERATOR_KEY, Integer.toString(softwareNumerator));
            map.put(ResizeAndRotateProducer.ROTATION_ANGLE_KEY, Integer.toString(rotationAngle));
            return ImmutableMap.copyOf(map);
        }
    }
}

