/*
 *   OneModule.java
 *   Thunderhead
 *
 *   Copyright © 2017 Thunderhead. All rights reserved.
 */

package com.thunderhead.one.react;

import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableNativeMap;
import com.thunderhead.One;
import com.thunderhead.OneModes;
import java.util.HashMap;

public class OneModule extends ReactContextBaseJavaModule {

    final One one;

    public OneModule(ReactApplicationContext reactContext) {
        super(reactContext);
        one = One.getInstance(getReactApplicationContext());
    }

    @Override
    public String getName() {
        return "One";
    }

    @ReactMethod
    public void init(String siteKey, String touchpointUri, String apiKey,
                     String sharedSecret, String userId, boolean isAdminMode,
                     String hostName) {
        if (isAdminMode) {
            one.init(siteKey,touchpointUri,apiKey,sharedSecret, userId, OneModes.ADMIN_MODE, hostName);
        } else {
            one.init(siteKey,touchpointUri,apiKey,sharedSecret, userId, OneModes.USER_MODE, hostName);
        }
        one.disableAutomaticInteractionDetection(true);
    }

    @ReactMethod
    public void sendInteraction(String interaction, ReadableMap propertiesMap) {
        HashMap<String, String> properties = getPropertiesFromReadableMap(propertiesMap);
        if (properties != null && !properties.isEmpty()) {
            one.sendInteraction(interaction, properties);
        } else  {
            one.sendInteraction(interaction);
        }
    }

    @ReactMethod
    public void sendProperties(String interaction, ReadableMap propertiesMap) {
        HashMap<String, String> properties = getPropertiesFromReadableMap(propertiesMap);
        one.sendProperties(interaction, properties);
    }

    @ReactMethod
    public void sendBaseTouchpointProperties(ReadableMap propertiesMap) {
        HashMap<String, String> properties = getPropertiesFromReadableMap(propertiesMap);
        one.sendBaseTouchpointProperties(properties);
    }

    private HashMap<String, String> getPropertiesFromReadableMap(ReadableMap readableMap) {
        HashMap <String, String> properties = new HashMap<>();
        if (readableMap != null && readableMap instanceof ReadableNativeMap) {
            HashMap<String, Object> hashMap = ((ReadableNativeMap) readableMap).toHashMap();
            for (String key : hashMap.keySet()) {
                Object value = hashMap.get(key);
                if (value instanceof String) {
                    properties.put(key, (String) value);
                }
            }
        }
        return properties;
    }

}