//
//  RCTOne.m
//  RCTOne
//
//  Created by Maksim Kazimirski on 2/15/17.
//  Copyright © 2017 Thunderhead. All rights reserved.
//

#import "RCTOne.h"
#import "RCTConvert+OneLogLevel.h"
#import <UIKit/UIKit.h>
#import <Thunderhead/One.h>

@implementation RCTOne

RCT_EXPORT_MODULE(One)

RCT_EXPORT_METHOD(init:(NSString *)siteKey uri:(NSString *)uri apiKey:(NSString *)apiKey sharedSecret:(NSString *)sharedSecret userId:(NSString *)userId adminMode:(BOOL)adminMode hostName:(NSString *)hostName)
{
    [One startSessionWithSK:siteKey
                        uri:uri
                     apiKey:apiKey
               sharedSecret:sharedSecret
                     userId:userId
                  adminMode:adminMode
                   hostName:hostName];
    [One disableAutomaticInteractionDetection:NO];
}

RCT_EXPORT_METHOD(setLogLevel:(OneLogLevel)level)
{
    [One setLogLevel:level];
}

RCT_EXPORT_METHOD(sendInteraction:(NSString *)interaction withProperties:(NSDictionary *)properties)
{
    [One sendInteraction:interaction withProperties:properties];
}

RCT_EXPORT_METHOD(sendProperties:(NSDictionary *)properties forInteraction:(NSString *)interaction)
{
    [One sendProperties:properties forInteractionPath:interaction];
}

RCT_EXPORT_METHOD(sendBaseTouchpointProperties:(NSDictionary *)properties)
{
    [One sendBaseTouchpointProperties:properties];
}

- (NSDictionary *)constantsToExport
{
    return @{ @"LogLevelNone" : @(kOneLogLevelNone),
              @"LogLevelAll" : @(kOneLogLevelAll),
              @"LogLevelWebService" : @(kOneLogLevelWebService),
              @"LogLevelFramework" : @(kOneLogLevelFramework)
              };
}

- (dispatch_queue_t)methodQueue
{
    return dispatch_get_main_queue();
}

@end
