/*
 * Decompiled with CFR 0.152.
 */
package im.shimo.react.preference;

import android.content.SharedPreferences;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.WritableMap;
import java.util.HashMap;
import java.util.Map;

public class PreferenceModule
extends ReactContextBaseJavaModule {
    private String mPackageName;

    public PreferenceModule(ReactApplicationContext context) {
        super(context);
        this.mPackageName = context.getPackageName();
    }

    public String getName() {
        return "RNPreferenceManager";
    }

    @ReactMethod
    public void set(ReadableMap data, Promise promise) {
        SharedPreferences.Editor editor = this.getEditor();
        ReadableMapKeySetIterator iterator = data.keySetIterator();
        while (iterator.hasNextKey()) {
            String key = iterator.nextKey();
            editor.putString(key, data.getString(key)).commit();
        }
        promise.resolve((Object)this.getPreferences());
    }

    @ReactMethod
    public void clearAll(Promise promise) {
        SharedPreferences.Editor editor = this.getEditor();
        Map allEntries = this.getSharedPreferences().getAll();
        for (Map.Entry entry : allEntries.entrySet()) {
            editor.remove((String)entry.getKey());
        }
        editor.commit();
        promise.resolve((Object)this.getPreferences());
    }

    @ReactMethod
    public void sync(Promise promise) {
        promise.resolve((Object)this.getPreferences());
    }

    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("InitialPreferences", this.getPreferences());
        return constants;
    }

    private ReadableMap getPreferences() {
        WritableMap result = Arguments.createMap();
        Map allEntries = this.getSharedPreferences().getAll();
        for (Map.Entry entry : allEntries.entrySet()) {
            result.putString((String)entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    private SharedPreferences getSharedPreferences() {
        return this.getReactApplicationContext().getSharedPreferences(this.mPackageName, 0);
    }

    private SharedPreferences.Editor getEditor() {
        return this.getSharedPreferences().edit();
    }
}

