/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.TextView;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import com.facebook.react.bridge.UiThreadUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.annotation.Nullable;

public class DevLoadingViewController {
    private static final int COLOR_DARK_GREEN = Color.parseColor((String)"#035900");
    private static boolean sEnabled = true;
    private final Context mContext;
    private final WindowManager mWindowManager;
    private TextView mDevLoadingView;
    private boolean mIsVisible = false;

    public static void setDevLoadingEnabled(boolean enabled) {
        sEnabled = enabled;
    }

    public DevLoadingViewController(Context context) {
        this.mContext = context;
        this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mDevLoadingView = (TextView)inflater.inflate(R.layout.dev_loading_view, null);
    }

    public void showMessage(final String message, final int color, final int backgroundColor) {
        if (!sEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DevLoadingViewController.this.mDevLoadingView.setBackgroundColor(backgroundColor);
                DevLoadingViewController.this.mDevLoadingView.setText((CharSequence)message);
                DevLoadingViewController.this.mDevLoadingView.setTextColor(color);
                DevLoadingViewController.this.setVisible(true);
            }
        });
    }

    public void showForUrl(String url) {
        URL parsedURL;
        try {
            parsedURL = new URL(url);
        }
        catch (MalformedURLException e) {
            FLog.e((String)"React", (String)("Bundle url format is invalid. \n\n" + e.toString()));
            return;
        }
        this.showMessage(this.mContext.getString(R.string.catalyst_loading_from_url, new Object[]{parsedURL.getHost() + ":" + parsedURL.getPort()}), -1, COLOR_DARK_GREEN);
    }

    public void showForRemoteJSEnabled() {
        this.showMessage(this.mContext.getString(R.string.catalyst_remotedbg_message), -1, COLOR_DARK_GREEN);
    }

    public void updateProgress(final @Nullable String status, final @Nullable Integer done, final @Nullable Integer total) {
        if (!sEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                StringBuilder message = new StringBuilder();
                message.append(status != null ? status : "Loading");
                if (done != null && total != null && total > 0) {
                    message.append(String.format(Locale.getDefault(), " %.1f%% (%d/%d)", Float.valueOf((float)done.intValue() / (float)total.intValue() * 100.0f), done, total));
                }
                message.append("\u2026");
                DevLoadingViewController.this.mDevLoadingView.setText((CharSequence)message);
            }
        });
    }

    public void show() {
        if (!sEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DevLoadingViewController.this.setVisible(true);
            }
        });
    }

    public void hide() {
        if (!sEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DevLoadingViewController.this.setVisible(false);
            }
        });
    }

    private void setVisible(boolean visible) {
        if (visible && !this.mIsVisible) {
            WindowManager.LayoutParams params = new WindowManager.LayoutParams(-1, -2, 2006, 8, -3);
            params.gravity = 48;
            this.mWindowManager.addView((View)this.mDevLoadingView, (ViewGroup.LayoutParams)params);
        } else if (!visible && this.mIsVisible) {
            this.mWindowManager.removeView((View)this.mDevLoadingView);
        }
        this.mIsVisible = visible;
    }
}

