/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import android.util.SparseArray;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ExecutorToken;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.OnExecutorUnregisteredListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.common.SystemClock;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.jstasks.HeadlessJsTaskContext;
import com.facebook.react.jstasks.HeadlessJsTaskEventListener;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.ChoreographerCompat;
import com.facebook.react.modules.core.JSTimersExecution;
import com.facebook.react.modules.core.ReactChoreographer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

@ReactModule(name="Timing", supportsWebWorkers=true)
public final class Timing
extends ReactContextBaseJavaModule
implements LifecycleEventListener,
OnExecutorUnregisteredListener,
HeadlessJsTaskEventListener {
    protected static final String NAME = "Timing";
    private static final float IDLE_CALLBACK_FRAME_DEADLINE_MS = 1.0f;
    private static final float FRAME_DURATION_MS = 16.666666f;
    private final DevSupportManager mDevSupportManager;
    private final Object mTimerGuard = new Object();
    private final Object mIdleCallbackGuard = new Object();
    private final PriorityQueue<Timer> mTimers;
    private final Map<ExecutorToken, SparseArray<Timer>> mTimerIdsToTimers;
    private final AtomicBoolean isPaused = new AtomicBoolean(true);
    private final AtomicBoolean isRunningTasks = new AtomicBoolean(false);
    private final TimerFrameCallback mTimerFrameCallback = new TimerFrameCallback();
    private final IdleFrameCallback mIdleFrameCallback = new IdleFrameCallback();
    @Nullable
    private IdleCallbackRunnable mCurrentIdleCallbackRunnable;
    @Nullable
    private ReactChoreographer mReactChoreographer;
    private boolean mFrameCallbackPosted = false;
    private boolean mFrameIdleCallbackPosted = false;
    private final Set<ExecutorToken> mSendIdleEventsExecutorTokens;
    private final List<ExecutorToken> mIdleCallbackContextsToCall;

    public Timing(ReactApplicationContext reactContext, DevSupportManager devSupportManager) {
        super(reactContext);
        this.mDevSupportManager = devSupportManager;
        this.mTimers = new PriorityQueue<Timer>(11, new Comparator<Timer>(){

            @Override
            public int compare(Timer lhs, Timer rhs) {
                long diff = lhs.mTargetTime - rhs.mTargetTime;
                if (diff == 0L) {
                    return 0;
                }
                if (diff < 0L) {
                    return -1;
                }
                return 1;
            }
        });
        this.mTimerIdsToTimers = new HashMap<ExecutorToken, SparseArray<Timer>>();
        this.mSendIdleEventsExecutorTokens = new HashSet<ExecutorToken>();
        this.mIdleCallbackContextsToCall = new ArrayList<ExecutorToken>();
    }

    @Override
    public void initialize() {
        this.getReactApplicationContext().addLifecycleEventListener(this);
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance(this.getReactApplicationContext());
        headlessJsTaskContext.addTaskEventListener(this);
    }

    @Override
    public void onHostPause() {
        this.isPaused.set(true);
        this.clearFrameCallback();
        this.maybeIdleCallback();
    }

    @Override
    public void onHostDestroy() {
        this.clearFrameCallback();
        this.maybeIdleCallback();
    }

    @Override
    public void onHostResume() {
        if (this.mReactChoreographer == null) {
            this.mReactChoreographer = ReactChoreographer.getInstance();
        }
        this.isPaused.set(false);
        this.setChoreographerCallback();
        this.maybeSetChoreographerIdleCallback();
    }

    @Override
    public void onHeadlessJsTaskStart(int taskId) {
        if (this.mReactChoreographer == null) {
            this.mReactChoreographer = ReactChoreographer.getInstance();
        }
        if (!this.isRunningTasks.getAndSet(true)) {
            this.setChoreographerCallback();
            this.maybeSetChoreographerIdleCallback();
        }
    }

    @Override
    public void onHeadlessJsTaskFinish(int taskId) {
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance(this.getReactApplicationContext());
        if (!headlessJsTaskContext.hasActiveTasks()) {
            this.isRunningTasks.set(false);
            this.clearFrameCallback();
            this.maybeIdleCallback();
        }
    }

    @Override
    public void onCatalystInstanceDestroy() {
        this.clearFrameCallback();
        this.clearChoreographerIdleCallback();
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance(this.getReactApplicationContext());
        headlessJsTaskContext.removeTaskEventListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeSetChoreographerIdleCallback() {
        Object object = this.mIdleCallbackGuard;
        synchronized (object) {
            if (this.mSendIdleEventsExecutorTokens.size() > 0) {
                this.setChoreographerIdleCallback();
            }
        }
    }

    private void maybeIdleCallback() {
        if (this.isPaused.get() && !this.isRunningTasks.get()) {
            this.clearFrameCallback();
        }
    }

    private void setChoreographerCallback() {
        if (!this.mFrameCallbackPosted) {
            ((ReactChoreographer)Assertions.assertNotNull((Object)this.mReactChoreographer)).postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this.mTimerFrameCallback);
            this.mFrameCallbackPosted = true;
        }
    }

    private void clearFrameCallback() {
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance(this.getReactApplicationContext());
        if (this.mFrameCallbackPosted && this.isPaused.get() && !headlessJsTaskContext.hasActiveTasks()) {
            ((ReactChoreographer)Assertions.assertNotNull((Object)this.mReactChoreographer)).removeFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this.mTimerFrameCallback);
            this.mFrameCallbackPosted = false;
        }
    }

    private void setChoreographerIdleCallback() {
        if (!this.mFrameIdleCallbackPosted) {
            ((ReactChoreographer)Assertions.assertNotNull((Object)this.mReactChoreographer)).postFrameCallback(ReactChoreographer.CallbackType.IDLE_EVENT, this.mIdleFrameCallback);
            this.mFrameIdleCallbackPosted = true;
        }
    }

    private void clearChoreographerIdleCallback() {
        if (this.mFrameIdleCallbackPosted) {
            ((ReactChoreographer)Assertions.assertNotNull((Object)this.mReactChoreographer)).removeFrameCallback(ReactChoreographer.CallbackType.IDLE_EVENT, this.mIdleFrameCallback);
            this.mFrameIdleCallbackPosted = false;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean supportsWebWorkers() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExecutorDestroyed(ExecutorToken executorToken) {
        Object object = this.mTimerGuard;
        synchronized (object) {
            SparseArray<Timer> timersForContext = this.mTimerIdsToTimers.remove(executorToken);
            if (timersForContext == null) {
                return;
            }
            for (int i = 0; i < timersForContext.size(); ++i) {
                Timer timer = (Timer)timersForContext.get(timersForContext.keyAt(i));
                this.mTimers.remove(timer);
            }
        }
        object = this.mIdleCallbackGuard;
        synchronized (object) {
            this.mSendIdleEventsExecutorTokens.remove(executorToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReactMethod
    public void createTimer(ExecutorToken executorToken, int callbackID, int duration, double jsSchedulingTime, boolean repeat) {
        long driftTime;
        long deviceTime = SystemClock.currentTimeMillis();
        long remoteTime = (long)jsSchedulingTime;
        if (this.mDevSupportManager.getDevSupportEnabled() && (driftTime = Math.abs(remoteTime - deviceTime)) > 60000L) {
            this.getReactApplicationContext().getJSModule(executorToken, JSTimersExecution.class).emitTimeDriftWarning("Debugger and device times have drifted by more than 60s. Please correct this by running adb shell \"date `date +%m%d%H%M%Y.%S`\" on your debugger machine.");
        }
        long adjustedDuration = Math.max(0L, remoteTime - deviceTime + (long)duration);
        if (duration == 0 && !repeat) {
            WritableArray timerToCall = Arguments.createArray();
            timerToCall.pushInt(callbackID);
            this.getReactApplicationContext().getJSModule(executorToken, JSTimersExecution.class).callTimers(timerToCall);
            return;
        }
        long initialTargetTime = SystemClock.nanoTime() / 1000000L + adjustedDuration;
        Timer timer = new Timer(executorToken, callbackID, initialTargetTime, duration, repeat);
        Object object = this.mTimerGuard;
        synchronized (object) {
            this.mTimers.add(timer);
            SparseArray timersForContext = this.mTimerIdsToTimers.get(executorToken);
            if (timersForContext == null) {
                timersForContext = new SparseArray();
                this.mTimerIdsToTimers.put(executorToken, (SparseArray<Timer>)timersForContext);
            }
            timersForContext.put(callbackID, (Object)timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReactMethod
    public void deleteTimer(ExecutorToken executorToken, int timerId) {
        Object object = this.mTimerGuard;
        synchronized (object) {
            SparseArray<Timer> timersForContext = this.mTimerIdsToTimers.get(executorToken);
            if (timersForContext == null) {
                return;
            }
            Timer timer = (Timer)timersForContext.get(timerId);
            if (timer == null) {
                return;
            }
            timersForContext.remove(timerId);
            if (timersForContext.size() == 0) {
                this.mTimerIdsToTimers.remove(executorToken);
            }
            this.mTimers.remove(timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReactMethod
    public void setSendIdleEvents(ExecutorToken executorToken, boolean sendIdleEvents) {
        Object object = this.mIdleCallbackGuard;
        synchronized (object) {
            if (sendIdleEvents) {
                this.mSendIdleEventsExecutorTokens.add(executorToken);
            } else {
                this.mSendIdleEventsExecutorTokens.remove(executorToken);
            }
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = Timing.this.mIdleCallbackGuard;
                synchronized (object) {
                    if (Timing.this.mSendIdleEventsExecutorTokens.size() > 0) {
                        Timing.this.setChoreographerIdleCallback();
                    } else {
                        Timing.this.clearChoreographerIdleCallback();
                    }
                }
            }
        });
    }

    private class IdleCallbackRunnable
    implements Runnable {
        private volatile boolean mCancelled = false;
        private final long mFrameStartTime;

        public IdleCallbackRunnable(long frameStartTime) {
            this.mFrameStartTime = frameStartTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.mCancelled) {
                return;
            }
            long frameTimeMillis = this.mFrameStartTime / 1000000L;
            long timeSinceBoot = SystemClock.uptimeMillis();
            long frameTimeElapsed = timeSinceBoot - frameTimeMillis;
            long time = SystemClock.currentTimeMillis();
            long absoluteFrameStartTime = time - frameTimeElapsed;
            if (16.666666f - (float)frameTimeElapsed < 1.0f) {
                return;
            }
            Timing.this.mIdleCallbackContextsToCall.clear();
            Iterator iterator = Timing.this.mIdleCallbackGuard;
            synchronized (iterator) {
                Timing.this.mIdleCallbackContextsToCall.addAll(Timing.this.mSendIdleEventsExecutorTokens);
            }
            for (ExecutorToken context : Timing.this.mIdleCallbackContextsToCall) {
                Timing.this.getReactApplicationContext().getJSModule(context, JSTimersExecution.class).callIdleCallbacks(absoluteFrameStartTime);
            }
            Timing.this.mCurrentIdleCallbackRunnable = null;
        }

        public void cancel() {
            this.mCancelled = true;
        }
    }

    private class IdleFrameCallback
    extends ChoreographerCompat.FrameCallback {
        private IdleFrameCallback() {
        }

        @Override
        public void doFrame(long frameTimeNanos) {
            if (Timing.this.isPaused.get() && !Timing.this.isRunningTasks.get()) {
                return;
            }
            if (Timing.this.mCurrentIdleCallbackRunnable != null) {
                Timing.this.mCurrentIdleCallbackRunnable.cancel();
            }
            Timing.this.mCurrentIdleCallbackRunnable = new IdleCallbackRunnable(frameTimeNanos);
            Timing.this.getReactApplicationContext().runOnJSQueueThread(Timing.this.mCurrentIdleCallbackRunnable);
            ((ReactChoreographer)Assertions.assertNotNull((Object)Timing.this.mReactChoreographer)).postFrameCallback(ReactChoreographer.CallbackType.IDLE_EVENT, this);
        }
    }

    private class TimerFrameCallback
    extends ChoreographerCompat.FrameCallback {
        private final HashMap<ExecutorToken, WritableArray> mTimersToCall = new HashMap();

        private TimerFrameCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doFrame(long frameTimeNanos) {
            if (Timing.this.isPaused.get() && !Timing.this.isRunningTasks.get()) {
                return;
            }
            long frameTimeMillis = frameTimeNanos / 1000000L;
            Iterator<Map.Entry<ExecutorToken, WritableArray>> iterator = Timing.this.mTimerGuard;
            synchronized (iterator) {
                while (!Timing.this.mTimers.isEmpty() && ((Timer)Timing.this.mTimers.peek()).mTargetTime < frameTimeMillis) {
                    Timer timer = (Timer)Timing.this.mTimers.poll();
                    WritableArray timersForContext = this.mTimersToCall.get(timer.mExecutorToken);
                    if (timersForContext == null) {
                        timersForContext = Arguments.createArray();
                        this.mTimersToCall.put(timer.mExecutorToken, timersForContext);
                    }
                    timersForContext.pushInt(timer.mCallbackID);
                    if (timer.mRepeat) {
                        timer.mTargetTime = frameTimeMillis + (long)timer.mInterval;
                        Timing.this.mTimers.add(timer);
                        continue;
                    }
                    SparseArray timers = (SparseArray)Timing.this.mTimerIdsToTimers.get(timer.mExecutorToken);
                    if (timers == null) continue;
                    timers.remove(timer.mCallbackID);
                    if (timers.size() != 0) continue;
                    Timing.this.mTimerIdsToTimers.remove(timer.mExecutorToken);
                }
            }
            for (Map.Entry<ExecutorToken, WritableArray> entry : this.mTimersToCall.entrySet()) {
                Timing.this.getReactApplicationContext().getJSModule(entry.getKey(), JSTimersExecution.class).callTimers(entry.getValue());
            }
            this.mTimersToCall.clear();
            ((ReactChoreographer)Assertions.assertNotNull((Object)Timing.this.mReactChoreographer)).postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this);
        }
    }

    private static class Timer {
        private final ExecutorToken mExecutorToken;
        private final int mCallbackID;
        private final boolean mRepeat;
        private final int mInterval;
        private long mTargetTime;

        private Timer(ExecutorToken executorToken, int callbackID, long initialTargetTime, int duration, boolean repeat) {
            this.mExecutorToken = executorToken;
            this.mCallbackID = callbackID;
            this.mTargetTime = initialTargetTime;
            this.mInterval = duration;
            this.mRepeat = repeat;
        }
    }
}

