/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.common.futures;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public class SimpleSettableFuture<T>
implements Future<T> {
    private final CountDownLatch mReadyLatch = new CountDownLatch(1);
    @Nullable
    private T mResult;
    @Nullable
    private Exception mException;

    public void set(@Nullable T result) {
        this.checkNotSet();
        this.mResult = result;
        this.mReadyLatch.countDown();
    }

    public void setException(Exception exception) {
        this.checkNotSet();
        this.mException = exception;
        this.mReadyLatch.countDown();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.mReadyLatch.getCount() == 0L;
    }

    @Override
    @Nullable
    public T get() throws InterruptedException, ExecutionException {
        this.mReadyLatch.await();
        if (this.mException != null) {
            throw new ExecutionException(this.mException);
        }
        return this.mResult;
    }

    @Override
    @Nullable
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.mReadyLatch.await(timeout, unit)) {
            throw new TimeoutException("Timed out waiting for result");
        }
        if (this.mException != null) {
            throw new ExecutionException(this.mException);
        }
        return this.mResult;
    }

    @Nullable
    public T getOrThrow() {
        try {
            return this.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public T getOrThrow(long timeout, TimeUnit unit) {
        try {
            return this.get(timeout, unit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkNotSet() {
        if (this.mReadyLatch.getCount() == 0L) {
            throw new RuntimeException("Result has already been set!");
        }
    }
}

