/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.soloader;

import android.content.Context;
import android.os.Parcel;
import android.util.Log;
import com.facebook.soloader.DirectorySoSource;
import com.facebook.soloader.FileLocker;
import com.facebook.soloader.SysUtil;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;

public abstract class UnpackingSoSource
extends DirectorySoSource {
    private static final String TAG = "fb-UnpackingSoSource";
    private static final String STATE_FILE_NAME = "dso_state";
    private static final String LOCK_FILE_NAME = "dso_lock";
    private static final String DEPS_FILE_NAME = "dso_deps";
    private static final String MANIFEST_FILE_NAME = "dso_manifest";
    private static final byte STATE_DIRTY = 0;
    private static final byte STATE_CLEAN = 1;
    private static final byte MANIFEST_VERSION = 1;
    protected final Context mContext;

    protected UnpackingSoSource(Context context, String name) {
        super(UnpackingSoSource.getSoStorePath(context, name), 1);
        this.mContext = context;
    }

    public static File getSoStorePath(Context context, String name) {
        return new File(context.getApplicationInfo().dataDir + "/" + name);
    }

    protected abstract Unpacker makeUnpacker() throws IOException;

    private static void writeState(File stateFileName, byte state) throws IOException {
        try (RandomAccessFile stateFile = new RandomAccessFile(stateFileName, "rw");){
            stateFile.seek(0L);
            stateFile.write(state);
            stateFile.setLength(stateFile.getFilePointer());
            stateFile.getFD().sync();
        }
    }

    private void deleteUnmentionedFiles(Dso[] dsos) throws IOException {
        String[] existingFiles = this.soDirectory.list();
        if (existingFiles == null) {
            throw new IOException("unable to list directory " + this.soDirectory);
        }
        for (int i = 0; i < existingFiles.length; ++i) {
            String fileName = existingFiles[i];
            if (fileName.equals(STATE_FILE_NAME) || fileName.equals(LOCK_FILE_NAME) || fileName.equals(DEPS_FILE_NAME) || fileName.equals(MANIFEST_FILE_NAME)) continue;
            boolean found = false;
            for (int j = 0; !found && j < dsos.length; ++j) {
                if (!dsos[j].name.equals(fileName)) continue;
                found = true;
            }
            if (found) continue;
            File fileNameToDelete = new File(this.soDirectory, fileName);
            Log.v((String)TAG, (String)("deleting unaccounted-for file " + fileNameToDelete));
            SysUtil.dumbDeleteRecursive(fileNameToDelete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractDso(InputDso iDso, byte[] ioBuffer) throws IOException {
        Log.i((String)TAG, (String)("extracting DSO " + iDso.dso.name));
        File dsoFileName = new File(this.soDirectory, iDso.dso.name);
        RandomAccessFile dsoFile = null;
        try {
            dsoFile = new RandomAccessFile(dsoFileName, "rw");
        }
        catch (IOException ex) {
            Log.w((String)TAG, (String)("error overwriting " + dsoFileName + " trying to delete and start over"), (Throwable)ex);
            dsoFileName.delete();
            dsoFile = new RandomAccessFile(dsoFileName, "rw");
        }
        try {
            InputStream dsoContent = iDso.content;
            int sizeHint = dsoContent.available();
            if (sizeHint > 1) {
                SysUtil.fallocateIfSupported(dsoFile.getFD(), sizeHint);
            }
            SysUtil.copyBytes(dsoFile, iDso.content, Integer.MAX_VALUE, ioBuffer);
            dsoFile.setLength(dsoFile.getFilePointer());
            if (!dsoFileName.setExecutable(true, false)) {
                throw new IOException("cannot make file executable: " + dsoFileName);
            }
        }
        finally {
            dsoFile.close();
        }
    }

    private void regenerate(byte state, DsoManifest desiredManifest, InputDsoIterator dsoIterator) throws IOException {
        Log.v((String)TAG, (String)("regenerating DSO store " + this.getClass().getName()));
        File manifestFileName = new File(this.soDirectory, MANIFEST_FILE_NAME);
        try (RandomAccessFile manifestFile = new RandomAccessFile(manifestFileName, "rw");){
            DsoManifest existingManifest = null;
            if (state == 1) {
                try {
                    existingManifest = DsoManifest.read(manifestFile);
                }
                catch (Exception ex) {
                    Log.i((String)TAG, (String)"error reading existing DSO manifest", (Throwable)ex);
                }
            }
            if (existingManifest == null) {
                existingManifest = new DsoManifest(new Dso[0]);
            }
            this.deleteUnmentionedFiles(desiredManifest.dsos);
            byte[] ioBuffer = new byte[32768];
            while (dsoIterator.hasNext()) {
                InputDso iDso = dsoIterator.next();
                Throwable throwable = null;
                try {
                    boolean obsolete = true;
                    for (int i = 0; obsolete && i < existingManifest.dsos.length; ++i) {
                        if (!existingManifest.dsos[i].name.equals(iDso.dso.name) || !existingManifest.dsos[i].hash.equals(iDso.dso.hash)) continue;
                        obsolete = false;
                    }
                    if (!obsolete) continue;
                    this.extractDso(iDso, ioBuffer);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iDso == null) continue;
                    if (throwable != null) {
                        try {
                            iDso.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    iDso.close();
                }
            }
        }
    }

    private boolean refreshLocked(final FileLocker lock, int flags, final byte[] deps) throws IOException {
        DsoManifest desiredManifest;
        File depsFileName;
        File stateFileName;
        block57: {
            byte state;
            stateFileName = new File(this.soDirectory, STATE_FILE_NAME);
            try (RandomAccessFile stateFile = new RandomAccessFile(stateFileName, "rw");){
                try {
                    state = stateFile.readByte();
                    if (state != 1) {
                        Log.v((String)TAG, (String)("dso store " + this.soDirectory + " regeneration interrupted: wiping clean"));
                        state = 0;
                    }
                }
                catch (EOFException ex) {
                    state = 0;
                }
            }
            depsFileName = new File(this.soDirectory, DEPS_FILE_NAME);
            desiredManifest = null;
            try (RandomAccessFile depsFile = new RandomAccessFile(depsFileName, "rw");){
                byte[] existingDeps = new byte[(int)depsFile.length()];
                if (depsFile.read(existingDeps) != existingDeps.length) {
                    Log.v((String)TAG, (String)"short read of so store deps file: marking unclean");
                    state = 0;
                }
                if (!Arrays.equals(existingDeps, deps)) {
                    Log.v((String)TAG, (String)"deps mismatch on deps store: regenerating");
                    state = 0;
                }
                if (state != 0) break block57;
                Log.v((String)TAG, (String)"so store dirty: regenerating");
                UnpackingSoSource.writeState(stateFileName, (byte)0);
                try (Unpacker u = this.makeUnpacker();){
                    desiredManifest = u.getDsoManifest();
                    try (InputDsoIterator idi = u.openDsoIterator();){
                        this.regenerate(state, desiredManifest, idi);
                    }
                }
            }
        }
        if (desiredManifest == null) {
            return false;
        }
        final DsoManifest manifest = desiredManifest;
        Runnable syncer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        Log.v((String)UnpackingSoSource.TAG, (String)"starting syncer worker");
                        try (RandomAccessFile depsFile = new RandomAccessFile(depsFileName, "rw");){
                            depsFile.write(deps);
                            depsFile.setLength(depsFile.getFilePointer());
                        }
                        File manifestFileName = new File(UnpackingSoSource.this.soDirectory, UnpackingSoSource.MANIFEST_FILE_NAME);
                        try (RandomAccessFile manifestFile = new RandomAccessFile(manifestFileName, "rw");){
                            manifest.write(manifestFile);
                        }
                        SysUtil.fsyncRecursive(UnpackingSoSource.this.soDirectory);
                        UnpackingSoSource.writeState(stateFileName, (byte)1);
                    }
                    finally {
                        Log.v((String)UnpackingSoSource.TAG, (String)("releasing dso store lock for " + UnpackingSoSource.this.soDirectory + " (from syncer thread)"));
                        lock.close();
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        if ((flags & 1) != 0) {
            new Thread(syncer, "SoSync:" + this.soDirectory.getName()).start();
        } else {
            syncer.run();
        }
        return true;
    }

    protected byte[] getDepsBlock() throws IOException {
        Parcel parcel = Parcel.obtain();
        try (Unpacker u = this.makeUnpacker();){
            Dso[] dsos = u.getDsoManifest().dsos;
            parcel.writeByte((byte)1);
            parcel.writeInt(dsos.length);
            for (int i = 0; i < dsos.length; ++i) {
                parcel.writeString(dsos[i].name);
                parcel.writeString(dsos[i].hash);
            }
        }
        byte[] depsBlock = parcel.marshall();
        parcel.recycle();
        return depsBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepare(int flags) throws IOException {
        SysUtil.mkdirOrThrow(this.soDirectory);
        File lockFileName = new File(this.soDirectory, LOCK_FILE_NAME);
        FileLocker lock = FileLocker.lock(lockFileName);
        try {
            Log.v((String)TAG, (String)("locked dso store " + this.soDirectory));
            if (this.refreshLocked(lock, flags, this.getDepsBlock())) {
                lock = null;
            } else {
                Log.i((String)TAG, (String)("dso store is up-to-date: " + this.soDirectory));
            }
        }
        finally {
            if (lock != null) {
                Log.v((String)TAG, (String)("releasing dso store lock for " + this.soDirectory));
                lock.close();
            } else {
                Log.v((String)TAG, (String)("not releasing dso store lock for " + this.soDirectory + " (syncer thread started)"));
            }
        }
    }

    protected static abstract class Unpacker
    implements Closeable {
        protected Unpacker() {
        }

        protected abstract DsoManifest getDsoManifest() throws IOException;

        protected abstract InputDsoIterator openDsoIterator() throws IOException;

        @Override
        public void close() throws IOException {
        }
    }

    protected static abstract class InputDsoIterator
    implements Closeable {
        protected InputDsoIterator() {
        }

        public abstract boolean hasNext();

        public abstract InputDso next() throws IOException;

        @Override
        public void close() throws IOException {
        }
    }

    protected static final class InputDso
    implements Closeable {
        public final Dso dso;
        public final InputStream content;

        public InputDso(Dso dso, InputStream content) {
            this.dso = dso;
            this.content = content;
        }

        @Override
        public void close() throws IOException {
            this.content.close();
        }
    }

    public static final class DsoManifest {
        public final Dso[] dsos;

        public DsoManifest(Dso[] dsos) {
            this.dsos = dsos;
        }

        static final DsoManifest read(DataInput xdi) throws IOException {
            byte version = xdi.readByte();
            if (version != 1) {
                throw new RuntimeException("wrong dso manifest version");
            }
            int nrDso = xdi.readInt();
            if (nrDso < 0) {
                throw new RuntimeException("illegal number of shared libraries");
            }
            Dso[] dsos = new Dso[nrDso];
            for (int i = 0; i < nrDso; ++i) {
                dsos[i] = new Dso(xdi.readUTF(), xdi.readUTF());
            }
            return new DsoManifest(dsos);
        }

        public final void write(DataOutput xdo) throws IOException {
            xdo.writeByte(1);
            xdo.writeInt(this.dsos.length);
            for (int i = 0; i < this.dsos.length; ++i) {
                xdo.writeUTF(this.dsos[i].name);
                xdo.writeUTF(this.dsos[i].hash);
            }
        }
    }

    public static class Dso {
        public final String name;
        public final String hash;

        public Dso(String name, String hash) {
            this.name = name;
            this.hash = hash;
        }
    }
}

