/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import bolts.Continuation;
import bolts.Task;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.imagepipeline.cache.BufferedDiskCache;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.MediaVariationsIndex;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.MediaVariations;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;

public class MediaVariationsFallbackProducer
implements Producer<EncodedImage> {
    @VisibleForTesting
    static final String PRODUCER_NAME = "MediaVariationsFallbackProducer";
    public static final String EXTRA_CACHED_VALUE_FOUND = "cached_value_found";
    public static final String EXTRA_CACHED_VALUE_USED_AS_LAST = "cached_value_used_as_last";
    private final BufferedDiskCache mDefaultBufferedDiskCache;
    private final BufferedDiskCache mSmallImageBufferedDiskCache;
    private final CacheKeyFactory mCacheKeyFactory;
    private final MediaVariationsIndex mMediaVariationsIndex;
    private final Producer<EncodedImage> mInputProducer;

    public MediaVariationsFallbackProducer(BufferedDiskCache defaultBufferedDiskCache, BufferedDiskCache smallImageBufferedDiskCache, CacheKeyFactory cacheKeyFactory, MediaVariationsIndex mediaVariationsIndex, Producer<EncodedImage> inputProducer) {
        this.mDefaultBufferedDiskCache = defaultBufferedDiskCache;
        this.mSmallImageBufferedDiskCache = smallImageBufferedDiskCache;
        this.mCacheKeyFactory = cacheKeyFactory;
        this.mMediaVariationsIndex = mediaVariationsIndex;
        this.mInputProducer = inputProducer;
    }

    @Override
    public void produceResults(final Consumer<EncodedImage> consumer, final ProducerContext producerContext) {
        final ImageRequest imageRequest = producerContext.getImageRequest();
        final ResizeOptions resizeOptions = imageRequest.getResizeOptions();
        final MediaVariations mediaVariations = imageRequest.getMediaVariations();
        if (!imageRequest.isDiskCacheEnabled() || resizeOptions == null || resizeOptions.height <= 0 || resizeOptions.width <= 0 || mediaVariations == null) {
            this.startInputProducer(consumer, producerContext);
            return;
        }
        producerContext.getListener().onProducerStart(producerContext.getId(), PRODUCER_NAME);
        final AtomicBoolean isCancelled = new AtomicBoolean(false);
        if (mediaVariations.getVariants() != null) {
            this.chooseFromVariants(consumer, producerContext, mediaVariations, mediaVariations.getVariants(), imageRequest, resizeOptions, isCancelled);
        } else {
            Task<List<MediaVariations.Variant>> cachedVariantsTask = this.mMediaVariationsIndex.getCachedVariants(mediaVariations.getMediaId());
            cachedVariantsTask.continueWith((Continuation)new Continuation<List<MediaVariations.Variant>, Object>(){

                public Object then(Task<List<MediaVariations.Variant>> task) throws Exception {
                    if (task.isCancelled() || task.isFaulted()) {
                        return task;
                    }
                    try {
                        if (task.getResult() == null || ((List)task.getResult()).isEmpty()) {
                            MediaVariationsFallbackProducer.this.startInputProducer(consumer, producerContext);
                            return null;
                        }
                        return MediaVariationsFallbackProducer.this.chooseFromVariants(consumer, producerContext, mediaVariations, (List)task.getResult(), imageRequest, resizeOptions, isCancelled);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
        }
        this.subscribeTaskForRequestCancellation(isCancelled, producerContext);
    }

    private Task chooseFromVariants(Consumer<EncodedImage> consumer, ProducerContext producerContext, MediaVariations mediaVariations, List<MediaVariations.Variant> variants, ImageRequest imageRequest, ResizeOptions resizeOptions, AtomicBoolean isCancelled) {
        boolean useAsLastResult;
        Task<EncodedImage> diskLookupTask;
        BufferedDiskCache preferredCache = imageRequest.getCacheChoice() == ImageRequest.CacheChoice.SMALL ? this.mSmallImageBufferedDiskCache : this.mDefaultBufferedDiskCache;
        Object callerContext = producerContext.getCallerContext();
        MediaVariations.Variant preferredVariant = null;
        CacheKey preferredCacheKey = null;
        for (int i = 0; i < variants.size(); ++i) {
            MediaVariations.Variant variant = variants.get(i);
            CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, variant.getUri(), callerContext);
            if (!preferredCache.containsSync(cacheKey) || !MediaVariationsFallbackProducer.isCloserToRequest(variant, preferredVariant, resizeOptions)) continue;
            preferredVariant = variant;
            preferredCacheKey = cacheKey;
        }
        if (preferredCacheKey == null) {
            diskLookupTask = Task.forResult(null);
            useAsLastResult = false;
        } else {
            diskLookupTask = preferredCache.get(preferredCacheKey, isCancelled);
            useAsLastResult = !mediaVariations.shouldForceRequestForSpecifiedUri() && MediaVariationsFallbackProducer.isBigEnoughForRequestedSize(preferredVariant, resizeOptions);
        }
        Continuation<EncodedImage, Void> continuation = this.onFinishDiskReads(consumer, producerContext, useAsLastResult);
        return diskLookupTask.continueWith(continuation);
    }

    private static boolean isBigEnoughForRequestedSize(MediaVariations.Variant variant, ResizeOptions resizeOptions) {
        return variant.getWidth() >= resizeOptions.width && variant.getHeight() >= resizeOptions.height;
    }

    private static boolean isCloserToRequest(MediaVariations.Variant variant, MediaVariations.Variant comparison, ResizeOptions resizeOptions) {
        if (comparison == null) {
            return true;
        }
        if (MediaVariationsFallbackProducer.isBigEnoughForRequestedSize(comparison, resizeOptions)) {
            return variant.getWidth() < comparison.getWidth() && MediaVariationsFallbackProducer.isBigEnoughForRequestedSize(variant, resizeOptions);
        }
        return variant.getWidth() > comparison.getWidth();
    }

    private Continuation<EncodedImage, Void> onFinishDiskReads(final Consumer<EncodedImage> consumer, final ProducerContext producerContext, final boolean useAsLastResult) {
        final String requestId = producerContext.getId();
        final ProducerListener listener = producerContext.getListener();
        return new Continuation<EncodedImage, Void>(){

            public Void then(Task<EncodedImage> task) throws Exception {
                boolean triggerNextProducer;
                if (MediaVariationsFallbackProducer.isTaskCancelled(task)) {
                    listener.onProducerFinishWithCancellation(requestId, MediaVariationsFallbackProducer.PRODUCER_NAME, null);
                    consumer.onCancellation();
                    triggerNextProducer = false;
                } else if (task.isFaulted()) {
                    listener.onProducerFinishWithFailure(requestId, MediaVariationsFallbackProducer.PRODUCER_NAME, task.getError(), null);
                    MediaVariationsFallbackProducer.this.startInputProducer(consumer, producerContext);
                    triggerNextProducer = true;
                } else {
                    EncodedImage cachedReference = (EncodedImage)task.getResult();
                    if (cachedReference != null) {
                        listener.onProducerFinishWithSuccess(requestId, MediaVariationsFallbackProducer.PRODUCER_NAME, MediaVariationsFallbackProducer.getExtraMap(listener, requestId, true, useAsLastResult));
                        if (useAsLastResult) {
                            consumer.onProgressUpdate(1.0f);
                        }
                        consumer.onNewResult(cachedReference, useAsLastResult);
                        cachedReference.close();
                        triggerNextProducer = !useAsLastResult;
                    } else {
                        listener.onProducerFinishWithSuccess(requestId, MediaVariationsFallbackProducer.PRODUCER_NAME, MediaVariationsFallbackProducer.getExtraMap(listener, requestId, false, false));
                        triggerNextProducer = true;
                    }
                }
                if (triggerNextProducer) {
                    MediaVariationsFallbackProducer.this.startInputProducer(consumer, producerContext);
                }
                return null;
            }
        };
    }

    private void startInputProducer(Consumer<EncodedImage> consumer, ProducerContext producerContext) {
        this.mInputProducer.produceResults(new MediaVariationsConsumer(consumer, producerContext), producerContext);
    }

    private static boolean isTaskCancelled(Task<?> task) {
        return task.isCancelled() || task.isFaulted() && task.getError() instanceof CancellationException;
    }

    @VisibleForTesting
    static Map<String, String> getExtraMap(ProducerListener listener, String requestId, boolean valueFound, boolean useAsLastResult) {
        if (!listener.requiresExtraMap(requestId)) {
            return null;
        }
        if (valueFound) {
            return ImmutableMap.of((Object)EXTRA_CACHED_VALUE_FOUND, (Object)String.valueOf(true), (Object)EXTRA_CACHED_VALUE_USED_AS_LAST, (Object)String.valueOf(useAsLastResult));
        }
        return ImmutableMap.of((Object)EXTRA_CACHED_VALUE_FOUND, (Object)String.valueOf(false));
    }

    private void subscribeTaskForRequestCancellation(final AtomicBoolean isCancelled, ProducerContext producerContext) {
        producerContext.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                isCancelled.set(true);
            }
        });
    }

    @VisibleForTesting
    class MediaVariationsConsumer
    extends DelegatingConsumer<EncodedImage, EncodedImage> {
        private final ProducerContext mProducerContext;

        public MediaVariationsConsumer(Consumer<EncodedImage> consumer, ProducerContext producerContext) {
            super(consumer);
            this.mProducerContext = producerContext;
        }

        @Override
        protected void onNewResultImpl(EncodedImage newResult, boolean isLast) {
            if (isLast && newResult != null) {
                this.storeResultInDatabase(newResult);
            }
            this.getConsumer().onNewResult(newResult, isLast);
        }

        private void storeResultInDatabase(EncodedImage newResult) {
            ImageRequest imageRequest = this.mProducerContext.getImageRequest();
            MediaVariations mediaVariations = imageRequest.getMediaVariations();
            if (!imageRequest.isDiskCacheEnabled() || mediaVariations == null) {
                return;
            }
            CacheKey cacheKey = MediaVariationsFallbackProducer.this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, this.mProducerContext.getCallerContext());
            MediaVariationsFallbackProducer.this.mMediaVariationsIndex.saveCachedVariant(mediaVariations.getMediaId(), cacheKey, newResult);
        }
    }
}

