/*
 * Decompiled with CFR 0.152.
 */
package im.shimo.react.preference;

import android.content.SharedPreferences;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import java.util.HashMap;
import java.util.Map;

public class PreferenceModule
extends ReactContextBaseJavaModule {
    private final String mPreferenceKey = "data";
    private SharedPreferences mSharedPreferences = this.getReactApplicationContext().getSharedPreferences("react-native-preference", 0);

    public PreferenceModule(ReactApplicationContext context) {
        super(context);
    }

    public String getName() {
        return "RNPreferenceManager";
    }

    @ReactMethod
    public void set(String data, Promise promise) {
        SharedPreferences.Editor editor = this.getEditor();
        editor.putString("data", data);
        editor.apply();
        promise.resolve((Object)this.getPreferences());
    }

    @ReactMethod
    public void clear(Promise promise) {
        SharedPreferences.Editor editor = this.getEditor();
        editor.remove("data");
        editor.apply();
        promise.resolve((Object)this.getPreferences());
    }

    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("InitialPreferences", this.getPreferences());
        return constants;
    }

    private String getPreferences() {
        return this.mSharedPreferences.getString("data", "{}");
    }

    private SharedPreferences.Editor getEditor() {
        return this.mSharedPreferences.edit();
    }

    public void onCatalystInstanceDestroy() {
    }
}

