
# react-native-react-demo-library

## Getting started

`$ npm install react-native-react-demo-library --save`

### Mostly automatic installation

`$ react-native link react-native-react-demo-library`

### Manual installation


#### iOS

1. In XCode, in the project navigator, right click `Libraries` ➜ `Add Files to [your project's name]`
2. Go to `node_modules` ➜ `react-native-react-demo-library` and add `RNReactDemoLibrary.xcodeproj`
3. In XCode, in the project navigator, select your project. Add `libRNReactDemoLibrary.a` to your project's `Build Phases` ➜ `Link Binary With Libraries`
4. Run your project (`Cmd+R`)<

#### Android

1. Open up `android/app/src/main/java/[...]/MainActivity.java`
  - Add `import com.reactlibrary.RNReactDemoLibraryPackage;` to the imports at the top of the file
  - Add `new RNReactDemoLibraryPackage()` to the list returned by the `getPackages()` method
2. Append the following lines to `android/settings.gradle`:
  	```
  	include ':react-native-react-demo-library'
  	project(':react-native-react-demo-library').projectDir = new File(rootProject.projectDir, 	'../node_modules/react-native-react-demo-library/android')
  	```
3. Insert the following lines inside the dependencies block in `android/app/build.gradle`:
  	```
      compile project(':react-native-react-demo-library')
  	```


## Usage
```javascript
import RNReactDemoLibrary from 'react-native-react-demo-library';

// TODO: What to do with the module?
RNReactDemoLibrary;
```
  