/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.content.ContentResolver;
import android.database.Cursor;
import android.media.ExifInterface;
import android.net.Uri;
import android.util.Pair;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.UriUtil;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.memory.PooledByteBufferInputStream;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imageutils.BitmapUtil;
import com.facebook.imageutils.JfifUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;

public class LocalExifThumbnailProducer
implements Producer<EncodedImage> {
    @VisibleForTesting
    static final String PRODUCER_NAME = "LocalExifThumbnailProducer";
    @VisibleForTesting
    static final String CREATED_THUMBNAIL = "createdThumbnail";
    private final Executor mExecutor;
    private final PooledByteBufferFactory mPooledByteBufferFactory;
    private final ContentResolver mContentResolver;

    public LocalExifThumbnailProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, ContentResolver contentResolver) {
        this.mExecutor = executor;
        this.mPooledByteBufferFactory = pooledByteBufferFactory;
        this.mContentResolver = contentResolver;
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext producerContext) {
        ProducerListener listener = producerContext.getListener();
        String requestId = producerContext.getId();
        final ImageRequest imageRequest = producerContext.getImageRequest();
        final StatefulProducerRunnable<EncodedImage> cancellableProducerRunnable = new StatefulProducerRunnable<EncodedImage>(consumer, listener, PRODUCER_NAME, requestId){

            protected EncodedImage getResult() throws Exception {
                Uri sourceUri = imageRequest.getSourceUri();
                ExifInterface exifInterface = LocalExifThumbnailProducer.this.getExifInterface(sourceUri);
                if (exifInterface == null || !exifInterface.hasThumbnail()) {
                    return null;
                }
                byte[] bytes = exifInterface.getThumbnail();
                PooledByteBuffer pooledByteBuffer = LocalExifThumbnailProducer.this.mPooledByteBufferFactory.newByteBuffer(bytes);
                return LocalExifThumbnailProducer.this.buildEncodedImage(pooledByteBuffer, exifInterface);
            }

            @Override
            protected void disposeResult(EncodedImage result) {
                EncodedImage.closeSafely(result);
            }

            @Override
            protected Map<String, String> getExtraMapOnSuccess(EncodedImage result) {
                return ImmutableMap.of((Object)LocalExifThumbnailProducer.CREATED_THUMBNAIL, (Object)Boolean.toString(result != null));
            }
        };
        producerContext.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                cancellableProducerRunnable.cancel();
            }
        });
        this.mExecutor.execute((Runnable)((Object)cancellableProducerRunnable));
    }

    @VisibleForTesting
    ExifInterface getExifInterface(Uri uri) throws IOException {
        String realPath = this.getRealPathFromUri(uri);
        if (this.canReadAsFile(realPath)) {
            return new ExifInterface(realPath);
        }
        return null;
    }

    private EncodedImage buildEncodedImage(PooledByteBuffer imageBytes, ExifInterface exifInterface) {
        Pair<Integer, Integer> dimensions = BitmapUtil.decodeDimensions(new PooledByteBufferInputStream(imageBytes));
        int rotationAngle = this.getRotationAngle(exifInterface);
        int width = dimensions != null ? (Integer)dimensions.first : -1;
        int height = dimensions != null ? (Integer)dimensions.second : -1;
        EncodedImage encodedImage = new EncodedImage((CloseableReference<PooledByteBuffer>)CloseableReference.of((Closeable)imageBytes));
        encodedImage.setImageFormat(ImageFormat.JPEG);
        encodedImage.setRotationAngle(rotationAngle);
        encodedImage.setWidth(width);
        encodedImage.setHeight(height);
        return encodedImage;
    }

    private int getRotationAngle(ExifInterface exifInterface) {
        return JfifUtil.getAutoRotateAngleFromOrientation(Integer.parseInt(exifInterface.getAttribute("Orientation")));
    }

    private String getRealPathFromUri(Uri srcUri) {
        String result = null;
        if (UriUtil.isLocalContentUri((Uri)srcUri)) {
            Cursor cursor = this.mContentResolver.query(srcUri, null, null, null, null);
            if (cursor != null) {
                cursor.moveToFirst();
                int idx = cursor.getColumnIndex("_data");
                result = cursor.getString(idx);
                cursor.close();
            }
        } else if (UriUtil.isLocalFileUri((Uri)srcUri)) {
            result = srcUri.getPath();
        }
        return result;
    }

    @VisibleForTesting
    boolean canReadAsFile(String realPath) throws IOException {
        if (realPath == null) {
            return false;
        }
        File file = new File(realPath);
        return file.exists() && file.canRead();
    }
}

