/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge.queue;

public class MessageQueueThreadSpec {
    private static final MessageQueueThreadSpec MAIN_UI_SPEC = new MessageQueueThreadSpec(ThreadType.MAIN_UI, "main_ui");
    private final ThreadType mThreadType;
    private final String mName;

    public static MessageQueueThreadSpec newBackgroundThreadSpec(String name) {
        return new MessageQueueThreadSpec(ThreadType.NEW_BACKGROUND, name);
    }

    public static MessageQueueThreadSpec mainThreadSpec() {
        return MAIN_UI_SPEC;
    }

    private MessageQueueThreadSpec(ThreadType threadType, String name) {
        this.mThreadType = threadType;
        this.mName = name;
    }

    public ThreadType getThreadType() {
        return this.mThreadType;
    }

    public String getName() {
        return this.mName;
    }

    protected static enum ThreadType {
        MAIN_UI,
        NEW_BACKGROUND;

    }
}

