/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.camera;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.AsyncTask;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.GuardedAsyncTask;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ImageEditingManager
extends ReactContextBaseJavaModule {
    private static final List<String> LOCAL_URI_PREFIXES = Arrays.asList("file://", "content://");
    private static final String TEMP_FILE_PREFIX = "ReactNative_cropped_image_";
    private static final int COMPRESS_QUALITY = 90;

    public ImageEditingManager(ReactApplicationContext reactContext) {
        super(reactContext);
        new CleanTask(this.getReactApplicationContext()).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    @Override
    public String getName() {
        return "RKImageEditingManager";
    }

    @Override
    public Map<String, Object> getConstants() {
        return Collections.emptyMap();
    }

    @Override
    public void onCatalystInstanceDestroy() {
        new CleanTask(this.getReactApplicationContext()).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    @ReactMethod
    public void cropImage(String uri, ReadableMap options, Callback success, Callback error) {
        ReadableMap size;
        ReadableMap offset = options.hasKey("offset") ? options.getMap("offset") : null;
        ReadableMap readableMap = size = options.hasKey("size") ? options.getMap("size") : null;
        if (!(offset != null && size != null && offset.hasKey("x") && offset.hasKey("y") && size.hasKey("width") && size.hasKey("height"))) {
            throw new JSApplicationIllegalArgumentException("Please specify offset and size");
        }
        if (uri == null || uri.isEmpty()) {
            throw new JSApplicationIllegalArgumentException("Please specify a URI");
        }
        CropTask cropTask = new CropTask(this.getReactApplicationContext(), uri, (int)offset.getDouble("x"), (int)offset.getDouble("y"), (int)size.getDouble("width"), (int)size.getDouble("height"), success, error);
        if (options.hasKey("displaySize")) {
            ReadableMap targetSize = options.getMap("displaySize");
            cropTask.setTargetSize(targetSize.getInt("width"), targetSize.getInt("height"));
        }
        cropTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    private static boolean isLocalUri(String uri) {
        for (String localPrefix : LOCAL_URI_PREFIXES) {
            if (!uri.startsWith(localPrefix)) continue;
            return true;
        }
        return false;
    }

    private static String getFileExtensionForType(@Nullable String mimeType) {
        if ("image/png".equals(mimeType)) {
            return ".png";
        }
        if ("image/webp".equals(mimeType)) {
            return ".webp";
        }
        return ".jpg";
    }

    private static Bitmap.CompressFormat getCompressFormatForType(String type) {
        if ("image/png".equals(type)) {
            return Bitmap.CompressFormat.PNG;
        }
        if ("image/webp".equals(type)) {
            return Bitmap.CompressFormat.WEBP;
        }
        return Bitmap.CompressFormat.JPEG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCompressedBitmapToFile(Bitmap cropped, String mimeType, File tempFile) throws IOException {
        try (FileOutputStream out = new FileOutputStream(tempFile);){
            cropped.compress(ImageEditingManager.getCompressFormatForType(mimeType), 90, (OutputStream)out);
        }
    }

    private static File createTempFile(Context context, @Nullable String mimeType) throws IOException {
        File externalCacheDir = context.getExternalCacheDir();
        File internalCacheDir = context.getCacheDir();
        if (externalCacheDir == null && externalCacheDir == null) {
            throw new IOException("No cache directory available");
        }
        File cacheDir = externalCacheDir == null ? internalCacheDir : (internalCacheDir == null ? externalCacheDir : (externalCacheDir.getFreeSpace() > internalCacheDir.getFreeSpace() ? externalCacheDir : internalCacheDir));
        return File.createTempFile(TEMP_FILE_PREFIX, ImageEditingManager.getFileExtensionForType(mimeType), cacheDir);
    }

    private static int getDecodeSampleSize(int width, int height, int targetWidth, int targetHeight) {
        int inSampleSize = 1;
        if (height > targetWidth || width > targetHeight) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfWidth / inSampleSize >= targetWidth && halfHeight / inSampleSize >= targetHeight) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    private static class CropTask
    extends GuardedAsyncTask<Void, Void> {
        final Context mContext;
        final String mUri;
        final int mX;
        final int mY;
        final int mWidth;
        final int mHeight;
        int mTargetWidth = 0;
        int mTargetHeight = 0;
        final Callback mSuccess;
        final Callback mError;

        private CropTask(ReactContext context, String uri, int x, int y, int width, int height, Callback success, Callback error) {
            super(context);
            if (x < 0 || y < 0 || width <= 0 || height <= 0) {
                throw new JSApplicationIllegalArgumentException(String.format("Invalid crop rectangle: [%d, %d, %d, %d]", x, y, width, height));
            }
            this.mContext = context;
            this.mUri = uri;
            this.mX = x;
            this.mY = y;
            this.mWidth = width;
            this.mHeight = height;
            this.mSuccess = success;
            this.mError = error;
        }

        public void setTargetSize(int width, int height) {
            if (width <= 0 || height <= 0) {
                throw new JSApplicationIllegalArgumentException(String.format("Invalid target size: [%d, %d]", width, height));
            }
            this.mTargetWidth = width;
            this.mTargetHeight = height;
        }

        private InputStream openBitmapInputStream() throws IOException {
            InputStream stream;
            if (ImageEditingManager.isLocalUri(this.mUri)) {
                stream = this.mContext.getContentResolver().openInputStream(Uri.parse((String)this.mUri));
            } else {
                URLConnection connection = new URL(this.mUri).openConnection();
                stream = connection.getInputStream();
            }
            if (stream == null) {
                throw new IOException("Cannot open bitmap: " + this.mUri);
            }
            return stream;
        }

        protected void doInBackgroundGuarded(Void ... params) {
            try {
                BitmapFactory.Options outOptions = new BitmapFactory.Options();
                boolean hasTargetSize = this.mTargetWidth > 0 && this.mTargetHeight > 0;
                Bitmap cropped = hasTargetSize ? this.cropAndResize(this.mTargetWidth, this.mTargetHeight, outOptions) : this.crop(outOptions);
                String mimeType = outOptions.outMimeType;
                if (mimeType == null || mimeType.isEmpty()) {
                    throw new IOException("Could not determine MIME type");
                }
                File tempFile = ImageEditingManager.createTempFile(this.mContext, mimeType);
                ImageEditingManager.writeCompressedBitmapToFile(cropped, mimeType, tempFile);
                this.mSuccess.invoke(Uri.fromFile((File)tempFile).toString());
            }
            catch (Exception e) {
                this.mError.invoke(e.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Bitmap crop(BitmapFactory.Options outOptions) throws IOException {
            try (InputStream inputStream = this.openBitmapInputStream();){
                Bitmap fullResolutionBitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)outOptions);
                if (fullResolutionBitmap == null) {
                    throw new IOException("Cannot decode bitmap: " + this.mUri);
                }
                Bitmap bitmap = Bitmap.createBitmap((Bitmap)fullResolutionBitmap, (int)this.mX, (int)this.mY, (int)this.mWidth, (int)this.mHeight);
                return bitmap;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Bitmap cropAndResize(int targetWidth, int targetHeight, BitmapFactory.Options outOptions) throws IOException {
            Bitmap bitmap;
            float scale;
            float newY;
            float newX;
            float newHeight;
            float newWidth;
            Assertions.assertNotNull((Object)outOptions);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            try (InputStream inputStream = this.openBitmapInputStream();){
                BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            }
            float cropRectRatio = (float)this.mWidth / (float)this.mHeight;
            float targetRatio = (float)targetWidth / (float)targetHeight;
            if (cropRectRatio > targetRatio) {
                newWidth = (float)this.mHeight * targetRatio;
                newHeight = this.mHeight;
                newX = (float)this.mX + ((float)this.mWidth - newWidth) / 2.0f;
                newY = this.mY;
                scale = (float)targetHeight / (float)this.mHeight;
            } else {
                newWidth = this.mWidth;
                newHeight = (float)this.mWidth / targetRatio;
                newX = this.mX;
                newY = (float)this.mY + ((float)this.mHeight - newHeight) / 2.0f;
                scale = (float)targetWidth / (float)this.mWidth;
            }
            outOptions.inSampleSize = ImageEditingManager.getDecodeSampleSize(this.mWidth, this.mHeight, targetWidth, targetHeight);
            options.inJustDecodeBounds = false;
            inputStream = this.openBitmapInputStream();
            try {
                bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)outOptions);
                if (bitmap == null) {
                    throw new IOException("Cannot decode bitmap: " + this.mUri);
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            int cropX = (int)Math.floor(newX / (float)outOptions.inSampleSize);
            int cropY = (int)Math.floor(newY / (float)outOptions.inSampleSize);
            int cropWidth = (int)Math.floor(newWidth / (float)outOptions.inSampleSize);
            int cropHeight = (int)Math.floor(newHeight / (float)outOptions.inSampleSize);
            float cropScale = scale * (float)outOptions.inSampleSize;
            Matrix scaleMatrix = new Matrix();
            scaleMatrix.setScale(cropScale, cropScale);
            boolean filter = true;
            return Bitmap.createBitmap((Bitmap)bitmap, (int)cropX, (int)cropY, (int)cropWidth, (int)cropHeight, (Matrix)scaleMatrix, (boolean)filter);
        }
    }

    private static class CleanTask
    extends GuardedAsyncTask<Void, Void> {
        private final Context mContext;

        private CleanTask(ReactContext context) {
            super(context);
            this.mContext = context;
        }

        protected void doInBackgroundGuarded(Void ... params) {
            this.cleanDirectory(this.mContext.getCacheDir());
            File externalCacheDir = this.mContext.getExternalCacheDir();
            if (externalCacheDir != null) {
                this.cleanDirectory(externalCacheDir);
            }
        }

        private void cleanDirectory(File directory) {
            File[] toDelete = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    return filename.startsWith(ImageEditingManager.TEMP_FILE_PREFIX);
                }
            });
            if (toDelete != null) {
                for (File file : toDelete) {
                    file.delete();
                }
            }
        }
    }
}

