/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.statusbar;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.view.View;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.UiThreadUtil;

public class StatusBarModule
extends ReactContextBaseJavaModule {
    private static final String ERROR_NO_ACTIVITY = "Tried to change the status bar while not attached to an Activity";
    private int mWindowFlags = 0;

    public StatusBarModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return "StatusBarManager";
    }

    @ReactMethod
    public void setColor(final int color, final boolean animated, final Promise res) {
        final Activity activity = this.getCurrentActivity();
        if (activity == null) {
            res.reject(ERROR_NO_ACTIVITY);
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            UiThreadUtil.runOnUiThread(new Runnable(){

                @Override
                @TargetApi(value=21)
                public void run() {
                    if (animated) {
                        int curColor = activity.getWindow().getStatusBarColor();
                        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{curColor, color});
                        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator animator) {
                                activity.getWindow().setStatusBarColor(((Integer)animator.getAnimatedValue()).intValue());
                            }
                        });
                        colorAnimation.setDuration(300L).setStartDelay(0L);
                        colorAnimation.start();
                    } else {
                        activity.getWindow().setStatusBarColor(color);
                    }
                    res.resolve(null);
                }
            });
        } else {
            res.resolve(null);
        }
    }

    @ReactMethod
    public void setTranslucent(final boolean translucent, final Promise res) {
        final Activity activity = this.getCurrentActivity();
        if (activity == null) {
            res.reject(ERROR_NO_ACTIVITY);
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (translucent) {
                    StatusBarModule.this.mWindowFlags |= 1280;
                } else {
                    StatusBarModule.this.mWindowFlags &= -1281;
                }
                activity.getWindow().getDecorView().setSystemUiVisibility(StatusBarModule.this.mWindowFlags);
                ViewCompat.requestApplyInsets((View)activity.getWindow().getDecorView());
                res.resolve(null);
            }
        });
    }

    @ReactMethod
    public void setHidden(final boolean hidden, final Promise res) {
        final Activity activity = this.getCurrentActivity();
        if (activity == null) {
            res.reject(ERROR_NO_ACTIVITY);
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (hidden) {
                    StatusBarModule.this.mWindowFlags |= 4;
                } else {
                    StatusBarModule.this.mWindowFlags &= -5;
                }
                activity.getWindow().getDecorView().setSystemUiVisibility(StatusBarModule.this.mWindowFlags);
                res.resolve(null);
            }
        });
    }
}

