'use strict';
import { Platform } from 'react-native'
const cheerio = require('react-native-cheerio')

import {NativeModules} from 'react-native';
module.exports = NativeModules.ToastExample;

import ToastExample from './ToastExample';



var DemoLibrary = {
  checkEmail: function (email) {
    return email
  },
  updateAvailable: function (bundleId, successCallback) {
    if (Platform.OS === 'ios') {
      fetch('https://itunes.apple.com/lookup?bundleId=' + bundleId, {
        method: 'GET'
      }).then((response) => response.json())
        .then((responseJson) => {
          console.log('resp ', response)
          console.log('version ', response.results[0].version)
          successCallback(response.results[0].version);
        });

    } else if (Platform.OS === 'android') {

      fetch('https://play.google.com/store/apps/details?id=' + bundleId, {
        method: 'GET'

      }).then(response => response.text())
        .then((response) => {
          ToastExample.show('Awesome', ToastExample.SHORT);
          const $ = cheerio.load(response)
          var version = $('<div/>').html(response).contents().find('div[itemprop=\"softwareVersion\"]').text().trim()
          console.log('version ', version)
          successCallback(version);
        });
    }
  }
};

module.exports = DemoLibrary;