/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewParent;
import com.facebook.react.views.view.ReactClippingViewGroup;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ReactClippingViewGroupHelper {
    public static final String PROP_REMOVE_CLIPPED_SUBVIEWS = "removeClippedSubviews";
    private static final Rect sHelperRect = new Rect();

    public static void calculateClippingRect(View view, Rect outputRect) {
        ReactClippingViewGroup clippingViewGroup;
        ViewParent parent = view.getParent();
        if (parent == null) {
            outputRect.setEmpty();
            return;
        }
        if (parent instanceof ReactClippingViewGroup && (clippingViewGroup = (ReactClippingViewGroup)parent).getRemoveClippedSubviews()) {
            clippingViewGroup.getClippingRect(sHelperRect);
            sHelperRect.offset(-view.getLeft(), -view.getTop());
            view.getDrawingRect(outputRect);
            if (!outputRect.intersect(sHelperRect)) {
                outputRect.setEmpty();
            }
            return;
        }
        view.getDrawingRect(outputRect);
    }
}

