/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.datasource;

import android.util.Pair;
import com.facebook.common.internal.Preconditions;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public abstract class AbstractDataSource<T>
implements DataSource<T> {
    @GuardedBy(value="this")
    private DataSourceStatus mDataSourceStatus = DataSourceStatus.IN_PROGRESS;
    @GuardedBy(value="this")
    private boolean mIsClosed = false;
    @Nullable
    @GuardedBy(value="this")
    private T mResult = null;
    @GuardedBy(value="this")
    private Throwable mFailureThrowable = null;
    @GuardedBy(value="this")
    private float mProgress = 0.0f;
    private final ConcurrentLinkedQueue<Pair<DataSubscriber<T>, Executor>> mSubscribers = new ConcurrentLinkedQueue();

    protected AbstractDataSource() {
    }

    @Override
    public synchronized boolean isClosed() {
        return this.mIsClosed;
    }

    @Override
    public synchronized boolean isFinished() {
        return this.mDataSourceStatus != DataSourceStatus.IN_PROGRESS;
    }

    @Override
    public synchronized boolean hasResult() {
        return this.mResult != null;
    }

    @Override
    @Nullable
    public synchronized T getResult() {
        return this.mResult;
    }

    @Override
    public synchronized boolean hasFailed() {
        return this.mDataSourceStatus == DataSourceStatus.FAILURE;
    }

    @Override
    @Nullable
    public synchronized Throwable getFailureCause() {
        return this.mFailureThrowable;
    }

    @Override
    public synchronized float getProgress() {
        return this.mProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close() {
        T resultToClose;
        AbstractDataSource abstractDataSource = this;
        synchronized (abstractDataSource) {
            if (this.mIsClosed) {
                return false;
            }
            this.mIsClosed = true;
            resultToClose = this.mResult;
            this.mResult = null;
        }
        if (resultToClose != null) {
            this.closeResult(resultToClose);
        }
        if (!this.isFinished()) {
            this.notifyDataSubscribers();
        }
        abstractDataSource = this;
        synchronized (abstractDataSource) {
            this.mSubscribers.clear();
        }
        return true;
    }

    protected void closeResult(@Nullable T result) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(DataSubscriber<T> dataSubscriber, Executor executor) {
        boolean shouldNotify;
        Preconditions.checkNotNull(dataSubscriber);
        Preconditions.checkNotNull(executor);
        AbstractDataSource abstractDataSource = this;
        synchronized (abstractDataSource) {
            if (this.mIsClosed) {
                return;
            }
            if (this.mDataSourceStatus == DataSourceStatus.IN_PROGRESS) {
                this.mSubscribers.add(Pair.create(dataSubscriber, (Object)executor));
            }
            shouldNotify = this.hasResult() || this.isFinished() || this.wasCancelled();
        }
        if (shouldNotify) {
            this.notifyDataSubscriber(dataSubscriber, executor, this.hasFailed(), this.wasCancelled());
        }
    }

    private void notifyDataSubscribers() {
        boolean isFailure = this.hasFailed();
        boolean isCancellation = this.wasCancelled();
        for (Pair<DataSubscriber<T>, Executor> pair : this.mSubscribers) {
            this.notifyDataSubscriber((DataSubscriber)pair.first, (Executor)pair.second, isFailure, isCancellation);
        }
    }

    private void notifyDataSubscriber(final DataSubscriber<T> dataSubscriber, Executor executor, final boolean isFailure, final boolean isCancellation) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (isFailure) {
                    dataSubscriber.onFailure(AbstractDataSource.this);
                } else if (isCancellation) {
                    dataSubscriber.onCancellation(AbstractDataSource.this);
                } else {
                    dataSubscriber.onNewResult(AbstractDataSource.this);
                }
            }
        });
    }

    private synchronized boolean wasCancelled() {
        return this.isClosed() && !this.isFinished();
    }

    protected boolean setResult(@Nullable T value, boolean isLast) {
        boolean result = this.setResultInternal(value, isLast);
        if (result) {
            this.notifyDataSubscribers();
        }
        return result;
    }

    protected boolean setFailure(Throwable throwable) {
        boolean result = this.setFailureInternal(throwable);
        if (result) {
            this.notifyDataSubscribers();
        }
        return result;
    }

    protected boolean setProgress(float progress) {
        boolean result = this.setProgressInternal(progress);
        if (result) {
            this.notifyProgressUpdate();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean setResultInternal(@Nullable T value, boolean isLast) {
        T resultToClose;
        block8: {
            resultToClose = null;
            try {
                AbstractDataSource abstractDataSource = this;
                // MONITORENTER : abstractDataSource
                if (this.mIsClosed || this.mDataSourceStatus != DataSourceStatus.IN_PROGRESS) {
                    resultToClose = value;
                    boolean bl = false;
                    // MONITOREXIT : abstractDataSource
                    if (resultToClose == null) return bl;
                    this.closeResult(resultToClose);
                    return bl;
                }
                if (isLast) {
                    this.mDataSourceStatus = DataSourceStatus.SUCCESS;
                    this.mProgress = 1.0f;
                }
                if (this.mResult == value) break block8;
            }
            catch (Throwable throwable) {
                if (resultToClose == null) throw throwable;
                this.closeResult(resultToClose);
                throw throwable;
            }
            resultToClose = this.mResult;
            this.mResult = value;
        }
        boolean bl = true;
        // MONITOREXIT : abstractDataSource
        if (resultToClose == null) return bl;
        this.closeResult(resultToClose);
        return bl;
    }

    private synchronized boolean setFailureInternal(Throwable throwable) {
        if (this.mIsClosed || this.mDataSourceStatus != DataSourceStatus.IN_PROGRESS) {
            return false;
        }
        this.mDataSourceStatus = DataSourceStatus.FAILURE;
        this.mFailureThrowable = throwable;
        return true;
    }

    private synchronized boolean setProgressInternal(float progress) {
        if (this.mIsClosed || this.mDataSourceStatus != DataSourceStatus.IN_PROGRESS) {
            return false;
        }
        if (progress < this.mProgress) {
            return false;
        }
        this.mProgress = progress;
        return true;
    }

    protected void notifyProgressUpdate() {
        for (Pair<DataSubscriber<T>, Executor> pair : this.mSubscribers) {
            final DataSubscriber subscriber = (DataSubscriber)pair.first;
            Executor executor = (Executor)pair.second;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    subscriber.onProgressUpdate(AbstractDataSource.this);
                }
            });
        }
    }

    private static enum DataSourceStatus {
        IN_PROGRESS,
        SUCCESS,
        FAILURE;

    }
}

