
# react-native-react-native-sticker-pipe

## Getting started

`$ npm install react-native-react-native-sticker-pipe --save`

### Mostly automatic installation

`$ react-native link react-native-react-native-sticker-pipe`

### Manual installation


#### iOS

1. In XCode, in the project navigator, right click `Libraries` ➜ `Add Files to [your project's name]`
2. Go to `node_modules` ➜ `react-native-react-native-sticker-pipe` and add `RNReactNativeStickerPipe.xcodeproj`
3. In XCode, in the project navigator, select your project. Add `libRNReactNativeStickerPipe.a` to your project's `Build Phases` ➜ `Link Binary With Libraries`
4. Run your project (`Cmd+R`)<

#### Android

1. Open up `android/app/src/main/java/[...]/MainActivity.java`
  - Add `import com.boldsofts.RNReactNativeStickerPipePackage;` to the imports at the top of the file
  - Add `new RNReactNativeStickerPipePackage()` to the list returned by the `getPackages()` method
2. Append the following lines to `android/settings.gradle`:
  	```
  	include ':react-native-react-native-sticker-pipe'
  	project(':react-native-react-native-sticker-pipe').projectDir = new File(rootProject.projectDir, 	'../node_modules/react-native-react-native-sticker-pipe/android')
  	```
3. Insert the following lines inside the dependencies block in `android/app/build.gradle`:
  	```
      compile project(':react-native-react-native-sticker-pipe')
  	```

#### Windows
[Read it! :D](https://github.com/ReactWindows/react-native)

1. In Visual Studio add the `RNReactNativeStickerPipe.sln` in `node_modules/react-native-react-native-sticker-pipe/windows/RNReactNativeStickerPipe.sln` folder to their solution, reference from their app.
2. Open up your `MainPage.cs` app
  - Add `using Com.Reactlibrary.RNReactNativeStickerPipe;` to the usings at the top of the file
  - Add `new RNReactNativeStickerPipePackage()` to the `List<IReactPackage>` returned by the `Packages` method


## Usage
```javascript
import RNReactNativeStickerPipe from 'react-native-react-native-sticker-pipe';

// TODO: What to do with the module?
RNReactNativeStickerPipe;
```
  

## Contributing

In lieu of a formal style guide, take care to maintain the existing coding style. Add unit tests for any new or changed functionality. Lint and test your code.