
package com.boldsofts.stickerspipe;

import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.Callback;
import com.facebook.react.uimanager.annotations.ReactProp;

import vc908.stickerfactory.StickersManager;

public class ReactNativeStickerPipeModule extends ReactContextBaseJavaModule {

  private final ReactApplicationContext reactContext;

  public ReactNativeStickerPipeModule(ReactApplicationContext reactContext) {
    super(reactContext);
    this.reactContext = reactContext;
  }

  @Override
  public String getName() {
    return "ReactNativeStickerPipe";
  }

  @ReactMethod// @ReactProp(name = "apiKey")
  public void init(String apiKey) {
    StickersManager.initialize(apiKey, reactContext);
  }

  @ReactMethod// @ReactProp(name = "apiKey")
  public void getApiKey() {
    StickersManager.getApiKey();
  }

  @ReactMethod// @ReactProp(name = "apiKey")
  public void getPrices() {
    StickersManager.getPrices();
  }

}