
package com.boldsofts.stickerspipe;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import com.boldsofts.stickerspipe.views.ReactBadgedStickerButtonManager;
import com.boldsofts.stickerspipe.views.ReactStickersKeyboardLayoutManager;
import com.facebook.react.ReactPackage;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.bridge.JavaScriptModule;

public class ReactNativeStickerPipePackage implements ReactPackage {
    @Override
    public List<NativeModule> createNativeModules(ReactApplicationContext reactContext) {
      return Arrays.<NativeModule>asList(new ReactNativeStickerPipeModule(reactContext));
    }

    @Override
    public List<Class<? extends JavaScriptModule>> createJSModules() {
      return Collections.emptyList();
    }

    @Override
    public List<ViewManager> createViewManagers(ReactApplicationContext reactContext) {
        return Arrays.<ViewManager>asList(
                new ReactBadgedStickerButtonManager(),
                new ReactStickersKeyboardLayoutManager(),
                new StickersPipeInputLayout()
        );
    }
}