package com.boldsofts.stickerspipe;

import android.support.annotation.Nullable;

import com.boldsofts.stickerspipe.views.ReactInputLayoutStub;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.ReactProp;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;

import java.util.Map;

/**
 * Created by juicycleff on 6/26/2017.
 */

public class StickersPipeInputLayout extends ViewGroupManager<ReactInputLayoutStub> {

    public static final String REACT_CLASS = "StickersPipeInputLayout";

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    protected ReactInputLayoutStub createViewInstance(ThemedReactContext reactContext) {
        return new ReactInputLayoutStub(reactContext);
    }


    @ReactProp(name = "attachButtonVisible", defaultBoolean = true)
    public void setAttachButtonVisibility(ReactInputLayoutStub view,  boolean visible) {
        view.setAttachButtonVisibility(visible);
    }

    @ReactProp(name = "sendButtonVisible", defaultBoolean = false)
    public void setSendButtonVisibility(ReactInputLayoutStub view,  boolean visible) {
        view.setSendButtonVisibility(visible);
    }


    @Override
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.of(
                SendEvent.EVENT_NAME, (Object) MapBuilder.of("registrationName", "onSendPress"),
                AttachEvent.EVENT_NAME, (Object) MapBuilder.of("registrationName", "onAttachPress"),
                CanGoBackEvent.EVENT_NAME, (Object) MapBuilder.of("registrationName", "onCanGoBackChanged")

        );
    }

    public static class SendEvent extends Event<SendEvent> {
        String message;
        final static String EVENT_NAME = "onSendPress";

        public SendEvent(int viewTag,String message){
            super(viewTag);
            this.message = message;
        }

        @Override
        public String getEventName() {
            return EVENT_NAME;
        }

        @Override
        public void dispatch(RCTEventEmitter rctEventEmitter) {
            WritableMap eventData = Arguments.createMap();
            eventData.putString("message", message);
            //eventData.putString("plaintext", Moji.htmlToPlainText(html));
            rctEventEmitter.receiveEvent(getViewTag(),getEventName(),eventData);
        }
    }

    public static class AttachEvent extends Event<AttachEvent>{
        final static String EVENT_NAME = "onAttachPress";
        public AttachEvent(int viewTag, long timestampMs){
            super(viewTag, timestampMs);
        }
        @Override
        public String getEventName() {
            return EVENT_NAME;
        }

        @Override
        public void dispatch(RCTEventEmitter rctEventEmitter) {
            WritableMap eventData = Arguments.createMap();
            rctEventEmitter.receiveEvent(getViewTag(),getEventName(),eventData);
        }
    }

    public static class CanGoBackEvent extends Event<CanGoBackEvent>{
        final static String EVENT_NAME = "onCanGoBackChanged";
        boolean canGoBack;
        public CanGoBackEvent(int viewTag,boolean canGoBack){
            super(viewTag);
            this.canGoBack = canGoBack;
        }
        @Override
        public String getEventName() {
            return EVENT_NAME;
        }

        @Override
        public void dispatch(RCTEventEmitter rctEventEmitter) {
            WritableMap eventData = Arguments.createMap();
            eventData.putBoolean("canGoBack",canGoBack);
            rctEventEmitter.receiveEvent(getViewTag(),getEventName(),eventData);
        }
    }
}
