package com.boldsofts.stickerspipe.views;

import android.content.Context;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentContainer;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListView;

import com.boldsofts.stickerspipe.R;
import com.boldsofts.stickerspipe.utils.ReactStickersLayoutController;
import com.boldsofts.stickerspipe.widgets.RNBadgedStickerButton;

import vc908.stickerfactory.StickersKeyboardController;
import vc908.stickerfactory.ui.OnStickerSelectedListener;
import vc908.stickerfactory.ui.fragment.StickersFragment;
import vc908.stickerfactory.ui.view.BadgedStickersButton;
import vc908.stickerfactory.ui.view.StickersKeyboardLayout;

/**
 * Created by juicycleff on 6/26/2017.
 */

public class ReactInputLayoutStub extends LinearLayout {

    private EditText editMessage;
    private ReactStickersLayoutController stickersKeyboardController;
    public static final String TAG = "ReactInputLayoutStub";

    private BadgedStickersButton mStickerButton;
    private EditText mInputTextBox;
    private ImageButton mSendButton;
    private ImageButton mAttachButton;
    private RecyclerView mSuggestList;
    private FrameLayout mFrame;
    private LinearLayout mChatToolbar;
    private StickersFragment stickersFragment;
    private View rootView;
    private int fontSize;
    private String iconSendResId;
    private String iconAttachResId;
    private String iconSendUri;
    private String iconAttachUri;
    private String iconSendPackage;
    private String iconAttachPackage;
    private String iconSendSize;
    private String iconAttachSize;
    private int textColor;

    FragmentActivity fragmentActivity;

    public ReactInputLayoutStub(Context context) {
        super(context);
        init();
    }

    public ReactInputLayoutStub(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public ReactInputLayoutStub(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public ReactInputLayoutStub(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init();
    }

    private void init() {
        inflate(getContext(), R.layout.gueva_chat_input_layout, this);
        this.mStickerButton = (BadgedStickersButton) findViewById(R.id.stickers_btn);
        this.mInputTextBox = (EditText) findViewById(R.id.editText);
        this.mSendButton = (ImageButton) findViewById(R.id.send_btn);
        this.mAttachButton = (ImageButton) findViewById(R.id.attach_btn);
        this.mSuggestList = (RecyclerView) findViewById(R.id.suggests_list);
        this.mFrame = (FrameLayout) findViewById(R.id.frame);
        this.mChatToolbar = (LinearLayout) findViewById(R.id.chat_toolbar);
        this.stickersFragment = (StickersFragment) fragmentActivity.getSupportFragmentManager().findFragmentById(R.id.frame);

        if (stickersFragment == null) {
            stickersFragment = new StickersFragment();
            fragmentActivity.getSupportFragmentManager().beginTransaction().replace(R.id.frame, stickersFragment).commit();
        }

        View stickersFrame = findViewById(R.id.frame);
        //View chatContentGroup = findViewById(R.id.chat_content);

        //StickersKeyboardLayout stickersLayout = (StickersKeyboardLayout) findViewById(R.id.sizeNotifierLayout);
        stickersKeyboardController = new ReactStickersLayoutController.Builder(getContext())
                //.setStickersKeyboardLayout(stickersLayout)
                .setStickersFragment(stickersFragment)
                .setStickersFrame(stickersFrame)
                //.setContentContainer(chatContentGroup)
                .setStickersButton(mStickerButton)
                .setChatEdit(editMessage)
                .setSuggestContainer(mSuggestList)
                .build();

        stickersKeyboardController.setKeyboardVisibilityChangeListener(new ReactStickersLayoutController.KeyboardVisibilityChangeListener() {
            @Override
            public void onTextKeyboardVisibilityChanged(boolean isVisible) {
                //scrollToBottomIfNeed();
            }

            @Override
            public void onStickersKeyboardVisibilityChanged(boolean isVisible) {

            }
        });
    }

    public void setAttachButtonVisibility(boolean visible){
        if(visible) {
            mAttachButton.setVisibility(VISIBLE);
        }else if(!visible){
            mAttachButton.setVisibility(GONE);
        }
    }

    public void setSendButtonVisibility(boolean visible){
        if(visible) {
            mSendButton.setVisibility(VISIBLE);
        }else if(!visible){
            mSendButton.setVisibility(GONE);
        }
    }

    private OnStickerSelectedListener stickerSelectedListener = new OnStickerSelectedListener() {
        @Override
        public void onStickerSelected(String code) {
            //addMessage(code, false, System.currentTimeMillis());
        }

        @Override
        public void onEmojiSelected(String emoji) {
            editMessage.append(emoji);
        }
    };
}
