/*
 * Decompiled with CFR 0.152.
 */
package com.github.godness84.RNRecyclerViewList;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.common.SystemClock;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.NativeGestureUtil;
import com.github.godness84.RNRecyclerViewList.ContentSizeChangeEvent;
import com.github.godness84.RNRecyclerViewList.NotAnimatedItemAnimator;
import com.github.godness84.RNRecyclerViewList.R;
import com.github.godness84.RNRecyclerViewList.RecyclerViewItemView;
import com.github.godness84.RNRecyclerViewList.VisibleItemsChangeEvent;
import java.util.ArrayList;
import java.util.List;

@VisibleForTesting
public class RecyclerViewBackedScrollView
extends RecyclerView {
    private static final String TAG = "RecyclerViewBackedScrol";
    private boolean mSendContentSizeChangeEvents;
    private int mFirstVisibleIndex;
    private int mLastVisibleIndex;
    private boolean mRequestedLayout = false;

    public void setSendContentSizeChangeEvents(boolean sendContentSizeChangeEvents) {
        this.mSendContentSizeChangeEvents = sendContentSizeChangeEvents;
    }

    private int calculateAbsoluteOffset() {
        int offsetY = 0;
        if (this.getChildCount() > 0) {
            View recyclerViewChild = this.getChildAt(0);
            int childPosition = this.getChildViewHolder(recyclerViewChild).getLayoutPosition();
            offsetY = ((ReactListAdapter)this.getAdapter()).getTopOffsetForItem(childPosition) - recyclerViewChild.getTop();
        }
        return offsetY;
    }

    void scrollTo(int scrollX, int scrollY, boolean animated) {
        int deltaY = scrollY - this.calculateAbsoluteOffset();
        if (animated) {
            this.smoothScrollBy(0, deltaY);
        } else {
            this.scrollBy(0, deltaY);
        }
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        int firstIndex = ((LinearLayoutManager)this.getLayoutManager()).findFirstVisibleItemPosition();
        int lastIndex = ((LinearLayoutManager)this.getLayoutManager()).findLastVisibleItemPosition();
        if (firstIndex != this.mFirstVisibleIndex || lastIndex != this.mLastVisibleIndex) {
            ((UIManagerModule)this.getReactContext().getNativeModule(UIManagerModule.class)).getEventDispatcher().dispatchEvent((Event)new VisibleItemsChangeEvent(this.getId(), SystemClock.nanoTime(), firstIndex, lastIndex));
            this.mFirstVisibleIndex = firstIndex;
            this.mLastVisibleIndex = lastIndex;
        }
    }

    private void onTotalChildrenHeightChange(int newTotalChildrenHeight) {
        if (this.mSendContentSizeChangeEvents) {
            ((UIManagerModule)this.getReactContext().getNativeModule(UIManagerModule.class)).getEventDispatcher().dispatchEvent((Event)new ContentSizeChangeEvent(this.getId(), SystemClock.nanoTime(), this.getWidth(), newTotalChildrenHeight));
        }
    }

    private ReactContext getReactContext() {
        return (ReactContext)((ContextThemeWrapper)this.getContext()).getBaseContext();
    }

    public RecyclerViewBackedScrollView(Context context) {
        super((Context)new ContextThemeWrapper(context, R.style.ScrollbarRecyclerView));
        this.setHasFixedSize(true);
        this.setItemAnimator(new NotAnimatedItemAnimator());
        this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        this.setAdapter(new ReactListAdapter(this));
    }

    void addViewToAdapter(RecyclerViewItemView child, int index) {
        ((ReactListAdapter)this.getAdapter()).addView(child, index);
    }

    void removeViewFromAdapter(int index) {
        ((ReactListAdapter)this.getAdapter()).removeViewAt(index);
    }

    View getChildAtFromAdapter(int index) {
        return ((ReactListAdapter)this.getAdapter()).getView(index);
    }

    int getChildCountFromAdapter() {
        return this.getAdapter().getItemCount();
    }

    void setItemCount(int itemCount) {
        ((ReactListAdapter)this.getAdapter()).setItemCount(itemCount);
    }

    int getItemCount() {
        return this.getAdapter().getItemCount();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (super.onInterceptTouchEvent(ev)) {
            NativeGestureUtil.notifyNativeGestureStarted((View)this, (MotionEvent)ev);
            return true;
        }
        return false;
    }

    public void requestLayout() {
        Log.d((String)TAG, (String)"requested layout to Recycler");
        super.requestLayout();
        if (!this.mRequestedLayout) {
            this.mRequestedLayout = true;
            this.post(new Runnable(){

                @Override
                public void run() {
                    RecyclerViewBackedScrollView.this.mRequestedLayout = false;
                    RecyclerViewBackedScrollView.this.layout(RecyclerViewBackedScrollView.this.getLeft(), RecyclerViewBackedScrollView.this.getTop(), RecyclerViewBackedScrollView.this.getRight(), RecyclerViewBackedScrollView.this.getBottom());
                    RecyclerViewBackedScrollView.this.onLayout(false, RecyclerViewBackedScrollView.this.getLeft(), RecyclerViewBackedScrollView.this.getTop(), RecyclerViewBackedScrollView.this.getRight(), RecyclerViewBackedScrollView.this.getBottom());
                    Log.d((String)RecyclerViewBackedScrollView.TAG, (String)"run layout in Recycler");
                }
            });
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        Log.d((String)TAG, (String)"onLayout called in Recycler");
    }

    static class ReactListAdapter
    extends RecyclerView.Adapter<ConcreteViewHolder> {
        private final List<RecyclerViewItemView> mViews = new ArrayList<RecyclerViewItemView>();
        private final ScrollOffsetTracker mScrollOffsetTracker;
        private final RecyclerViewBackedScrollView mScrollView;
        private int mTotalChildrenHeight = 0;
        private int mItemCount = 0;
        private final View.OnLayoutChangeListener mChildLayoutChangeListener = new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                int oldHeight = oldBottom - oldTop;
                int newHeight = bottom - top;
                if (oldHeight != newHeight) {
                    ReactListAdapter.this.updateTotalChildrenHeight(newHeight - oldHeight);
                    ReactListAdapter.this.mScrollOffsetTracker.onHeightChange(ReactListAdapter.this.mViews.indexOf(v), oldHeight, newHeight);
                    if (v.getParent() != null && v.getParent().getParent() != null) {
                        View wrapper = (View)v.getParent();
                        wrapper.forceLayout();
                        ((View)wrapper.getParent()).forceLayout();
                    }
                }
            }
        };

        public ReactListAdapter(RecyclerViewBackedScrollView scrollView) {
            this.mScrollView = scrollView;
            this.mScrollOffsetTracker = new ScrollOffsetTracker(this);
        }

        public void addView(RecyclerViewItemView child, int index) {
            this.mViews.add(index, child);
            this.updateTotalChildrenHeight(child.getMeasuredHeight());
            child.addOnLayoutChangeListener(this.mChildLayoutChangeListener);
            int itemIndex = child.getItemIndex();
            this.notifyItemChanged(itemIndex);
            Log.d((String)RecyclerViewBackedScrollView.TAG, (String)String.format("Added child view at index %d for position %d", index, itemIndex));
        }

        public void removeViewAt(int index) {
            RecyclerViewItemView child = this.mViews.get(index);
            if (child != null) {
                this.mViews.remove(index);
                child.removeOnLayoutChangeListener(this.mChildLayoutChangeListener);
                this.updateTotalChildrenHeight(-child.getMeasuredHeight());
                Log.d((String)RecyclerViewBackedScrollView.TAG, (String)String.format("Removed child view at index %d for position %d", index, child.getItemIndex()));
            }
        }

        private void updateTotalChildrenHeight(int delta) {
            if (delta != 0) {
                this.mTotalChildrenHeight += delta;
                this.mScrollView.onTotalChildrenHeightChange(this.mTotalChildrenHeight);
            }
        }

        public ConcreteViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            Log.d((String)RecyclerViewBackedScrollView.TAG, (String)"ViewHolder created");
            return new ConcreteViewHolder((View)new RecyclableWrapperViewGroup(parent.getContext(), this));
        }

        public void onBindViewHolder(ConcreteViewHolder holder, int position) {
            RecyclableWrapperViewGroup vg = (RecyclableWrapperViewGroup)holder.itemView;
            RecyclerViewItemView row = this.getViewByItemIndex(position);
            if (row != null && row.getParent() != vg) {
                Log.d((String)RecyclerViewBackedScrollView.TAG, (String)("Binding view for position " + position));
                if (row.getParent() != null) {
                    ((ViewGroup)row.getParent()).removeView((View)row);
                    Log.d((String)RecyclerViewBackedScrollView.TAG, (String)("View for position " + position + " was already connected to a parent."));
                }
                vg.addView((View)row, 0);
            } else {
                Log.d((String)RecyclerViewBackedScrollView.TAG, (String)("Binding view for position " + position + " but it was not found in the index."));
            }
        }

        public void onViewRecycled(ConcreteViewHolder holder) {
            super.onViewRecycled((RecyclerView.ViewHolder)holder);
            ((RecyclableWrapperViewGroup)holder.itemView).removeAllViews();
        }

        public int getItemCount() {
            return this.mItemCount;
        }

        public void setItemCount(int itemCount) {
            this.mItemCount = itemCount;
            Log.d((String)RecyclerViewBackedScrollView.TAG, (String)String.format("Set item count to %d", itemCount));
        }

        public View getView(int index) {
            return (View)this.mViews.get(index);
        }

        public RecyclerViewItemView getViewByItemIndex(int position) {
            for (int i = 0; i < this.mViews.size(); ++i) {
                if (this.mViews.get(i).getItemIndex() != position) continue;
                return this.mViews.get(i);
            }
            return null;
        }

        public int getTotalChildrenHeight() {
            return this.mTotalChildrenHeight;
        }

        public int getTopOffsetForItem(int index) {
            return this.mScrollOffsetTracker.getTopOffsetForItem(index);
        }
    }

    private static class ScrollOffsetTracker {
        private final ReactListAdapter mReactListAdapter;
        private int mLastRequestedPosition;
        private int mOffsetForLastPosition;

        private ScrollOffsetTracker(ReactListAdapter reactListAdapter) {
            this.mReactListAdapter = reactListAdapter;
        }

        public void onHeightChange(int index, int oldHeight, int newHeight) {
            if (index < this.mLastRequestedPosition) {
                this.mOffsetForLastPosition = this.mOffsetForLastPosition - oldHeight + newHeight;
            }
        }

        public int getTopOffsetForItem(int index) {
            if (this.mLastRequestedPosition != index) {
                int sum;
                if (this.mLastRequestedPosition < index) {
                    int startIndex;
                    if (this.mLastRequestedPosition != -1) {
                        sum = this.mOffsetForLastPosition;
                        startIndex = this.mLastRequestedPosition;
                    } else {
                        sum = 0;
                        startIndex = 0;
                    }
                    for (int i = startIndex; i < index; ++i) {
                        sum += ((RecyclerViewItemView)((Object)this.mReactListAdapter.mViews.get(i))).getMeasuredHeight();
                    }
                } else if (index < this.mLastRequestedPosition - index) {
                    sum = 0;
                    for (int i = 0; i < index; ++i) {
                        sum += ((RecyclerViewItemView)((Object)this.mReactListAdapter.mViews.get(i))).getMeasuredHeight();
                    }
                } else {
                    sum = this.mOffsetForLastPosition;
                    for (int i = this.mLastRequestedPosition - 1; i >= index; --i) {
                        sum -= ((RecyclerViewItemView)((Object)this.mReactListAdapter.mViews.get(i))).getMeasuredHeight();
                    }
                }
                this.mLastRequestedPosition = index;
                this.mOffsetForLastPosition = sum;
            }
            return this.mOffsetForLastPosition;
        }
    }

    static class RecyclableWrapperViewGroup
    extends ViewGroup {
        private ReactListAdapter mAdapter;
        private View.OnLayoutChangeListener mChildLayoutChangeListener = new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                Log.d((String)RecyclerViewBackedScrollView.TAG, (String)"Child view of Wrapper changed layout, going to ask to rebind.");
                Assertions.assertCondition((boolean)(v instanceof RecyclerViewItemView), (String)"Child view must be of type RecyclerViewItemView");
                RecyclableWrapperViewGroup.this.post(new Runnable(){

                    @Override
                    public void run() {
                        Log.d((String)RecyclerViewBackedScrollView.TAG, (String)"did asked request layout");
                        RecyclableWrapperViewGroup.this.requestLayout();
                        RecyclableWrapperViewGroup.this.getParent().requestLayout();
                    }
                });
            }
        };

        public RecyclableWrapperViewGroup(Context context, ReactListAdapter adapter) {
            super(context);
            this.mAdapter = adapter;
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
        }

        public void onViewAdded(View child) {
            super.onViewAdded(child);
            child.addOnLayoutChangeListener(this.mChildLayoutChangeListener);
        }

        public void onViewRemoved(View child) {
            super.onViewRemoved(child);
            child.removeOnLayoutChangeListener(this.mChildLayoutChangeListener);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            if (this.getChildCount() > 0) {
                View child = this.getChildAt(0);
                this.setMeasuredDimension(child.getMeasuredWidth(), child.getMeasuredHeight());
                Log.d((String)RecyclerViewBackedScrollView.TAG, (String)String.format("Wrapper asked to be measured, replied with child dimensions: %d, %d.", child.getMeasuredWidth(), child.getMeasuredHeight()));
            } else {
                this.setMeasuredDimension(50, 150);
                Log.d((String)RecyclerViewBackedScrollView.TAG, (String)"Wrapper asked to be measured, NO CHILD FOUND");
            }
        }

        public ReactListAdapter getAdapter() {
            return this.mAdapter;
        }
    }

    private static class ConcreteViewHolder
    extends RecyclerView.ViewHolder {
        public ConcreteViewHolder(View itemView) {
            super(itemView);
        }
    }
}

