/*
 * Decompiled with CFR 0.152.
 */
package com.github.godness84.RNRecyclerViewList;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.util.Log;
import android.view.View;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.scroll.ReactScrollViewCommandHelper;
import com.facebook.react.views.scroll.ScrollEventType;
import com.github.godness84.RNRecyclerViewList.RecyclerViewBackedScrollView;
import com.github.godness84.RNRecyclerViewList.RecyclerViewItemView;
import java.util.Map;
import javax.annotation.Nullable;

public class RecyclerViewBackedScrollViewManager
extends ViewGroupManager<RecyclerViewBackedScrollView>
implements ReactScrollViewCommandHelper.ScrollCommandHandler<RecyclerViewBackedScrollView> {
    public static final String REACT_CLASS = "AndroidRecyclerViewBackedScrollView";
    public static final int COMMAND_NOTIFY_ITEM_RANGE_INSERTED = 1;
    private static final String TAG = "RecyclerViewManager";

    public String getName() {
        return REACT_CLASS;
    }

    @ReactProp(name="onContentSizeChange")
    public void setOnContentSizeChange(RecyclerViewBackedScrollView view, boolean value) {
        view.setSendContentSizeChangeEvents(value);
    }

    protected RecyclerViewBackedScrollView createViewInstance(ThemedReactContext reactContext) {
        return new RecyclerViewBackedScrollView((Context)reactContext);
    }

    public void addView(RecyclerViewBackedScrollView parent, View child, int index) {
        Assertions.assertCondition((boolean)(child instanceof RecyclerViewItemView), (String)"Views attached to RecyclerViewBackedScrollView must be RecyclerViewItemView views.");
        RecyclerViewItemView item = (RecyclerViewItemView)child;
        parent.addViewToAdapter(item, index);
    }

    public int getChildCount(RecyclerViewBackedScrollView parent) {
        return parent.getChildCountFromAdapter();
    }

    public View getChildAt(RecyclerViewBackedScrollView parent, int index) {
        return parent.getChildAtFromAdapter(index);
    }

    public void removeViewAt(RecyclerViewBackedScrollView parent, int index) {
        parent.removeViewFromAdapter(index);
    }

    @ReactProp(name="itemCount")
    public void setItemCount(RecyclerViewBackedScrollView parent, int itemCount) {
        parent.setItemCount(itemCount);
        parent.getAdapter().notifyDataSetChanged();
        Log.d((String)TAG, (String)String.format("notified data set changed", new Object[0]));
    }

    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of((Object)"notifyItemRangeInserted", (Object)1);
    }

    public void receiveCommand(RecyclerViewBackedScrollView parent, int commandType, @Nullable ReadableArray args) {
        Assertions.assertNotNull((Object)((Object)parent));
        Assertions.assertNotNull((Object)args);
        switch (commandType) {
            case 1: {
                int position = args.getInt(0);
                int count = args.getInt(1);
                Log.d((String)TAG, (String)String.format("notify item range inserted: position %d, count %d", position, count));
                RecyclerViewBackedScrollView.ReactListAdapter adapter = (RecyclerViewBackedScrollView.ReactListAdapter)parent.getAdapter();
                adapter.setItemCount(adapter.getItemCount() + count);
                LinearLayoutManager layoutManager = (LinearLayoutManager)parent.getLayoutManager();
                adapter.notifyItemRangeInserted(position, count);
                return;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported command %d received by %s.", commandType, ((Object)((Object)this)).getClass().getSimpleName()));
    }

    public void scrollTo(RecyclerViewBackedScrollView scrollView, ReactScrollViewCommandHelper.ScrollToCommandData data) {
        scrollView.scrollTo(data.mDestX, data.mDestY, data.mAnimated);
    }

    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.builder().put((Object)ScrollEventType.SCROLL.getJSEventName(), (Object)MapBuilder.of((Object)"registrationName", (Object)"onScroll")).put((Object)"topContentSizeChange", (Object)MapBuilder.of((Object)"registrationName", (Object)"onContentSizeChange")).put((Object)"visibleItemsChange", (Object)MapBuilder.of((Object)"registrationName", (Object)"onVisibleItemsChange")).build();
    }
}

