/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.drawee.drawable.ForwardingDrawable;
import com.facebook.drawee.drawable.Rounded;
import java.util.Arrays;

public class RoundedCornersDrawable
extends ForwardingDrawable
implements Rounded {
    @VisibleForTesting
    Type mType = Type.OVERLAY_COLOR;
    @VisibleForTesting
    final float[] mRadii = new float[8];
    @VisibleForTesting
    final Paint mPaint = new Paint(1);
    @VisibleForTesting
    boolean mIsCircle = false;
    @VisibleForTesting
    float mBorderWidth = 0.0f;
    @VisibleForTesting
    int mBorderColor = 0;
    @VisibleForTesting
    int mOverlayColor = 0;
    private final Path mPath = new Path();
    private final RectF mTempRectangle = new RectF();

    public RoundedCornersDrawable(Drawable drawable) {
        super((Drawable)Preconditions.checkNotNull((Object)drawable));
    }

    public void setType(Type type) {
        this.mType = type;
        this.invalidateSelf();
    }

    @Override
    public void setCircle(boolean isCircle) {
        this.mIsCircle = isCircle;
        this.updatePath();
        this.invalidateSelf();
    }

    @Override
    public void setRadius(float radius) {
        Arrays.fill(this.mRadii, radius);
        this.updatePath();
        this.invalidateSelf();
    }

    @Override
    public void setRadii(float[] radii) {
        if (radii == null) {
            Arrays.fill(this.mRadii, 0.0f);
        } else {
            Preconditions.checkArgument((radii.length == 8 ? 1 : 0) != 0, (Object)"radii should have exactly 8 values");
            System.arraycopy(radii, 0, this.mRadii, 0, 8);
        }
        this.updatePath();
        this.invalidateSelf();
    }

    public void setOverlayColor(int overlayColor) {
        this.mOverlayColor = overlayColor;
        this.invalidateSelf();
    }

    @Override
    public void setBorder(int color, float width) {
        this.mBorderColor = color;
        this.mBorderWidth = width;
        this.updatePath();
        this.invalidateSelf();
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.updatePath();
    }

    private void updatePath() {
        this.mPath.reset();
        this.mTempRectangle.set(this.getBounds());
        this.mTempRectangle.inset(this.mBorderWidth / 2.0f, this.mBorderWidth / 2.0f);
        if (this.mIsCircle) {
            this.mPath.addCircle(this.mTempRectangle.centerX(), this.mTempRectangle.centerY(), Math.min(this.mTempRectangle.width(), this.mTempRectangle.height()) / 2.0f, Path.Direction.CW);
        } else {
            this.mPath.addRoundRect(this.mTempRectangle, this.mRadii, Path.Direction.CW);
        }
        this.mTempRectangle.inset(-this.mBorderWidth / 2.0f, -this.mBorderWidth / 2.0f);
    }

    @Override
    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        switch (this.mType) {
            case CLIPPING: {
                int saveCount = canvas.save();
                this.mPath.setFillType(Path.FillType.EVEN_ODD);
                canvas.clipPath(this.mPath);
                super.draw(canvas);
                canvas.restoreToCount(saveCount);
                break;
            }
            case OVERLAY_COLOR: {
                super.draw(canvas);
                this.mPaint.setColor(this.mOverlayColor);
                this.mPaint.setStyle(Paint.Style.FILL);
                this.mPath.setFillType(Path.FillType.INVERSE_EVEN_ODD);
                canvas.drawPath(this.mPath, this.mPaint);
                if (!this.mIsCircle) break;
                float paddingH = ((float)(bounds.width() - bounds.height()) + this.mBorderWidth) / 2.0f;
                float paddingV = ((float)(bounds.height() - bounds.width()) + this.mBorderWidth) / 2.0f;
                if (paddingH > 0.0f) {
                    canvas.drawRect((float)bounds.left, (float)bounds.top, (float)bounds.left + paddingH, (float)bounds.bottom, this.mPaint);
                    canvas.drawRect((float)bounds.right - paddingH, (float)bounds.top, (float)bounds.right, (float)bounds.bottom, this.mPaint);
                }
                if (!(paddingV > 0.0f)) break;
                canvas.drawRect((float)bounds.left, (float)bounds.top, (float)bounds.right, (float)bounds.top + paddingV, this.mPaint);
                canvas.drawRect((float)bounds.left, (float)bounds.bottom - paddingV, (float)bounds.right, (float)bounds.bottom, this.mPaint);
            }
        }
        if (this.mBorderColor != 0) {
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setColor(this.mBorderColor);
            this.mPaint.setStrokeWidth(this.mBorderWidth);
            this.mPath.setFillType(Path.FillType.EVEN_ODD);
            canvas.drawPath(this.mPath, this.mPaint);
        }
    }

    public static enum Type {
        OVERLAY_COLOR,
        CLIPPING;

    }
}

