/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget.text.span;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.style.ReplacementSpan;

public class BetterImageSpan
extends ReplacementSpan {
    public static final int ALIGN_BOTTOM = 0;
    public static final int ALIGN_BASELINE = 1;
    public static final int ALIGN_CENTER = 2;
    private int mWidth;
    private int mHeight;
    private Rect mBounds;
    private final int mAlignment;
    private final Paint.FontMetricsInt mFontMetricsInt = new Paint.FontMetricsInt();
    private final Drawable mDrawable;

    @BetterImageSpanAlignment
    public static final int normalizeAlignment(int alignment) {
        switch (alignment) {
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        return 1;
    }

    public BetterImageSpan(Drawable drawable) {
        this(drawable, 1);
    }

    public BetterImageSpan(Drawable drawable, @BetterImageSpanAlignment int verticalAlignment) {
        this.mDrawable = drawable;
        this.mAlignment = verticalAlignment;
        this.updateBounds();
    }

    public Drawable getDrawable() {
        return this.mDrawable;
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fontMetrics) {
        this.updateBounds();
        if (fontMetrics == null) {
            return this.mWidth;
        }
        int offsetAbove = this.getOffsetAboveBaseline(fontMetrics);
        int offsetBelow = this.mHeight + offsetAbove;
        if (offsetAbove < fontMetrics.ascent) {
            fontMetrics.ascent = offsetAbove;
        }
        if (offsetAbove < fontMetrics.top) {
            fontMetrics.top = offsetAbove;
        }
        if (offsetBelow > fontMetrics.descent) {
            fontMetrics.descent = offsetBelow;
        }
        if (offsetBelow > fontMetrics.bottom) {
            fontMetrics.descent = offsetBelow;
        }
        return this.mWidth;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        paint.getFontMetricsInt(this.mFontMetricsInt);
        int iconTop = y + this.getOffsetAboveBaseline(this.mFontMetricsInt);
        canvas.translate(x, (float)iconTop);
        this.mDrawable.draw(canvas);
        canvas.translate(-x, (float)(-iconTop));
    }

    public void updateBounds() {
        this.mBounds = this.mDrawable.getBounds();
        this.mWidth = this.mBounds.width();
        this.mHeight = this.mBounds.height();
    }

    private int getOffsetAboveBaseline(Paint.FontMetricsInt fm) {
        switch (this.mAlignment) {
            case 0: {
                return fm.descent - this.mHeight;
            }
            case 2: {
                int textHeight = fm.descent - fm.ascent;
                int offset = (textHeight - this.mHeight) / 2;
                return fm.ascent + offset;
            }
        }
        return -this.mHeight;
    }

    public static @interface BetterImageSpanAlignment {
    }
}

