/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.backends.okhttp;

import android.net.Uri;
import android.os.Looper;
import android.os.SystemClock;
import com.facebook.common.logging.FLog;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.BaseNetworkFetcher;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.FetchState;
import com.facebook.imagepipeline.producers.NetworkFetcher;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerContextCallbacks;
import com.squareup.okhttp.CacheControl;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class OkHttpNetworkFetcher
extends BaseNetworkFetcher<OkHttpNetworkFetchState> {
    private static final String TAG = "OkHttpNetworkFetchProducer";
    private static final String QUEUE_TIME = "queue_time";
    private static final String FETCH_TIME = "fetch_time";
    private static final String TOTAL_TIME = "total_time";
    private static final String IMAGE_SIZE = "image_size";
    private final OkHttpClient mOkHttpClient;
    private Executor mCancellationExecutor;

    public OkHttpNetworkFetcher(OkHttpClient okHttpClient) {
        this.mOkHttpClient = okHttpClient;
        this.mCancellationExecutor = okHttpClient.getDispatcher().getExecutorService();
    }

    public OkHttpNetworkFetchState createFetchState(Consumer<EncodedImage> consumer, ProducerContext context) {
        return new OkHttpNetworkFetchState(consumer, context);
    }

    public void fetch(final OkHttpNetworkFetchState fetchState, final NetworkFetcher.Callback callback) {
        fetchState.submitTime = SystemClock.elapsedRealtime();
        Uri uri = fetchState.getUri();
        Request request = new Request.Builder().cacheControl(new CacheControl.Builder().noStore().build()).url(uri.toString()).get().build();
        final Call call = this.mOkHttpClient.newCall(request);
        fetchState.getContext().addCallbacks((ProducerContextCallbacks)new BaseProducerContextCallbacks(){

            public void onCancellationRequested() {
                if (Looper.myLooper() != Looper.getMainLooper()) {
                    call.cancel();
                } else {
                    OkHttpNetworkFetcher.this.mCancellationExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            call.cancel();
                        }
                    });
                }
            }
        });
        call.enqueue(new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Response response) {
                fetchState.responseTime = SystemClock.elapsedRealtime();
                ResponseBody body = response.body();
                try {
                    long contentLength = body.contentLength();
                    if (contentLength < 0L) {
                        contentLength = 0L;
                    }
                    callback.onResponse(body.byteStream(), (int)contentLength);
                }
                catch (Exception e) {
                    OkHttpNetworkFetcher.this.handleException(call, e, callback);
                }
                finally {
                    try {
                        body.close();
                    }
                    catch (Exception e) {
                        FLog.w((String)OkHttpNetworkFetcher.TAG, (String)"Exception when closing response body", (Throwable)e);
                    }
                }
            }

            public void onFailure(Request request, IOException e) {
                OkHttpNetworkFetcher.this.handleException(call, e, callback);
            }
        });
    }

    public void onFetchCompletion(OkHttpNetworkFetchState fetchState, int byteSize) {
        fetchState.fetchCompleteTime = SystemClock.elapsedRealtime();
    }

    public Map<String, String> getExtraMap(OkHttpNetworkFetchState fetchState, int byteSize) {
        HashMap<String, String> extraMap = new HashMap<String, String>(4);
        extraMap.put(QUEUE_TIME, Long.toString(fetchState.responseTime - fetchState.submitTime));
        extraMap.put(FETCH_TIME, Long.toString(fetchState.fetchCompleteTime - fetchState.responseTime));
        extraMap.put(TOTAL_TIME, Long.toString(fetchState.fetchCompleteTime - fetchState.submitTime));
        extraMap.put(IMAGE_SIZE, Integer.toString(byteSize));
        return extraMap;
    }

    private void handleException(Call call, Exception e, NetworkFetcher.Callback callback) {
        if (call.isCanceled()) {
            callback.onCancellation();
        } else {
            callback.onFailure((Throwable)e);
        }
    }

    public static class OkHttpNetworkFetchState
    extends FetchState {
        public long submitTime;
        public long responseTime;
        public long fetchCompleteTime;

        public OkHttpNetworkFetchState(Consumer<EncodedImage> consumer, ProducerContext producerContext) {
            super(consumer, producerContext);
        }
    }
}

