/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.nativecode;

import android.os.Build;
import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.internal.Preconditions;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.nativecode.ImagePipelineNativeLoader;
import com.facebook.imagepipeline.webp.WebpSupportStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@DoNotStrip
public class WebpTranscoder {
    public static boolean isWebpNativelySupported(ImageFormat webpFormat) {
        switch (webpFormat) {
            case WEBP_SIMPLE: {
                return Build.VERSION.SDK_INT >= 14;
            }
            case WEBP_LOSSLESS: 
            case WEBP_EXTENDED: 
            case WEBP_EXTENDED_WITH_ALPHA: {
                return WebpSupportStatus.sIsExtendedWebpSupported;
            }
            case WEBP_ANIMATED: {
                return false;
            }
        }
        Preconditions.checkArgument((boolean)false);
        return false;
    }

    public static void transcodeWebpToJpeg(InputStream inputStream, OutputStream outputStream, int quality) throws IOException {
        WebpTranscoder.nativeTranscodeWebpToJpeg((InputStream)Preconditions.checkNotNull((Object)inputStream), (OutputStream)Preconditions.checkNotNull((Object)outputStream), quality);
    }

    public static void transcodeWebpToPng(InputStream inputStream, OutputStream outputStream) throws IOException {
        WebpTranscoder.nativeTranscodeWebpToPng((InputStream)Preconditions.checkNotNull((Object)inputStream), (OutputStream)Preconditions.checkNotNull((Object)outputStream));
    }

    @DoNotStrip
    private static native void nativeTranscodeWebpToJpeg(InputStream var0, OutputStream var1, int var2) throws IOException;

    @DoNotStrip
    private static native void nativeTranscodeWebpToPng(InputStream var0, OutputStream var1) throws IOException;

    static {
        ImagePipelineNativeLoader.load();
    }
}

