/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimationDriver;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;

class FrameBasedAnimationDriver
extends AnimationDriver {
    private static final double FRAME_TIME_MILLIS = 16.666666666666668;
    private long mStartFrameTimeNanos = -1L;
    private final double[] mFrames;
    private final double mToValue;
    private double mFromValue;
    private int mIterations;
    private int mCurrentLoop;

    FrameBasedAnimationDriver(ReadableMap config) {
        ReadableArray frames = config.getArray("frames");
        int numberOfFrames = frames.size();
        this.mFrames = new double[numberOfFrames];
        for (int i = 0; i < numberOfFrames; ++i) {
            this.mFrames[i] = frames.getDouble(i);
        }
        this.mToValue = config.getDouble("toValue");
        this.mIterations = config.hasKey("iterations") ? config.getInt("iterations") : 1;
        this.mCurrentLoop = 1;
        this.mHasFinished = this.mIterations == 0;
    }

    @Override
    public void runAnimationStep(long frameTimeNanos) {
        double nextValue;
        long timeFromStartMillis;
        int frameIndex;
        if (this.mStartFrameTimeNanos < 0L) {
            this.mStartFrameTimeNanos = frameTimeNanos;
            this.mFromValue = this.mAnimatedValue.mValue;
        }
        if ((frameIndex = (int)((double)(timeFromStartMillis = (frameTimeNanos - this.mStartFrameTimeNanos) / 1000000L) / 16.666666666666668)) < 0) {
            throw new IllegalStateException("Calculated frame index should never be lower than 0");
        }
        if (this.mHasFinished) {
            return;
        }
        if (frameIndex >= this.mFrames.length - 1) {
            nextValue = this.mToValue;
            if (this.mIterations == -1 || this.mCurrentLoop < this.mIterations) {
                this.mStartFrameTimeNanos = frameTimeNanos;
                ++this.mCurrentLoop;
            } else {
                this.mHasFinished = true;
            }
        } else {
            nextValue = this.mFromValue + this.mFrames[frameIndex] * (this.mToValue - this.mFromValue);
        }
        this.mAnimatedValue.mValue = nextValue;
    }
}

