/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.support.v4.text.TextDirectionHeuristicsCompat;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import com.facebook.fbui.textlayoutbuilder.GlyphWarmer;
import com.facebook.fbui.textlayoutbuilder.TextLayoutBuilder;
import com.facebook.fbui.textlayoutbuilder.glyphwarmer.GlyphWarmerImpl;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.flat.DrawTextLayout;
import com.facebook.react.flat.NodeRegion;
import com.facebook.react.flat.RCTVirtualText;
import com.facebook.react.flat.StateBuilder;
import com.facebook.react.flat.TextNodeRegion;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import com.facebook.yoga.YogaNode;
import javax.annotation.Nullable;

final class RCTText
extends RCTVirtualText
implements YogaMeasureFunction {
    private static final int ALIGNMENT_LEFT = 3;
    private static final int ALIGNMENT_RIGHT = 4;
    private static final TextLayoutBuilder sTextLayoutBuilder = new TextLayoutBuilder().setShouldCacheLayout(false).setShouldWarmText(true).setGlyphWarmer((GlyphWarmer)new GlyphWarmerImpl());
    @Nullable
    private CharSequence mText;
    @Nullable
    private DrawTextLayout mDrawCommand;
    private float mSpacingMult = 1.0f;
    private float mSpacingAdd = 0.0f;
    private int mNumberOfLines = Integer.MAX_VALUE;
    private int mAlignment = 0;

    public RCTText() {
        this.setMeasureFunction(this);
        this.getSpan().setFontSize(this.getDefaultFontSize());
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isVirtualAnchor() {
        return true;
    }

    @Override
    public long measure(YogaNode node, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
        SpannableStringBuilder text = this.getText();
        if (TextUtils.isEmpty((CharSequence)text)) {
            this.mText = null;
            return YogaMeasureOutput.make(0, 0);
        }
        this.mText = text;
        Layout layout2 = RCTText.createTextLayout((int)Math.ceil(width), widthMode, TextUtils.TruncateAt.END, true, this.mNumberOfLines, this.mNumberOfLines == 1, (CharSequence)text, this.getFontSize(), this.mSpacingAdd, this.mSpacingMult, this.getFontStyle(), this.getAlignment());
        if (this.mDrawCommand != null && !this.mDrawCommand.isFrozen()) {
            this.mDrawCommand.setLayout(layout2);
        } else {
            this.mDrawCommand = new DrawTextLayout(layout2);
        }
        return YogaMeasureOutput.make(this.mDrawCommand.getLayoutWidth(), this.mDrawCommand.getLayoutHeight());
    }

    @Override
    protected void collectState(StateBuilder stateBuilder, float left, float top, float right, float bottom, float clipLeft, float clipTop, float clipRight, float clipBottom) {
        NodeRegion nodeRegion;
        super.collectState(stateBuilder, left, top, right, bottom, clipLeft, clipTop, clipRight, clipBottom);
        if (this.mText == null) {
            SpannableStringBuilder text;
            if (bottom - top > 0.0f && right - left > 0.0f && !TextUtils.isEmpty((CharSequence)(text = this.getText()))) {
                this.mText = text;
            }
            if (this.mText == null) {
                return;
            }
        }
        boolean updateNodeRegion = false;
        if (this.mDrawCommand == null) {
            this.mDrawCommand = new DrawTextLayout(RCTText.createTextLayout((int)Math.ceil(right - left), YogaMeasureMode.EXACTLY, TextUtils.TruncateAt.END, true, this.mNumberOfLines, this.mNumberOfLines == 1, this.mText, this.getFontSize(), this.mSpacingAdd, this.mSpacingMult, this.getFontStyle(), this.getAlignment()));
            updateNodeRegion = true;
        }
        right = (left += this.getPadding(0)) + this.mDrawCommand.getLayoutWidth();
        bottom = (top += this.getPadding(1)) + this.mDrawCommand.getLayoutHeight();
        this.mDrawCommand = (DrawTextLayout)this.mDrawCommand.updateBoundsAndFreeze(left, top, right, bottom, clipLeft, clipTop, clipRight, clipBottom);
        stateBuilder.addDrawCommand(this.mDrawCommand);
        if (updateNodeRegion && (nodeRegion = this.getNodeRegion()) instanceof TextNodeRegion) {
            ((TextNodeRegion)nodeRegion).setLayout(this.mDrawCommand.getLayout());
        }
        this.performCollectAttachDetachListeners(stateBuilder);
    }

    @Override
    boolean doesDraw() {
        return true;
    }

    @ReactProp(name="lineHeight", defaultDouble=NaN)
    public void setLineHeight(double lineHeight) {
        if (Double.isNaN(lineHeight)) {
            this.mSpacingMult = 1.0f;
            this.mSpacingAdd = 0.0f;
        } else {
            this.mSpacingMult = 0.0f;
            this.mSpacingAdd = PixelUtil.toPixelFromSP((float)lineHeight);
        }
        this.notifyChanged(true);
    }

    @ReactProp(name="numberOfLines", defaultInt=0x7FFFFFFF)
    public void setNumberOfLines(int numberOfLines) {
        this.mNumberOfLines = numberOfLines;
        this.notifyChanged(true);
    }

    @Override
    void updateNodeRegion(float left, float top, float right, float bottom, boolean isVirtual) {
        NodeRegion nodeRegion = this.getNodeRegion();
        if (this.mDrawCommand == null) {
            if (!nodeRegion.matches(left, top, right, bottom, isVirtual)) {
                this.setNodeRegion(new TextNodeRegion(left, top, right, bottom, this.getReactTag(), isVirtual, null));
            }
            return;
        }
        Layout layout2 = null;
        if (nodeRegion instanceof TextNodeRegion) {
            layout2 = ((TextNodeRegion)nodeRegion).getLayout();
        }
        Layout newLayout = this.mDrawCommand.getLayout();
        if (!nodeRegion.matches(left, top, right, bottom, isVirtual) || layout2 != newLayout) {
            this.setNodeRegion(new TextNodeRegion(left, top, right, bottom, this.getReactTag(), isVirtual, newLayout));
        }
    }

    @Override
    protected int getDefaultFontSize() {
        return RCTText.fontSizeFromSp(14.0f);
    }

    @Override
    protected void notifyChanged(boolean shouldRemeasure) {
        this.dirty();
    }

    @ReactProp(name="textAlign")
    public void setTextAlign(@Nullable String textAlign) {
        if (textAlign == null || "auto".equals(textAlign)) {
            this.mAlignment = 0;
        } else if ("left".equals(textAlign)) {
            this.mAlignment = 3;
        } else if ("right".equals(textAlign)) {
            this.mAlignment = 5;
        } else if ("center".equals(textAlign)) {
            this.mAlignment = 17;
        } else {
            throw new JSApplicationIllegalArgumentException("Invalid textAlign: " + textAlign);
        }
        this.notifyChanged(false);
    }

    public Layout.Alignment getAlignment() {
        boolean isRtl = this.getLayoutDirection() == YogaDirection.RTL;
        switch (this.mAlignment) {
            case 3: {
                int index = isRtl ? 4 : 3;
                return Layout.Alignment.values()[index];
            }
            case 5: {
                int index = isRtl ? 3 : 4;
                return Layout.Alignment.values()[index];
            }
            case 17: {
                return Layout.Alignment.ALIGN_CENTER;
            }
        }
        return Layout.Alignment.ALIGN_NORMAL;
    }

    private static Layout createTextLayout(int width, YogaMeasureMode widthMode, TextUtils.TruncateAt ellipsize, boolean shouldIncludeFontPadding, int maxLines, boolean isSingleLine, CharSequence text, int textSize, float extraSpacing, float spacingMultiplier, int textStyle, Layout.Alignment textAlignment) {
        int textMeasureMode;
        switch (widthMode) {
            case UNDEFINED: {
                textMeasureMode = 0;
                break;
            }
            case EXACTLY: {
                textMeasureMode = 1;
                break;
            }
            case AT_MOST: {
                textMeasureMode = 2;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected size mode: " + (Object)((Object)widthMode));
            }
        }
        sTextLayoutBuilder.setEllipsize(ellipsize).setMaxLines(maxLines).setSingleLine(isSingleLine).setText(text).setTextSize(textSize).setWidth(width, textMeasureMode);
        sTextLayoutBuilder.setTextStyle(textStyle);
        sTextLayoutBuilder.setTextDirection(TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR);
        sTextLayoutBuilder.setIncludeFontPadding(shouldIncludeFontPadding);
        sTextLayoutBuilder.setTextSpacingExtra(extraSpacing);
        sTextLayoutBuilder.setTextSpacingMultiplier(spacingMultiplier);
        sTextLayoutBuilder.setAlignment(textAlignment);
        Layout newLayout = sTextLayoutBuilder.build();
        sTextLayoutBuilder.setText(null);
        return newLayout;
    }
}

