/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.backends.pipeline;

import android.content.res.Resources;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Supplier;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.DataSource;
import com.facebook.drawable.base.DrawableWithCaches;
import com.facebook.drawee.components.DeferredReleaser;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.drawable.OrientedDrawable;
import com.facebook.imagepipeline.animated.factory.AnimatedDrawableFactory;
import com.facebook.imagepipeline.image.CloseableAnimatedImage;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.ImageInfo;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public class PipelineDraweeController
extends AbstractDraweeController<CloseableReference<CloseableImage>, ImageInfo> {
    private static final Class<?> TAG = PipelineDraweeController.class;
    private final Resources mResources;
    private final AnimatedDrawableFactory mAnimatedDrawableFactory;
    private Supplier<DataSource<CloseableReference<CloseableImage>>> mDataSourceSupplier;

    public PipelineDraweeController(Resources resources, DeferredReleaser deferredReleaser, AnimatedDrawableFactory animatedDrawableFactory, Executor uiThreadExecutor, Supplier<DataSource<CloseableReference<CloseableImage>>> dataSourceSupplier, String id, Object callerContext) {
        super(deferredReleaser, uiThreadExecutor, id, callerContext);
        this.mResources = resources;
        this.mAnimatedDrawableFactory = animatedDrawableFactory;
        this.init(dataSourceSupplier);
    }

    public void initialize(Supplier<DataSource<CloseableReference<CloseableImage>>> dataSourceSupplier, String id, Object callerContext) {
        super.initialize(id, callerContext);
        this.init(dataSourceSupplier);
    }

    private void init(Supplier<DataSource<CloseableReference<CloseableImage>>> dataSourceSupplier) {
        this.mDataSourceSupplier = dataSourceSupplier;
    }

    protected Resources getResources() {
        return this.mResources;
    }

    protected DataSource<CloseableReference<CloseableImage>> getDataSource() {
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x: getDataSource", (Object)System.identityHashCode((Object)this));
        }
        return (DataSource)this.mDataSourceSupplier.get();
    }

    protected Drawable createDrawable(CloseableReference<CloseableImage> image) {
        Preconditions.checkState((boolean)CloseableReference.isValid(image));
        CloseableImage closeableImage = (CloseableImage)image.get();
        if (closeableImage instanceof CloseableStaticBitmap) {
            CloseableStaticBitmap closeableStaticBitmap = (CloseableStaticBitmap)closeableImage;
            BitmapDrawable bitmapDrawable = new BitmapDrawable(this.mResources, closeableStaticBitmap.getUnderlyingBitmap());
            if (closeableStaticBitmap.getRotationAngle() == 0 || closeableStaticBitmap.getRotationAngle() == -1) {
                return bitmapDrawable;
            }
            return new OrientedDrawable((Drawable)bitmapDrawable, closeableStaticBitmap.getRotationAngle());
        }
        if (closeableImage instanceof CloseableAnimatedImage) {
            return this.mAnimatedDrawableFactory.create(((CloseableAnimatedImage)closeableImage).getImageResult());
        }
        throw new UnsupportedOperationException("Unrecognized image class: " + closeableImage);
    }

    protected ImageInfo getImageInfo(CloseableReference<CloseableImage> image) {
        Preconditions.checkState((boolean)CloseableReference.isValid(image));
        return (ImageInfo)image.get();
    }

    protected int getImageHash(@Nullable CloseableReference<CloseableImage> image) {
        return image != null ? image.getValueHash() : 0;
    }

    protected void releaseImage(@Nullable CloseableReference<CloseableImage> image) {
        CloseableReference.closeSafely(image);
    }

    protected void releaseDrawable(@Nullable Drawable drawable) {
        if (drawable instanceof DrawableWithCaches) {
            ((DrawableWithCaches)drawable).dropCaches();
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("dataSourceSupplier", this.mDataSourceSupplier).toString();
    }
}

