/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import android.util.SparseArray;
import android.view.Choreographer;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.common.SystemClock;
import com.facebook.react.modules.core.JSTimersExecution;
import com.facebook.react.uimanager.ReactChoreographer;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public final class Timing
extends ReactContextBaseJavaModule
implements LifecycleEventListener {
    private final Object mTimerGuard = new Object();
    private final PriorityQueue<Timer> mTimers;
    private final SparseArray<Timer> mTimerIdsToTimers;
    private final AtomicBoolean isPaused = new AtomicBoolean(true);
    private final FrameCallback mFrameCallback = new FrameCallback();
    @Nullable
    private ReactChoreographer mReactChoreographer;
    @Nullable
    private JSTimersExecution mJSTimersModule;
    private boolean mFrameCallbackPosted = false;

    public Timing(ReactApplicationContext reactContext) {
        super(reactContext);
        this.mTimers = new PriorityQueue<Timer>(11, new Comparator<Timer>(){

            @Override
            public int compare(Timer lhs, Timer rhs) {
                long diff = lhs.mTargetTime - rhs.mTargetTime;
                if (diff == 0L) {
                    return 0;
                }
                if (diff < 0L) {
                    return -1;
                }
                return 1;
            }
        });
        this.mTimerIdsToTimers = new SparseArray();
    }

    @Override
    public void initialize() {
        this.mReactChoreographer = ReactChoreographer.getInstance();
        this.mJSTimersModule = this.getReactApplicationContext().getCatalystInstance().getJSModule(JSTimersExecution.class);
        this.getReactApplicationContext().addLifecycleEventListener(this);
    }

    @Override
    public void onHostPause() {
        this.isPaused.set(true);
        this.clearChoreographerCallback();
    }

    @Override
    public void onHostDestroy() {
        this.clearChoreographerCallback();
    }

    @Override
    public void onHostResume() {
        this.isPaused.set(false);
        this.setChoreographerCallback();
    }

    @Override
    public void onCatalystInstanceDestroy() {
        this.clearChoreographerCallback();
    }

    private void setChoreographerCallback() {
        if (!this.mFrameCallbackPosted) {
            ((ReactChoreographer)Assertions.assertNotNull((Object)this.mReactChoreographer)).postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this.mFrameCallback);
            this.mFrameCallbackPosted = true;
        }
    }

    private void clearChoreographerCallback() {
        if (this.mFrameCallbackPosted) {
            ((ReactChoreographer)Assertions.assertNotNull((Object)this.mReactChoreographer)).removeFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this.mFrameCallback);
            this.mFrameCallbackPosted = false;
        }
    }

    @Override
    public String getName() {
        return "RKTiming";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReactMethod
    public void createTimer(int callbackID, int duration, double jsSchedulingTime, boolean repeat) {
        long adjustedDuration = (long)Math.max(0.0, jsSchedulingTime - (double)SystemClock.currentTimeMillis() + (double)duration);
        long initialTargetTime = SystemClock.nanoTime() / 1000000L + adjustedDuration;
        Timer timer = new Timer(callbackID, initialTargetTime, duration, repeat);
        Object object = this.mTimerGuard;
        synchronized (object) {
            this.mTimers.add(timer);
            this.mTimerIdsToTimers.put(callbackID, (Object)timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReactMethod
    public void deleteTimer(int timerId) {
        Object object = this.mTimerGuard;
        synchronized (object) {
            Timer timer = (Timer)this.mTimerIdsToTimers.get(timerId);
            if (timer != null) {
                this.mTimerIdsToTimers.remove(timerId);
                this.mTimers.remove(timer);
            }
        }
    }

    private class FrameCallback
    implements Choreographer.FrameCallback {
        private FrameCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFrame(long frameTimeNanos) {
            if (Timing.this.isPaused.get()) {
                return;
            }
            long frameTimeMillis = frameTimeNanos / 1000000L;
            WritableArray timersToCall = null;
            Object object = Timing.this.mTimerGuard;
            synchronized (object) {
                while (!Timing.this.mTimers.isEmpty() && ((Timer)Timing.this.mTimers.peek()).mTargetTime < frameTimeMillis) {
                    Timer timer = (Timer)Timing.this.mTimers.poll();
                    if (timersToCall == null) {
                        timersToCall = Arguments.createArray();
                    }
                    timersToCall.pushInt(timer.mCallbackID);
                    if (timer.mRepeat) {
                        timer.mTargetTime = frameTimeMillis + (long)timer.mInterval;
                        Timing.this.mTimers.add(timer);
                        continue;
                    }
                    Timing.this.mTimerIdsToTimers.remove(timer.mCallbackID);
                }
            }
            if (timersToCall != null) {
                ((JSTimersExecution)Assertions.assertNotNull((Object)Timing.this.mJSTimersModule)).callTimers(timersToCall);
            }
            ((ReactChoreographer)Assertions.assertNotNull((Object)Timing.this.mReactChoreographer)).postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this);
        }
    }

    private static class Timer {
        private final int mCallbackID;
        private final boolean mRepeat;
        private final int mInterval;
        private long mTargetTime;

        private Timer(int callbackID, long initialTargetTime, int duration, boolean repeat) {
            this.mCallbackID = callbackID;
            this.mTargetTime = initialTargetTime;
            this.mInterval = duration;
            this.mRepeat = repeat;
        }
    }
}

