/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.datepicker;

import android.annotation.SuppressLint;
import android.app.DatePickerDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.widget.DatePicker;
import com.facebook.react.modules.datepicker.DismissableDatePickerDialog;
import java.util.Calendar;
import javax.annotation.Nullable;

@SuppressLint(value={"ValidFragment"})
public class DatePickerDialogFragment
extends DialogFragment {
    private static final long DEFAULT_MIN_DATE = -2208988800001L;
    @Nullable
    private DatePickerDialog.OnDateSetListener mOnDateSetListener;
    @Nullable
    private DialogInterface.OnDismissListener mOnDismissListener;

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        return DatePickerDialogFragment.createDialog(args, (Context)this.getActivity(), this.mOnDateSetListener);
    }

    static Dialog createDialog(Bundle args, Context activityContext, @Nullable DatePickerDialog.OnDateSetListener onDateSetListener) {
        Calendar c = Calendar.getInstance();
        if (args != null && args.containsKey("date")) {
            c.setTimeInMillis(args.getLong("date"));
        }
        int year = c.get(1);
        int month = c.get(2);
        int day = c.get(5);
        DismissableDatePickerDialog dialog = new DismissableDatePickerDialog(activityContext, onDateSetListener, year, month, day);
        DatePicker datePicker = dialog.getDatePicker();
        if (args != null && args.containsKey("minDate")) {
            c.setTimeInMillis(args.getLong("minDate"));
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            datePicker.setMinDate(c.getTimeInMillis());
        } else {
            datePicker.setMinDate(-2208988800001L);
        }
        if (args != null && args.containsKey("maxDate")) {
            c.setTimeInMillis(args.getLong("maxDate"));
            c.set(11, 23);
            c.set(12, 59);
            c.set(13, 59);
            c.set(14, 999);
            datePicker.setMaxDate(c.getTimeInMillis());
        }
        return dialog;
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
    }

    void setOnDateSetListener(@Nullable DatePickerDialog.OnDateSetListener onDateSetListener) {
        this.mOnDateSetListener = onDateSetListener;
    }

    void setOnDismissListener(@Nullable DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }
}

