/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.timepicker;

import android.app.Activity;
import android.app.TimePickerDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.widget.TimePicker;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.modules.timepicker.SupportTimePickerDialogFragment;
import com.facebook.react.modules.timepicker.TimePickerDialogFragment;
import javax.annotation.Nullable;

public class TimePickerDialogModule
extends ReactContextBaseJavaModule {
    @VisibleForTesting
    public static final String FRAGMENT_TAG = "TimePickerAndroid";
    private static final String ERROR_NO_ACTIVITY = "E_NO_ACTIVITY";
    static final String ARG_HOUR = "hour";
    static final String ARG_MINUTE = "minute";
    static final String ARG_IS24HOUR = "is24Hour";
    static final String ACTION_TIME_SET = "timeSetAction";
    static final String ACTION_DISMISSED = "dismissedAction";

    public TimePickerDialogModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return FRAGMENT_TAG;
    }

    @ReactMethod
    public void open(@Nullable ReadableMap options, Promise promise) {
        Activity activity = this.getCurrentActivity();
        if (activity == null) {
            promise.reject(ERROR_NO_ACTIVITY, "Tried to open a TimePicker dialog while not attached to an Activity");
            return;
        }
        if (activity instanceof FragmentActivity) {
            FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            DialogFragment oldFragment = (DialogFragment)fragmentManager.findFragmentByTag(FRAGMENT_TAG);
            if (oldFragment != null) {
                oldFragment.dismiss();
            }
            SupportTimePickerDialogFragment fragment = new SupportTimePickerDialogFragment();
            if (options != null) {
                Bundle args = this.createFragmentArguments(options);
                fragment.setArguments(args);
            }
            TimePickerDialogListener listener = new TimePickerDialogListener(promise);
            fragment.setOnDismissListener(listener);
            fragment.setOnTimeSetListener(listener);
            fragment.show(fragmentManager, FRAGMENT_TAG);
        } else {
            android.app.FragmentManager fragmentManager = activity.getFragmentManager();
            android.app.DialogFragment oldFragment = (android.app.DialogFragment)fragmentManager.findFragmentByTag(FRAGMENT_TAG);
            if (oldFragment != null) {
                oldFragment.dismiss();
            }
            TimePickerDialogFragment fragment = new TimePickerDialogFragment();
            if (options != null) {
                Bundle args = this.createFragmentArguments(options);
                fragment.setArguments(args);
            }
            TimePickerDialogListener listener = new TimePickerDialogListener(promise);
            fragment.setOnDismissListener(listener);
            fragment.setOnTimeSetListener(listener);
            fragment.show(fragmentManager, FRAGMENT_TAG);
        }
    }

    private Bundle createFragmentArguments(ReadableMap options) {
        Bundle args = new Bundle();
        if (options.hasKey(ARG_HOUR) && !options.isNull(ARG_HOUR)) {
            args.putInt(ARG_HOUR, options.getInt(ARG_HOUR));
        }
        if (options.hasKey(ARG_MINUTE) && !options.isNull(ARG_MINUTE)) {
            args.putInt(ARG_MINUTE, options.getInt(ARG_MINUTE));
        }
        if (options.hasKey(ARG_IS24HOUR) && !options.isNull(ARG_IS24HOUR)) {
            args.putBoolean(ARG_IS24HOUR, options.getBoolean(ARG_IS24HOUR));
        }
        return args;
    }

    private class TimePickerDialogListener
    implements TimePickerDialog.OnTimeSetListener,
    DialogInterface.OnDismissListener {
        private final Promise mPromise;
        private boolean mPromiseResolved = false;

        public TimePickerDialogListener(Promise promise) {
            this.mPromise = promise;
        }

        public void onTimeSet(TimePicker view, int hour, int minute) {
            if (!this.mPromiseResolved && TimePickerDialogModule.this.getReactApplicationContext().hasActiveCatalystInstance()) {
                WritableNativeMap result = new WritableNativeMap();
                result.putString("action", TimePickerDialogModule.ACTION_TIME_SET);
                result.putInt(TimePickerDialogModule.ARG_HOUR, hour);
                result.putInt(TimePickerDialogModule.ARG_MINUTE, minute);
                this.mPromise.resolve(result);
                this.mPromiseResolved = true;
            }
        }

        public void onDismiss(DialogInterface dialog) {
            if (!this.mPromiseResolved && TimePickerDialogModule.this.getReactApplicationContext().hasActiveCatalystInstance()) {
                WritableNativeMap result = new WritableNativeMap();
                result.putString("action", TimePickerDialogModule.ACTION_DISMISSED);
                this.mPromise.resolve(result);
                this.mPromiseResolved = true;
            }
        }
    }
}

