/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.toolbar;

import android.content.Context;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.backends.pipeline.PipelineDraweeControllerBuilder;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.drawee.view.DraweeHolder;
import com.facebook.drawee.view.MultiDraweeHolder;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.views.toolbar.DrawableWithIntrinsicSize;
import javax.annotation.Nullable;

public class ReactToolbar
extends Toolbar {
    private static final String PROP_ACTION_ICON = "icon";
    private static final String PROP_ACTION_SHOW = "show";
    private static final String PROP_ACTION_SHOW_WITH_TEXT = "showWithText";
    private static final String PROP_ACTION_TITLE = "title";
    private final DraweeHolder mLogoHolder;
    private final DraweeHolder mNavIconHolder;
    private final DraweeHolder mOverflowIconHolder;
    private final MultiDraweeHolder<GenericDraweeHierarchy> mActionsHolder = new MultiDraweeHolder();
    private final ControllerListener<ImageInfo> mLogoControllerListener = new BaseControllerListener<ImageInfo>(){

        public void onFinalImageSet(String id2, @Nullable ImageInfo imageInfo, @Nullable Animatable animatable) {
            if (imageInfo != null) {
                DrawableWithIntrinsicSize logoDrawable = new DrawableWithIntrinsicSize(ReactToolbar.this.mLogoHolder.getTopLevelDrawable(), imageInfo);
                ReactToolbar.this.setLogo((Drawable)logoDrawable);
            }
        }
    };
    private final ControllerListener<ImageInfo> mNavIconControllerListener = new BaseControllerListener<ImageInfo>(){

        public void onFinalImageSet(String id2, @Nullable ImageInfo imageInfo, @Nullable Animatable animatable) {
            if (imageInfo != null) {
                DrawableWithIntrinsicSize navIconDrawable = new DrawableWithIntrinsicSize(ReactToolbar.this.mNavIconHolder.getTopLevelDrawable(), imageInfo);
                ReactToolbar.this.setNavigationIcon((Drawable)navIconDrawable);
            }
        }
    };
    private final ControllerListener<ImageInfo> mOverflowIconControllerListener = new BaseControllerListener<ImageInfo>(){

        public void onFinalImageSet(String id2, @Nullable ImageInfo imageInfo, @Nullable Animatable animatable) {
            if (imageInfo != null) {
                DrawableWithIntrinsicSize overflowIconDrawable = new DrawableWithIntrinsicSize(ReactToolbar.this.mOverflowIconHolder.getTopLevelDrawable(), imageInfo);
                ReactToolbar.this.setOverflowIcon((Drawable)overflowIconDrawable);
            }
        }
    };
    private final Runnable mLayoutRunnable = new Runnable(){

        @Override
        public void run() {
            ReactToolbar.this.measure(View.MeasureSpec.makeMeasureSpec((int)ReactToolbar.this.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)ReactToolbar.this.getHeight(), (int)0x40000000));
            ReactToolbar.this.layout(ReactToolbar.this.getLeft(), ReactToolbar.this.getTop(), ReactToolbar.this.getRight(), ReactToolbar.this.getBottom());
        }
    };

    public ReactToolbar(Context context) {
        super(context);
        this.mLogoHolder = DraweeHolder.create((DraweeHierarchy)this.createDraweeHierarchy(), (Context)context);
        this.mNavIconHolder = DraweeHolder.create((DraweeHierarchy)this.createDraweeHierarchy(), (Context)context);
        this.mOverflowIconHolder = DraweeHolder.create((DraweeHierarchy)this.createDraweeHierarchy(), (Context)context);
    }

    public void requestLayout() {
        super.requestLayout();
        this.post(this.mLayoutRunnable);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.detachDraweeHolders();
    }

    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        this.detachDraweeHolders();
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.attachDraweeHolders();
    }

    public void onFinishTemporaryDetach() {
        super.onFinishTemporaryDetach();
        this.attachDraweeHolders();
    }

    private void detachDraweeHolders() {
        this.mLogoHolder.onDetach();
        this.mNavIconHolder.onDetach();
        this.mOverflowIconHolder.onDetach();
        this.mActionsHolder.onDetach();
    }

    private void attachDraweeHolders() {
        this.mLogoHolder.onAttach();
        this.mNavIconHolder.onAttach();
        this.mOverflowIconHolder.onAttach();
        this.mActionsHolder.onAttach();
    }

    void setLogoSource(@Nullable ReadableMap source) {
        String uri;
        String string2 = uri = source != null ? source.getString("uri") : null;
        if (uri == null) {
            this.setLogo(null);
        } else if (uri.startsWith("http://") || uri.startsWith("https://")) {
            AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setUri(Uri.parse((String)uri)).setControllerListener(this.mLogoControllerListener)).setOldController(this.mLogoHolder.getController())).build();
            this.mLogoHolder.setController((DraweeController)controller);
        } else {
            this.setLogo(this.getDrawableResourceByName(uri));
        }
    }

    void setNavIconSource(@Nullable ReadableMap source) {
        String uri;
        String string2 = uri = source != null ? source.getString("uri") : null;
        if (uri == null) {
            this.setNavigationIcon(null);
        } else if (uri.startsWith("http://") || uri.startsWith("https://")) {
            AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setUri(Uri.parse((String)uri)).setControllerListener(this.mNavIconControllerListener)).setOldController(this.mNavIconHolder.getController())).build();
            this.mNavIconHolder.setController((DraweeController)controller);
        } else {
            this.setNavigationIcon(this.getDrawableResourceByName(uri));
        }
    }

    void setOverflowIconSource(@Nullable ReadableMap source) {
        String uri;
        String string2 = uri = source != null ? source.getString("uri") : null;
        if (uri == null) {
            this.setOverflowIcon(null);
        } else if (uri.startsWith("http://") || uri.startsWith("https://")) {
            AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setUri(Uri.parse((String)uri)).setControllerListener(this.mOverflowIconControllerListener)).setOldController(this.mOverflowIconHolder.getController())).build();
            this.mOverflowIconHolder.setController((DraweeController)controller);
        } else {
            this.setOverflowIcon(this.getDrawableByName(uri));
        }
    }

    void setActions(@Nullable ReadableArray actions) {
        Menu menu = this.getMenu();
        menu.clear();
        this.mActionsHolder.clear();
        if (actions != null) {
            for (int i = 0; i < actions.size(); ++i) {
                int showAsAction;
                ReadableMap icon;
                ReadableMap action = actions.getMap(i);
                MenuItem item = menu.add(0, 0, i, (CharSequence)action.getString(PROP_ACTION_TITLE));
                ReadableMap readableMap = icon = action.hasKey(PROP_ACTION_ICON) ? action.getMap(PROP_ACTION_ICON) : null;
                if (icon != null) {
                    String iconSource = icon.getString("uri");
                    if (iconSource.startsWith("http://") || iconSource.startsWith("https://")) {
                        this.setMenuItemIcon(item, icon);
                    } else {
                        item.setIcon(this.getDrawableResourceByName(iconSource));
                    }
                }
                int n = showAsAction = action.hasKey(PROP_ACTION_SHOW) ? action.getInt(PROP_ACTION_SHOW) : 0;
                if (action.hasKey(PROP_ACTION_SHOW_WITH_TEXT) && action.getBoolean(PROP_ACTION_SHOW_WITH_TEXT)) {
                    showAsAction |= 4;
                }
                item.setShowAsAction(showAsAction);
            }
        }
    }

    private void setMenuItemIcon(MenuItem item, ReadableMap icon) {
        String iconSource = icon.getString("uri");
        DraweeHolder holder = DraweeHolder.create((DraweeHierarchy)this.createDraweeHierarchy(), (Context)this.getContext());
        AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setUri(Uri.parse((String)iconSource)).setControllerListener((ControllerListener)new ActionIconControllerListener(item, holder))).setOldController(holder.getController())).build();
        holder.setController((DraweeController)controller);
        this.mActionsHolder.add(holder);
    }

    private GenericDraweeHierarchy createDraweeHierarchy() {
        return new GenericDraweeHierarchyBuilder(this.getResources()).setActualImageScaleType(ScalingUtils.ScaleType.FIT_CENTER).setFadeDuration(0).build();
    }

    private int getDrawableResourceByName(String name) {
        return this.getResources().getIdentifier(name, "drawable", this.getContext().getPackageName());
    }

    private Drawable getDrawableByName(String name) {
        return this.getResources().getDrawable(this.getDrawableResourceByName(name));
    }

    private static class ActionIconControllerListener
    extends BaseControllerListener<ImageInfo> {
        private final MenuItem mItem;
        private final DraweeHolder mHolder;

        ActionIconControllerListener(MenuItem item, DraweeHolder holder) {
            this.mItem = item;
            this.mHolder = holder;
        }

        public void onFinalImageSet(String id2, @Nullable ImageInfo imageInfo, @Nullable Animatable animatable) {
            if (imageInfo != null) {
                this.mItem.setIcon((Drawable)new DrawableWithIntrinsicSize(this.mHolder.getTopLevelDrawable(), imageInfo));
            }
        }
    }
}

