/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.references;

import com.facebook.common.internal.Closeables;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.common.references.SharedReference;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public abstract class CloseableReference<T>
implements Cloneable,
Closeable {
    private static Class<CloseableReference> TAG = CloseableReference.class;
    private static final ResourceReleaser<Closeable> DEFAULT_CLOSEABLE_RELEASER = new ResourceReleaser<Closeable>(){

        @Override
        public void release(Closeable value) {
            try {
                Closeables.close(value, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    };
    private static volatile boolean sUseFinalizers = true;

    @Nullable
    public static <T extends Closeable> CloseableReference<T> of(@Nullable T t) {
        if (t == null) {
            return null;
        }
        return CloseableReference.makeCloseableReference(t, DEFAULT_CLOSEABLE_RELEASER);
    }

    @Nullable
    public static <T> CloseableReference<T> of(@Nullable T t, ResourceReleaser<T> resourceReleaser) {
        if (t == null) {
            return null;
        }
        return CloseableReference.makeCloseableReference(t, resourceReleaser);
    }

    private static <T> CloseableReference<T> makeCloseableReference(@Nullable T t, ResourceReleaser<T> resourceReleaser) {
        if (sUseFinalizers) {
            return new CloseableReferenceWithFinalizer(t, resourceReleaser);
        }
        return new CloseableReferenceWithoutFinalizer(t, resourceReleaser);
    }

    @Override
    public abstract void close();

    public abstract T get();

    public abstract CloseableReference<T> clone();

    public abstract CloseableReference<T> cloneOrNull();

    public abstract boolean isValid();

    @VisibleForTesting
    public abstract SharedReference<T> getUnderlyingReferenceTestOnly();

    public abstract int getValueHash();

    public static boolean isValid(@Nullable CloseableReference<?> ref) {
        return ref != null && ref.isValid();
    }

    @Nullable
    public static <T> CloseableReference<T> cloneOrNull(@Nullable CloseableReference<T> ref) {
        return ref != null ? ref.cloneOrNull() : null;
    }

    public static <T> List<CloseableReference<T>> cloneOrNull(Collection<CloseableReference<T>> refs) {
        if (refs == null) {
            return null;
        }
        ArrayList<CloseableReference<T>> ret = new ArrayList<CloseableReference<T>>(refs.size());
        for (CloseableReference<T> ref : refs) {
            ret.add(CloseableReference.cloneOrNull(ref));
        }
        return ret;
    }

    public static void closeSafely(@Nullable CloseableReference<?> ref) {
        if (ref != null) {
            ref.close();
        }
    }

    public static void closeSafely(@Nullable Iterable<? extends CloseableReference<?>> references) {
        if (references != null) {
            for (CloseableReference<?> ref : references) {
                CloseableReference.closeSafely(ref);
            }
        }
    }

    public static void setUseFinalizers(boolean useFinalizers) {
        sUseFinalizers = useFinalizers;
    }

    private static class CloseableReferenceWithFinalizer<T>
    extends CloseableReference<T> {
        @GuardedBy(value="this")
        private boolean mIsClosed = false;
        private final SharedReference<T> mSharedReference;

        private CloseableReferenceWithFinalizer(SharedReference<T> sharedReference) {
            this.mSharedReference = Preconditions.checkNotNull(sharedReference);
            sharedReference.addReference();
        }

        private CloseableReferenceWithFinalizer(T t, ResourceReleaser<T> resourceReleaser) {
            this.mSharedReference = new SharedReference<T>(t, resourceReleaser);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void finalize() throws Throwable {
            try {
                CloseableReferenceWithFinalizer closeableReferenceWithFinalizer = this;
                synchronized (closeableReferenceWithFinalizer) {
                    if (this.mIsClosed) {
                        return;
                    }
                }
                FLog.w(TAG, "Finalized without closing: %x %x (type = %s)", System.identityHashCode(this), System.identityHashCode(this.mSharedReference), this.mSharedReference.get().getClass().getSimpleName());
                this.close();
                return;
            }
            finally {
                super.finalize();
            }
        }

        @Override
        public synchronized T get() {
            Preconditions.checkState(!this.mIsClosed);
            return this.mSharedReference.get();
        }

        @Override
        public synchronized CloseableReference<T> clone() {
            Preconditions.checkState(this.isValid());
            return new CloseableReferenceWithFinalizer<T>(this.mSharedReference);
        }

        @Override
        public synchronized CloseableReference<T> cloneOrNull() {
            if (this.isValid()) {
                return this.clone();
            }
            return null;
        }

        @Override
        public synchronized boolean isValid() {
            return !this.mIsClosed;
        }

        @Override
        public synchronized SharedReference<T> getUnderlyingReferenceTestOnly() {
            return this.mSharedReference;
        }

        @Override
        public int getValueHash() {
            return this.isValid() ? System.identityHashCode(this.mSharedReference.get()) : 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            CloseableReferenceWithFinalizer closeableReferenceWithFinalizer = this;
            synchronized (closeableReferenceWithFinalizer) {
                if (this.mIsClosed) {
                    return;
                }
                this.mIsClosed = true;
            }
            this.mSharedReference.deleteReference();
        }
    }

    private static class CloseableReferenceWithoutFinalizer<T>
    extends CloseableReference<T> {
        private static final ReferenceQueue<CloseableReference> REF_QUEUE = new ReferenceQueue();
        private final SharedReference<T> mSharedReference;
        private final Destructor mDestructor;

        private CloseableReferenceWithoutFinalizer(SharedReference<T> sharedReference) {
            this.mSharedReference = Preconditions.checkNotNull(sharedReference);
            sharedReference.addReference();
            this.mDestructor = new Destructor(this, REF_QUEUE);
        }

        private CloseableReferenceWithoutFinalizer(T t, ResourceReleaser<T> resourceReleaser) {
            this.mSharedReference = new SharedReference<T>(t, resourceReleaser);
            this.mDestructor = new Destructor(this, REF_QUEUE);
        }

        @Override
        public void close() {
            this.mDestructor.destroy(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            Destructor destructor = this.mDestructor;
            synchronized (destructor) {
                Preconditions.checkState(!this.mDestructor.isDestroyed());
                return this.mSharedReference.get();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CloseableReference<T> clone() {
            Destructor destructor = this.mDestructor;
            synchronized (destructor) {
                Preconditions.checkState(!this.mDestructor.isDestroyed());
                return new CloseableReferenceWithoutFinalizer<T>(this.mSharedReference);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CloseableReference<T> cloneOrNull() {
            Destructor destructor = this.mDestructor;
            synchronized (destructor) {
                if (!this.mDestructor.isDestroyed()) {
                    return new CloseableReferenceWithoutFinalizer<T>(this.mSharedReference);
                }
                return null;
            }
        }

        @Override
        public boolean isValid() {
            return !this.mDestructor.isDestroyed();
        }

        @Override
        public SharedReference<T> getUnderlyingReferenceTestOnly() {
            return this.mSharedReference;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getValueHash() {
            Destructor destructor = this.mDestructor;
            synchronized (destructor) {
                return this.isValid() ? System.identityHashCode(this.mSharedReference.get()) : 0;
            }
        }

        static {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Destructor ref = (Destructor)REF_QUEUE.remove();
                                ref.destroy(false);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            }, "CloseableReferenceDestructorThread").start();
        }

        private static class Destructor
        extends PhantomReference<CloseableReference> {
            @GuardedBy(value="Destructor.class")
            private static Destructor sHead;
            private final SharedReference mSharedReference;
            @GuardedBy(value="Destructor.class")
            private Destructor next;
            @GuardedBy(value="Destructor.class")
            private Destructor previous;
            @GuardedBy(value="this")
            private boolean destroyed;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Destructor(CloseableReferenceWithoutFinalizer referent, ReferenceQueue<? super CloseableReference> referenceQueue) {
                super(referent, referenceQueue);
                this.mSharedReference = referent.mSharedReference;
                Class<Destructor> clazz = Destructor.class;
                synchronized (Destructor.class) {
                    if (sHead != null) {
                        Destructor.sHead.next = this;
                        this.previous = sHead;
                    }
                    sHead = this;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }

            public synchronized boolean isDestroyed() {
                return this.destroyed;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void destroy(boolean correctly) {
                Object object = this;
                synchronized (object) {
                    if (this.destroyed) {
                        return;
                    }
                    this.destroyed = true;
                }
                object = Destructor.class;
                synchronized (Destructor.class) {
                    if (this.previous != null) {
                        this.previous.next = this.next;
                    }
                    if (this.next != null) {
                        this.next.previous = this.previous;
                    } else {
                        sHead = this.previous;
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    if (!correctly) {
                        FLog.w(TAG, "GCed without closing: %x %x (type = %s)", System.identityHashCode(this), System.identityHashCode(this.mSharedReference), this.mSharedReference.get().getClass().getSimpleName());
                    }
                    this.mSharedReference.deleteReference();
                    return;
                }
            }
        }
    }
}

