/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import javax.annotation.Nullable;

class InterpolationAnimatedNode
extends ValueAnimatedNode {
    public static final String EXTRAPOLATE_TYPE_IDENTITY = "identity";
    public static final String EXTRAPOLATE_TYPE_CLAMP = "clamp";
    public static final String EXTRAPOLATE_TYPE_EXTEND = "extend";
    private final double[] mInputRange;
    private final double[] mOutputRange;
    private final String mExtrapolateLeft;
    private final String mExtrapolateRight;
    @Nullable
    private ValueAnimatedNode mParent;

    private static double[] fromDoubleArray(ReadableArray ary) {
        double[] res = new double[ary.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = ary.getDouble(i);
        }
        return res;
    }

    private static double interpolate(double value, double inputMin, double inputMax, double outputMin, double outputMax, String extrapolateLeft, String extrapolateRight) {
        double result = value;
        if (result < inputMin) {
            switch (extrapolateLeft) {
                case "identity": {
                    return result;
                }
                case "clamp": {
                    result = inputMin;
                    break;
                }
                case "extend": {
                    break;
                }
                default: {
                    throw new JSApplicationIllegalArgumentException("Invalid extrapolation type " + extrapolateLeft + "for left extrapolation");
                }
            }
        }
        if (result > inputMax) {
            switch (extrapolateRight) {
                case "identity": {
                    return result;
                }
                case "clamp": {
                    result = inputMax;
                    break;
                }
                case "extend": {
                    break;
                }
                default: {
                    throw new JSApplicationIllegalArgumentException("Invalid extrapolation type " + extrapolateRight + "for right extrapolation");
                }
            }
        }
        return outputMin + (outputMax - outputMin) * (result - inputMin) / (inputMax - inputMin);
    }

    static double interpolate(double value, double[] inputRange, double[] outputRange, String extrapolateLeft, String extrapolateRight) {
        int rangeIndex = InterpolationAnimatedNode.findRangeIndex(value, inputRange);
        return InterpolationAnimatedNode.interpolate(value, inputRange[rangeIndex], inputRange[rangeIndex + 1], outputRange[rangeIndex], outputRange[rangeIndex + 1], extrapolateLeft, extrapolateRight);
    }

    private static int findRangeIndex(double value, double[] ranges) {
        int index;
        for (index = 1; index < ranges.length - 1 && !(ranges[index] >= value); ++index) {
        }
        return index - 1;
    }

    public InterpolationAnimatedNode(ReadableMap config) {
        this.mInputRange = InterpolationAnimatedNode.fromDoubleArray(config.getArray("inputRange"));
        this.mOutputRange = InterpolationAnimatedNode.fromDoubleArray(config.getArray("outputRange"));
        this.mExtrapolateLeft = config.getString("extrapolateLeft");
        this.mExtrapolateRight = config.getString("extrapolateRight");
    }

    @Override
    public void onAttachedToNode(AnimatedNode parent) {
        if (this.mParent != null) {
            throw new IllegalStateException("Parent already attached");
        }
        if (!(parent instanceof ValueAnimatedNode)) {
            throw new IllegalArgumentException("Parent is of an invalid type");
        }
        this.mParent = (ValueAnimatedNode)parent;
    }

    @Override
    public void onDetachedFromNode(AnimatedNode parent) {
        if (parent != this.mParent) {
            throw new IllegalArgumentException("Invalid parent node provided");
        }
        this.mParent = null;
    }

    @Override
    public void update() {
        if (this.mParent == null) {
            throw new IllegalStateException("Trying to update interpolation node that has not been attached to the parent");
        }
        this.mValue = InterpolationAnimatedNode.interpolate(this.mParent.getValue(), this.mInputRange, this.mOutputRange, this.mExtrapolateLeft, this.mExtrapolateRight);
    }
}

