/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.module.model.ReactModuleInfo;
import com.facebook.systrace.SystraceMessage;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Provider;

@DoNotStrip
public class ModuleHolder {
    private static final AtomicInteger sInstanceKeyCounter = new AtomicInteger(1);
    private final int mInstanceKey = sInstanceKeyCounter.getAndIncrement();
    private final String mName;
    private final boolean mCanOverrideExistingModule;
    private final boolean mHasConstants;
    @Nullable
    private Provider<? extends NativeModule> mProvider;
    @Nullable
    @GuardedBy(value="this")
    private NativeModule mModule;
    @GuardedBy(value="this")
    private boolean mInitializable;
    @GuardedBy(value="this")
    private boolean mIsCreating;
    @GuardedBy(value="this")
    private boolean mIsInitializing;

    public ModuleHolder(ReactModuleInfo moduleInfo, Provider<? extends NativeModule> provider) {
        this.mName = moduleInfo.name();
        this.mCanOverrideExistingModule = moduleInfo.canOverrideExistingModule();
        this.mHasConstants = moduleInfo.hasConstants();
        this.mProvider = provider;
        if (moduleInfo.needsEagerInit()) {
            this.mModule = this.create();
        }
    }

    public ModuleHolder(NativeModule nativeModule) {
        this.mName = nativeModule.getName();
        this.mCanOverrideExistingModule = nativeModule.canOverrideExistingModule();
        this.mHasConstants = true;
        this.mModule = nativeModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markInitializable() {
        boolean shouldInitializeNow = false;
        NativeModule module = null;
        ModuleHolder moduleHolder = this;
        synchronized (moduleHolder) {
            this.mInitializable = true;
            if (this.mModule != null) {
                Assertions.assertCondition((!this.mIsInitializing ? 1 : 0) != 0);
                shouldInitializeNow = true;
                module = this.mModule;
            }
        }
        if (shouldInitializeNow) {
            this.doInitialize(module);
        }
    }

    synchronized boolean hasInstance() {
        return this.mModule != null;
    }

    public synchronized void destroy() {
        if (this.mModule != null) {
            this.mModule.onCatalystInstanceDestroy();
        }
    }

    @DoNotStrip
    public String getName() {
        return this.mName;
    }

    public boolean getCanOverrideExistingModule() {
        return this.mCanOverrideExistingModule;
    }

    public boolean getHasConstants() {
        return this.mHasConstants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    public NativeModule getModule() {
        boolean shouldCreate = false;
        ModuleHolder moduleHolder = this;
        synchronized (moduleHolder) {
            if (this.mModule != null) {
                return this.mModule;
            }
            if (!this.mIsCreating) {
                shouldCreate = true;
                this.mIsCreating = true;
            }
        }
        if (shouldCreate) {
            NativeModule module = this.create();
            moduleHolder = this;
            synchronized (moduleHolder) {
                this.mIsCreating = false;
                this.notifyAll();
            }
            return module;
        }
        moduleHolder = this;
        synchronized (moduleHolder) {
            while (this.mModule == null && this.mIsCreating) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            return (NativeModule)Assertions.assertNotNull((Object)this.mModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeModule create() {
        NativeModule module;
        SoftAssertions.assertCondition(this.mModule == null, "Creating an already created module.");
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_MODULE_START, this.mName, this.mInstanceKey);
        SystraceMessage.beginSection(0L, "ModuleHolder.createModule").arg("name", this.mName).flush();
        try {
            module = (NativeModule)((Provider)Assertions.assertNotNull(this.mProvider)).get();
            this.mProvider = null;
            boolean shouldInitializeNow = false;
            ModuleHolder moduleHolder = this;
            synchronized (moduleHolder) {
                this.mModule = module;
                if (this.mInitializable && !this.mIsInitializing) {
                    shouldInitializeNow = true;
                }
            }
            if (shouldInitializeNow) {
                this.doInitialize(module);
            }
        }
        finally {
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_MODULE_END, this.mInstanceKey);
            SystraceMessage.endSection(0L).flush();
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitialize(NativeModule module) {
        block10: {
            SystraceMessage.beginSection(0L, "ModuleHolder.initialize").arg("name", this.mName).flush();
            ReactMarker.logMarker(ReactMarkerConstants.INITIALIZE_MODULE_START, this.mName, this.mInstanceKey);
            try {
                boolean shouldInitialize = false;
                ModuleHolder moduleHolder = this;
                synchronized (moduleHolder) {
                    if (this.mInitializable && !this.mIsInitializing) {
                        shouldInitialize = true;
                        this.mIsInitializing = true;
                    }
                }
                if (!shouldInitialize) break block10;
                module.initialize();
                moduleHolder = this;
                synchronized (moduleHolder) {
                    this.mIsInitializing = false;
                }
            }
            finally {
                ReactMarker.logMarker(ReactMarkerConstants.INITIALIZE_MODULE_END, this.mInstanceKey);
                SystraceMessage.endSection(0L).flush();
            }
        }
    }
}

