/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.common.DebugServerException;
import com.facebook.react.devsupport.MultipartStreamReader;
import com.facebook.react.devsupport.interfaces.DevBundleDownloadListener;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.json.JSONException;
import org.json.JSONObject;

public class BundleDownloader {
    private final OkHttpClient mClient;
    @Nullable
    private Call mDownloadBundleFromURLCall;

    public BundleDownloader(OkHttpClient client) {
        this.mClient = client;
    }

    public void downloadBundleFromURL(final DevBundleDownloadListener callback, final File outputFile, String bundleURL) {
        Request request = new Request.Builder().url(bundleURL).build();
        this.mDownloadBundleFromURLCall = (Call)Assertions.assertNotNull((Object)this.mClient.newCall(request));
        this.mDownloadBundleFromURLCall.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (BundleDownloader.this.mDownloadBundleFromURLCall == null || BundleDownloader.this.mDownloadBundleFromURLCall.isCanceled()) {
                    BundleDownloader.this.mDownloadBundleFromURLCall = null;
                    return;
                }
                BundleDownloader.this.mDownloadBundleFromURLCall = null;
                callback.onFailure(DebugServerException.makeGeneric("Could not connect to development server.", "URL: " + call.request().url().toString(), e));
            }

            public void onResponse(Call call, final Response response) throws IOException {
                if (BundleDownloader.this.mDownloadBundleFromURLCall == null || BundleDownloader.this.mDownloadBundleFromURLCall.isCanceled()) {
                    BundleDownloader.this.mDownloadBundleFromURLCall = null;
                    return;
                }
                BundleDownloader.this.mDownloadBundleFromURLCall = null;
                final String url = response.request().url().toString();
                String contentType = response.header("content-type");
                Pattern regex = Pattern.compile("multipart/mixed;.*boundary=\"([^\"]+)\"");
                Matcher match = regex.matcher(contentType);
                if (match.find()) {
                    String boundary = match.group(1);
                    MultipartStreamReader bodyReader = new MultipartStreamReader(response.body().source(), boundary);
                    boolean completed = bodyReader.readAllParts(new MultipartStreamReader.ChunkCallback(){

                        @Override
                        public void execute(Map<String, String> headers, Buffer body, boolean finished) throws IOException {
                            if (finished) {
                                int status = response.code();
                                if (headers.containsKey("X-Http-Status")) {
                                    status = Integer.parseInt(headers.get("X-Http-Status"));
                                }
                                BundleDownloader.this.processBundleResult(url, status, (BufferedSource)body, outputFile, callback);
                            } else {
                                if (!headers.containsKey("Content-Type") || !headers.get("Content-Type").equals("application/json")) {
                                    return;
                                }
                                try {
                                    JSONObject progress = new JSONObject(body.readUtf8());
                                    String status = null;
                                    if (progress.has("status")) {
                                        status = progress.getString("status");
                                    }
                                    Integer done = null;
                                    if (progress.has("done")) {
                                        done = progress.getInt("done");
                                    }
                                    Integer total = null;
                                    if (progress.has("total")) {
                                        total = progress.getInt("total");
                                    }
                                    callback.onProgress(status, done, total);
                                }
                                catch (JSONException e) {
                                    FLog.e((String)"ReactNative", (String)("Error parsing progress JSON. " + e.toString()));
                                }
                            }
                        }
                    });
                    if (!completed) {
                        callback.onFailure(new DebugServerException("Error while reading multipart response.\n\nResponse code: " + response.code() + "\n\n" + "URL: " + call.request().url().toString() + "\n\n"));
                    }
                } else {
                    BundleDownloader.this.processBundleResult(url, response.code(), Okio.buffer((Source)response.body().source()), outputFile, callback);
                }
            }
        });
    }

    public void cancelDownloadBundleFromURL() {
        if (this.mDownloadBundleFromURLCall != null) {
            this.mDownloadBundleFromURLCall.cancel();
            this.mDownloadBundleFromURLCall = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBundleResult(String url, int statusCode, BufferedSource body, File outputFile, DevBundleDownloadListener callback) throws IOException {
        if (statusCode != 200) {
            String bodyString = body.readUtf8();
            DebugServerException debugServerException = DebugServerException.parse(bodyString);
            if (debugServerException != null) {
                callback.onFailure(debugServerException);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("The development server returned response error code: ").append(statusCode).append("\n\n").append("URL: ").append(url).append("\n\n").append("Body:\n").append(bodyString);
                callback.onFailure(new DebugServerException(sb.toString()));
            }
            return;
        }
        try (Sink output = null;){
            output = Okio.sink((File)outputFile);
            body.readAll(output);
            callback.onSuccess();
        }
    }
}

