/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.network.OkHttpCallUtil;
import com.facebook.react.devsupport.BundleDownloader;
import com.facebook.react.devsupport.DevInternalSettings;
import com.facebook.react.devsupport.InspectorPackagerConnection;
import com.facebook.react.devsupport.StackTraceHelper;
import com.facebook.react.devsupport.interfaces.PackagerStatusCallback;
import com.facebook.react.devsupport.interfaces.StackFrame;
import com.facebook.react.modules.systeminfo.AndroidInfoHelpers;
import com.facebook.react.packagerconnection.FileIoHandler;
import com.facebook.react.packagerconnection.JSPackagerClient;
import com.facebook.react.packagerconnection.NotificationOnlyHandler;
import com.facebook.react.packagerconnection.RequestHandler;
import com.facebook.react.packagerconnection.RequestOnlyHandler;
import com.facebook.react.packagerconnection.Responder;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DevServerHelper {
    public static final String RELOAD_APP_EXTRA_JS_PROXY = "jsproxy";
    private static final String RELOAD_APP_ACTION_SUFFIX = ".RELOAD_APP_ACTION";
    private static final String BUNDLE_URL_FORMAT = "http://%s/%s.bundle?platform=android&dev=%s&hot=%s&minify=%s";
    private static final String RESOURCE_URL_FORMAT = "http://%s/%s";
    private static final String SOURCE_MAP_URL_FORMAT = "http://%s/%s.bundle?platform=android&dev=%s&hot=%s&minify=%s".replaceFirst("\\.bundle", ".map");
    private static final String LAUNCH_JS_DEVTOOLS_COMMAND_URL_FORMAT = "http://%s/launch-js-devtools";
    private static final String ONCHANGE_ENDPOINT_URL_FORMAT = "http://%s/onchange";
    private static final String WEBSOCKET_PROXY_URL_FORMAT = "ws://%s/debugger-proxy?role=client";
    private static final String PACKAGER_STATUS_URL_FORMAT = "http://%s/status";
    private static final String HEAP_CAPTURE_UPLOAD_URL_FORMAT = "http://%s/jscheapcaptureupload";
    private static final String INSPECTOR_DEVICE_URL_FORMAT = "http://%s/inspector/device?name=%s&app=%s";
    private static final String SYMBOLICATE_URL_FORMAT = "http://%s/symbolicate";
    private static final String OPEN_STACK_FRAME_URL_FORMAT = "http://%s/open-stack-frame";
    private static final String PACKAGER_OK_STATUS = "packager-status:running";
    private static final int LONG_POLL_KEEP_ALIVE_DURATION_MS = 120000;
    private static final int LONG_POLL_FAILURE_DELAY_MS = 5000;
    private static final int HTTP_CONNECT_TIMEOUT_MS = 5000;
    private final DevInternalSettings mSettings;
    private final OkHttpClient mClient;
    private final Handler mRestartOnChangePollingHandler;
    private final BundleDownloader mBundleDownloader;
    private final String mPackageName;
    private boolean mOnChangePollingEnabled;
    @Nullable
    private JSPackagerClient mPackagerClient;
    @Nullable
    private InspectorPackagerConnection mInspectorPackagerConnection;
    @Nullable
    private OkHttpClient mOnChangePollingClient;
    @Nullable
    private OnServerContentChangeListener mOnServerContentChangeListener;

    public DevServerHelper(DevInternalSettings settings, String packageName) {
        this.mSettings = settings;
        this.mClient = new OkHttpClient.Builder().connectTimeout(5000L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).writeTimeout(0L, TimeUnit.MILLISECONDS).build();
        this.mBundleDownloader = new BundleDownloader(this.mClient);
        this.mRestartOnChangePollingHandler = new Handler();
        this.mPackageName = packageName;
    }

    public void openPackagerConnection(final String clientId, final PackagerCommandListener commandListener) {
        if (this.mPackagerClient != null) {
            FLog.w((String)"ReactNative", (String)"Packager connection already open, nooping.");
            return;
        }
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... backgroundParams) {
                HashMap<String, RequestHandler> handlers = new HashMap<String, RequestHandler>();
                handlers.put("reload", new NotificationOnlyHandler(){

                    @Override
                    public void onNotification(@Nullable Object params) {
                        commandListener.onPackagerReloadCommand();
                    }
                });
                handlers.put("devMenu", new NotificationOnlyHandler(){

                    @Override
                    public void onNotification(@Nullable Object params) {
                        commandListener.onPackagerDevMenuCommand();
                    }
                });
                handlers.put("captureHeap", new RequestOnlyHandler(){

                    @Override
                    public void onRequest(@Nullable Object params, Responder responder) {
                        commandListener.onCaptureHeapCommand(responder);
                    }
                });
                handlers.put("pokeSamplingProfiler", new RequestOnlyHandler(){

                    @Override
                    public void onRequest(@Nullable Object params, Responder responder) {
                        commandListener.onPokeSamplingProfilerCommand(responder);
                    }
                });
                handlers.putAll(new FileIoHandler().handlers());
                DevServerHelper.this.mPackagerClient = new JSPackagerClient(clientId, DevServerHelper.this.mSettings.getPackagerConnectionSettings(), handlers);
                DevServerHelper.this.mPackagerClient.init();
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public void closePackagerConnection() {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                if (DevServerHelper.this.mPackagerClient != null) {
                    DevServerHelper.this.mPackagerClient.close();
                    DevServerHelper.this.mPackagerClient = null;
                }
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public void openInspectorConnection() {
        if (this.mInspectorPackagerConnection != null) {
            FLog.w((String)"ReactNative", (String)"Inspector connection already open, nooping.");
            return;
        }
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                DevServerHelper.this.mInspectorPackagerConnection = new InspectorPackagerConnection(DevServerHelper.this.getInspectorDeviceUrl(), DevServerHelper.this.mPackageName);
                DevServerHelper.this.mInspectorPackagerConnection.connect();
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public void openInspector(String id2) {
        if (this.mInspectorPackagerConnection != null) {
            this.mInspectorPackagerConnection.sendOpenEvent(id2);
        }
    }

    public void closeInspectorConnection() {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                if (DevServerHelper.this.mInspectorPackagerConnection != null) {
                    DevServerHelper.this.mInspectorPackagerConnection.closeQuietly();
                    DevServerHelper.this.mInspectorPackagerConnection = null;
                }
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public void symbolicateStackTrace(Iterable<StackFrame> stackFrames, final SymbolicationListener listener) {
        try {
            String symbolicateURL = DevServerHelper.createSymbolicateURL(this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
            JSONArray jsonStackFrames = new JSONArray();
            for (StackFrame stackFrame : stackFrames) {
                jsonStackFrames.put((Object)stackFrame.toJSON());
            }
            Request request = new Request.Builder().url(symbolicateURL).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new JSONObject().put("stack", (Object)jsonStackFrames).toString())).build();
            Call symbolicateCall = (Call)Assertions.assertNotNull((Object)this.mClient.newCall(request));
            symbolicateCall.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    FLog.w((String)"ReactNative", (String)("Got IOException when attempting symbolicate stack trace: " + e.getMessage()));
                    listener.onSymbolicationComplete(null);
                }

                public void onResponse(Call call, Response response) throws IOException {
                    try {
                        listener.onSymbolicationComplete(Arrays.asList(StackTraceHelper.convertJsStackTrace(new JSONObject(response.body().string()).getJSONArray("stack"))));
                    }
                    catch (JSONException exception) {
                        listener.onSymbolicationComplete(null);
                    }
                }
            });
        }
        catch (JSONException e) {
            FLog.w((String)"ReactNative", (String)("Got JSONException when attempting symbolicate stack trace: " + e.getMessage()));
        }
    }

    public void openStackFrameCall(StackFrame stackFrame) {
        String openStackFrameURL = DevServerHelper.createOpenStackFrameURL(this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
        Request request = new Request.Builder().url(openStackFrameURL).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)stackFrame.toJSON().toString())).build();
        Call symbolicateCall = (Call)Assertions.assertNotNull((Object)this.mClient.newCall(request));
        symbolicateCall.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                FLog.w((String)"ReactNative", (String)("Got IOException when attempting to open stack frame: " + e.getMessage()));
            }

            public void onResponse(Call call, Response response) throws IOException {
            }
        });
    }

    public static String getReloadAppAction(Context context) {
        return context.getPackageName() + RELOAD_APP_ACTION_SUFFIX;
    }

    public String getWebsocketProxyURL() {
        return String.format(Locale.US, WEBSOCKET_PROXY_URL_FORMAT, this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
    }

    public String getHeapCaptureUploadUrl() {
        return String.format(Locale.US, HEAP_CAPTURE_UPLOAD_URL_FORMAT, this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
    }

    public String getInspectorDeviceUrl() {
        return String.format(Locale.US, INSPECTOR_DEVICE_URL_FORMAT, this.mSettings.getPackagerConnectionSettings().getInspectorServerHost(), AndroidInfoHelpers.getFriendlyDeviceName(), this.mPackageName);
    }

    public BundleDownloader getBundleDownloader() {
        return this.mBundleDownloader;
    }

    private String getHostForJSProxy() {
        String host = (String)Assertions.assertNotNull((Object)this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
        int portOffset = host.lastIndexOf(58);
        if (portOffset > -1) {
            return "localhost" + host.substring(portOffset);
        }
        return "localhost";
    }

    private boolean getDevMode() {
        return this.mSettings.isJSDevModeEnabled();
    }

    private boolean getJSMinifyMode() {
        return this.mSettings.isJSMinifyEnabled();
    }

    private boolean getHMR() {
        return this.mSettings.isHotModuleReplacementEnabled();
    }

    private static String createBundleURL(String host, String jsModulePath, boolean devMode, boolean hmr, boolean jsMinify) {
        return String.format(Locale.US, BUNDLE_URL_FORMAT, host, jsModulePath, devMode, hmr, jsMinify);
    }

    private static String createResourceURL(String host, String resourcePath) {
        return String.format(Locale.US, RESOURCE_URL_FORMAT, host, resourcePath);
    }

    private static String createSymbolicateURL(String host) {
        return String.format(Locale.US, SYMBOLICATE_URL_FORMAT, host);
    }

    private static String createOpenStackFrameURL(String host) {
        return String.format(Locale.US, OPEN_STACK_FRAME_URL_FORMAT, host);
    }

    public String getDevServerBundleURL(String jsModulePath) {
        return DevServerHelper.createBundleURL(this.mSettings.getPackagerConnectionSettings().getDebugServerHost(), jsModulePath, this.getDevMode(), this.getHMR(), this.getJSMinifyMode());
    }

    public void isPackagerRunning(final PackagerStatusCallback callback) {
        String statusURL = DevServerHelper.createPackagerStatusURL(this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
        Request request = new Request.Builder().url(statusURL).build();
        this.mClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                FLog.w((String)"ReactNative", (String)("The packager does not seem to be running as we got an IOException requesting its status: " + e.getMessage()));
                callback.onPackagerStatusFetched(false);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (!response.isSuccessful()) {
                    FLog.e((String)"ReactNative", (String)("Got non-success http code from packager when requesting status: " + response.code()));
                    callback.onPackagerStatusFetched(false);
                    return;
                }
                ResponseBody body = response.body();
                if (body == null) {
                    FLog.e((String)"ReactNative", (String)"Got null body response from packager when requesting status");
                    callback.onPackagerStatusFetched(false);
                    return;
                }
                if (!DevServerHelper.PACKAGER_OK_STATUS.equals(body.string())) {
                    FLog.e((String)"ReactNative", (String)("Got unexpected response from packager when requesting status: " + body.string()));
                    callback.onPackagerStatusFetched(false);
                    return;
                }
                callback.onPackagerStatusFetched(true);
            }
        });
    }

    private static String createPackagerStatusURL(String host) {
        return String.format(Locale.US, PACKAGER_STATUS_URL_FORMAT, host);
    }

    public void stopPollingOnChangeEndpoint() {
        this.mOnChangePollingEnabled = false;
        this.mRestartOnChangePollingHandler.removeCallbacksAndMessages(null);
        if (this.mOnChangePollingClient != null) {
            OkHttpCallUtil.cancelTag(this.mOnChangePollingClient, this);
            this.mOnChangePollingClient = null;
        }
        this.mOnServerContentChangeListener = null;
    }

    public void startPollingOnChangeEndpoint(OnServerContentChangeListener onServerContentChangeListener) {
        if (this.mOnChangePollingEnabled) {
            return;
        }
        this.mOnChangePollingEnabled = true;
        this.mOnServerContentChangeListener = onServerContentChangeListener;
        this.mOnChangePollingClient = new OkHttpClient.Builder().connectionPool(new ConnectionPool(1, 120000L, TimeUnit.MINUTES)).connectTimeout(5000L, TimeUnit.MILLISECONDS).build();
        this.enqueueOnChangeEndpointLongPolling();
    }

    private void handleOnChangePollingResponse(boolean didServerContentChanged) {
        if (this.mOnChangePollingEnabled) {
            if (didServerContentChanged) {
                UiThreadUtil.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (DevServerHelper.this.mOnServerContentChangeListener != null) {
                            DevServerHelper.this.mOnServerContentChangeListener.onServerContentChanged();
                        }
                    }
                });
            }
            this.enqueueOnChangeEndpointLongPolling();
        }
    }

    private void enqueueOnChangeEndpointLongPolling() {
        Request request = new Request.Builder().url(this.createOnChangeEndpointUrl()).tag((Object)this).build();
        ((OkHttpClient)Assertions.assertNotNull((Object)this.mOnChangePollingClient)).newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (DevServerHelper.this.mOnChangePollingEnabled) {
                    FLog.d((String)"ReactNative", (String)"Error while requesting /onchange endpoint", (Throwable)e);
                    DevServerHelper.this.mRestartOnChangePollingHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            DevServerHelper.this.handleOnChangePollingResponse(false);
                        }
                    }, 5000L);
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                DevServerHelper.this.handleOnChangePollingResponse(response.code() == 205);
            }
        });
    }

    private String createOnChangeEndpointUrl() {
        return String.format(Locale.US, ONCHANGE_ENDPOINT_URL_FORMAT, this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
    }

    private String createLaunchJSDevtoolsCommandUrl() {
        return String.format(Locale.US, LAUNCH_JS_DEVTOOLS_COMMAND_URL_FORMAT, this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
    }

    public void launchJSDevtools() {
        Request request = new Request.Builder().url(this.createLaunchJSDevtoolsCommandUrl()).build();
        this.mClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
            }

            public void onResponse(Call call, Response response) throws IOException {
            }
        });
    }

    public String getSourceMapUrl(String mainModuleName) {
        return String.format(Locale.US, SOURCE_MAP_URL_FORMAT, this.mSettings.getPackagerConnectionSettings().getDebugServerHost(), mainModuleName, this.getDevMode(), this.getHMR(), this.getJSMinifyMode());
    }

    public String getSourceUrl(String mainModuleName) {
        return String.format(Locale.US, BUNDLE_URL_FORMAT, this.mSettings.getPackagerConnectionSettings().getDebugServerHost(), mainModuleName, this.getDevMode(), this.getHMR(), this.getJSMinifyMode());
    }

    public String getJSBundleURLForRemoteDebugging(String mainModuleName) {
        return DevServerHelper.createBundleURL(this.getHostForJSProxy(), mainModuleName, this.getDevMode(), this.getHMR(), this.getJSMinifyMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public File downloadBundleResourceFromUrlSync(String resourcePath, File outputFile) {
        String resourceURL = DevServerHelper.createResourceURL(this.mSettings.getPackagerConnectionSettings().getDebugServerHost(), resourcePath);
        Request request = new Request.Builder().url(resourceURL).build();
        try {
            Response response = this.mClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                return null;
            }
            try (Sink output = null;){
                output = Okio.sink((File)outputFile);
                Okio.buffer((Source)response.body().source()).readAll(output);
            }
            return outputFile;
        }
        catch (Exception ex) {
            FLog.e((String)"ReactNative", (String)"Failed to fetch resource synchronously - resourcePath: \"%s\", outputFile: \"%s\"", (Object[])new Object[]{resourcePath, outputFile.getAbsolutePath(), ex});
            return null;
        }
    }

    public static interface SymbolicationListener {
        public void onSymbolicationComplete(@Nullable Iterable<StackFrame> var1);
    }

    public static interface PackagerCommandListener {
        public void onPackagerReloadCommand();

        public void onPackagerDevMenuCommand();

        public void onCaptureHeapCommand(Responder var1);

        public void onPokeSamplingProfilerCommand(Responder var1);
    }

    public static interface OnServerContentChangeListener {
        public void onServerContentChanged();
    }
}

