/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import com.facebook.react.flat.AndroidView;
import com.facebook.react.flat.FlatShadowNode;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaUnit;
import com.facebook.yoga.YogaValue;
import javax.annotation.Nullable;

final class NativeViewWrapper
extends FlatShadowNode
implements AndroidView {
    @Nullable
    private final ReactShadowNode mReactShadowNode;
    private final boolean mNeedsCustomLayoutForChildren;
    private boolean mPaddingChanged = false;
    private boolean mForceMountGrandChildrenToView;

    NativeViewWrapper(ViewManager viewManager) {
        Object reactShadowNode = viewManager.createShadowNodeInstance();
        if (reactShadowNode instanceof YogaMeasureFunction) {
            this.mReactShadowNode = reactShadowNode;
            this.setMeasureFunction((YogaMeasureFunction)reactShadowNode);
        } else {
            this.mReactShadowNode = null;
        }
        if (viewManager instanceof ViewGroupManager) {
            ViewGroupManager viewGroupManager = (ViewGroupManager)viewManager;
            this.mNeedsCustomLayoutForChildren = viewGroupManager.needsCustomLayoutForChildren();
            this.mForceMountGrandChildrenToView = viewGroupManager.shouldPromoteGrandchildren();
        } else {
            this.mNeedsCustomLayoutForChildren = false;
        }
        this.forceMountToView();
        this.forceMountChildrenToView();
    }

    @Override
    public boolean needsCustomLayoutForChildren() {
        return this.mNeedsCustomLayoutForChildren;
    }

    @Override
    public boolean isPaddingChanged() {
        return this.mPaddingChanged;
    }

    @Override
    public void resetPaddingChanged() {
        this.mPaddingChanged = false;
    }

    @Override
    public void setBackgroundColor(int backgroundColor) {
    }

    @Override
    public void setReactTag(int reactTag) {
        super.setReactTag(reactTag);
        if (this.mReactShadowNode != null) {
            this.mReactShadowNode.setReactTag(reactTag);
        }
    }

    @Override
    public void setThemedContext(ThemedReactContext themedContext) {
        super.setThemedContext(themedContext);
        if (this.mReactShadowNode != null) {
            this.mReactShadowNode.setThemedContext(themedContext);
        }
    }

    @Override
    void handleUpdateProperties(ReactStylesDiffMap styles) {
        if (this.mReactShadowNode != null) {
            this.mReactShadowNode.updateProperties(styles);
        }
    }

    @Override
    public void addChildAt(ReactShadowNode child, int i) {
        super.addChildAt(child, i);
        if (this.mForceMountGrandChildrenToView && child instanceof FlatShadowNode) {
            ((FlatShadowNode)child).forceMountChildrenToView();
        }
    }

    @Override
    public void setPadding(int spacingType, float padding) {
        YogaValue current = this.getStylePadding(spacingType);
        if (current.unit != YogaUnit.POINT || current.value != padding) {
            super.setPadding(spacingType, padding);
            this.mPaddingChanged = true;
            this.markUpdated();
        }
    }

    @Override
    public void setPaddingPercent(int spacingType, float percent) {
        YogaValue current = this.getStylePadding(spacingType);
        if (current.unit != YogaUnit.PERCENT || current.value != percent) {
            super.setPadding(spacingType, percent);
            this.mPaddingChanged = true;
            this.markUpdated();
        }
    }

    @Override
    public void onCollectExtraUpdates(UIViewOperationQueue uiViewOperationQueue) {
        if (this.mReactShadowNode != null && this.mReactShadowNode.hasUnseenUpdates()) {
            this.mReactShadowNode.onCollectExtraUpdates(uiViewOperationQueue);
            this.markUpdateSeen();
        }
    }
}

