/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.animated.AnimatedNodeValueListener;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.OnBatchCompleteListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.uimanager.GuardedFrameCallback;
import com.facebook.react.uimanager.UIManagerModule;
import java.util.ArrayList;
import javax.annotation.Nullable;

@ReactModule(name="NativeAnimatedModule")
public class NativeAnimatedModule
extends ReactContextBaseJavaModule
implements OnBatchCompleteListener,
LifecycleEventListener {
    protected static final String NAME = "NativeAnimatedModule";
    private final Object mOperationsCopyLock = new Object();
    private final GuardedFrameCallback mAnimatedFrameCallback;
    private final ReactChoreographer mReactChoreographer;
    private ArrayList<UIThreadOperation> mOperations = new ArrayList();
    @Nullable
    private volatile ArrayList<UIThreadOperation> mReadyOperations = null;
    @Nullable
    private NativeAnimatedNodesManager mNodesManager;

    public NativeAnimatedModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.mReactChoreographer = ReactChoreographer.getInstance();
        this.mAnimatedFrameCallback = new GuardedFrameCallback(reactContext){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doFrameGuarded(long frameTimeNanos) {
                ArrayList operations;
                if (NativeAnimatedModule.this.mNodesManager == null) {
                    UIManagerModule uiManager = NativeAnimatedModule.this.getReactApplicationContext().getNativeModule(UIManagerModule.class);
                    NativeAnimatedModule.this.mNodesManager = new NativeAnimatedNodesManager(uiManager);
                }
                Object object = NativeAnimatedModule.this.mOperationsCopyLock;
                synchronized (object) {
                    operations = NativeAnimatedModule.this.mReadyOperations;
                    NativeAnimatedModule.this.mReadyOperations = null;
                }
                if (operations != null) {
                    int size = operations.size();
                    for (int i = 0; i < size; ++i) {
                        ((UIThreadOperation)operations.get(i)).execute(NativeAnimatedModule.this.mNodesManager);
                    }
                }
                if (NativeAnimatedModule.this.mNodesManager.hasActiveAnimations()) {
                    NativeAnimatedModule.this.mNodesManager.runUpdates(frameTimeNanos);
                }
                ((ReactChoreographer)Assertions.assertNotNull((Object)NativeAnimatedModule.this.mReactChoreographer)).postFrameCallback(ReactChoreographer.CallbackType.NATIVE_ANIMATED_MODULE, NativeAnimatedModule.this.mAnimatedFrameCallback);
            }
        };
    }

    @Override
    public void initialize() {
        this.getReactApplicationContext().addLifecycleEventListener(this);
    }

    @Override
    public void onHostResume() {
        this.enqueueFrameCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBatchComplete() {
        ArrayList<UIThreadOperation> operations;
        ArrayList<UIThreadOperation> arrayList = operations = this.mOperations.isEmpty() ? null : this.mOperations;
        if (operations != null) {
            this.mOperations = new ArrayList();
            Object object = this.mOperationsCopyLock;
            synchronized (object) {
                if (this.mReadyOperations == null) {
                    this.mReadyOperations = operations;
                } else {
                    this.mReadyOperations.addAll(operations);
                }
            }
        }
    }

    @Override
    public void onHostPause() {
        this.clearFrameCallback();
    }

    @Override
    public void onHostDestroy() {
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void clearFrameCallback() {
        ((ReactChoreographer)Assertions.assertNotNull((Object)this.mReactChoreographer)).removeFrameCallback(ReactChoreographer.CallbackType.NATIVE_ANIMATED_MODULE, this.mAnimatedFrameCallback);
    }

    private void enqueueFrameCallback() {
        ((ReactChoreographer)Assertions.assertNotNull((Object)this.mReactChoreographer)).postFrameCallback(ReactChoreographer.CallbackType.NATIVE_ANIMATED_MODULE, this.mAnimatedFrameCallback);
    }

    @ReactMethod
    public void createAnimatedNode(final int tag, final ReadableMap config) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.createAnimatedNode(tag, config);
            }
        });
    }

    @ReactMethod
    public void startListeningToAnimatedNodeValue(final int tag) {
        final AnimatedNodeValueListener listener = new AnimatedNodeValueListener(){

            @Override
            public void onValueUpdate(double value) {
                WritableMap onAnimatedValueData = Arguments.createMap();
                onAnimatedValueData.putInt("tag", tag);
                onAnimatedValueData.putDouble("value", value);
                NativeAnimatedModule.this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("onAnimatedValueUpdate", onAnimatedValueData);
            }
        };
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.startListeningToAnimatedNodeValue(tag, listener);
            }
        });
    }

    @ReactMethod
    public void stopListeningToAnimatedNodeValue(final int tag) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.stopListeningToAnimatedNodeValue(tag);
            }
        });
    }

    @ReactMethod
    public void dropAnimatedNode(final int tag) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.dropAnimatedNode(tag);
            }
        });
    }

    @ReactMethod
    public void setAnimatedNodeValue(final int tag, final double value) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.setAnimatedNodeValue(tag, value);
            }
        });
    }

    @ReactMethod
    public void setAnimatedNodeOffset(final int tag, final double value) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.setAnimatedNodeOffset(tag, value);
            }
        });
    }

    @ReactMethod
    public void flattenAnimatedNodeOffset(final int tag) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.flattenAnimatedNodeOffset(tag);
            }
        });
    }

    @ReactMethod
    public void extractAnimatedNodeOffset(final int tag) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.extractAnimatedNodeOffset(tag);
            }
        });
    }

    @ReactMethod
    public void startAnimatingNode(final int animationId, final int animatedNodeTag, final ReadableMap animationConfig, final Callback endCallback) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.startAnimatingNode(animationId, animatedNodeTag, animationConfig, endCallback);
            }
        });
    }

    @ReactMethod
    public void stopAnimation(final int animationId) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.stopAnimation(animationId);
            }
        });
    }

    @ReactMethod
    public void connectAnimatedNodes(final int parentNodeTag, final int childNodeTag) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.connectAnimatedNodes(parentNodeTag, childNodeTag);
            }
        });
    }

    @ReactMethod
    public void disconnectAnimatedNodes(final int parentNodeTag, final int childNodeTag) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.disconnectAnimatedNodes(parentNodeTag, childNodeTag);
            }
        });
    }

    @ReactMethod
    public void connectAnimatedNodeToView(final int animatedNodeTag, final int viewTag) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.connectAnimatedNodeToView(animatedNodeTag, viewTag);
            }
        });
    }

    @ReactMethod
    public void disconnectAnimatedNodeFromView(final int animatedNodeTag, final int viewTag) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.disconnectAnimatedNodeFromView(animatedNodeTag, viewTag);
            }
        });
    }

    @ReactMethod
    public void addAnimatedEventToView(final int viewTag, final String eventName, final ReadableMap eventMapping) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.addAnimatedEventToView(viewTag, eventName, eventMapping);
            }
        });
    }

    @ReactMethod
    public void removeAnimatedEventFromView(final int viewTag, final String eventName, final int animatedValueTag) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.removeAnimatedEventFromView(viewTag, eventName, animatedValueTag);
            }
        });
    }

    private static interface UIThreadOperation {
        public void execute(NativeAnimatedNodesManager var1);
    }
}

