/*
 * Decompiled with CFR 0.152.
 */
package com.github.godness84.RNRecyclerViewList;

import android.content.Context;
import android.graphics.PointF;
import android.support.annotation.Nullable;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.common.SystemClock;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.NativeGestureUtil;
import com.facebook.react.views.scroll.OnScrollDispatchHelper;
import com.facebook.react.views.scroll.ScrollEvent;
import com.facebook.react.views.scroll.ScrollEventType;
import com.facebook.react.views.scroll.VelocityHelper;
import com.github.godness84.RNRecyclerViewList.R;
import com.github.godness84.RNRecyclerViewList.RecyclerViewItemView;
import com.github.godness84.RNRecyclerViewList.VisibleItemsChangeEvent;
import java.util.ArrayList;
import java.util.List;

@VisibleForTesting
public class RecyclerViewBackedScrollView
extends RecyclerView {
    private static final String TAG = "RecyclerViewBackedScrol";
    private final OnScrollDispatchHelper mOnScrollDispatchHelper = new OnScrollDispatchHelper();
    private final VelocityHelper mVelocityHelper = new VelocityHelper();
    private boolean mDragging;
    private int mFirstVisibleIndex;
    private int mLastVisibleIndex;
    private boolean mRequestedLayout = false;

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.mOnScrollDispatchHelper.onScrollChanged(l, t)) {
            ((UIManagerModule)this.getReactContext().getNativeModule(UIManagerModule.class)).getEventDispatcher().dispatchEvent((Event)ScrollEvent.obtain((int)this.getId(), (ScrollEventType)ScrollEventType.SCROLL, (int)0, (int)this.computeVerticalScrollOffset(), (float)this.mOnScrollDispatchHelper.getXFlingVelocity(), (float)this.mOnScrollDispatchHelper.getYFlingVelocity(), (int)this.getWidth(), (int)this.computeVerticalScrollRange(), (int)this.getWidth(), (int)this.getHeight()));
        }
        int firstIndex = ((LinearLayoutManager)this.getLayoutManager()).findFirstVisibleItemPosition();
        int lastIndex = ((LinearLayoutManager)this.getLayoutManager()).findLastVisibleItemPosition();
        if (firstIndex != this.mFirstVisibleIndex || lastIndex != this.mLastVisibleIndex) {
            ((UIManagerModule)this.getReactContext().getNativeModule(UIManagerModule.class)).getEventDispatcher().dispatchEvent((Event)new VisibleItemsChangeEvent(this.getId(), SystemClock.nanoTime(), firstIndex, lastIndex));
            this.mFirstVisibleIndex = firstIndex;
            this.mLastVisibleIndex = lastIndex;
        }
    }

    private ReactContext getReactContext() {
        return (ReactContext)((ContextThemeWrapper)this.getContext()).getBaseContext();
    }

    public RecyclerViewBackedScrollView(Context context) {
        super((Context)new ContextThemeWrapper(context, R.style.ScrollbarRecyclerView));
        this.setHasFixedSize(true);
        ((DefaultItemAnimator)this.getItemAnimator()).setSupportsChangeAnimations(false);
        this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        this.setAdapter(new ReactListAdapter(this));
    }

    void addViewToAdapter(RecyclerViewItemView child, int index) {
        ((ReactListAdapter)this.getAdapter()).addView(child, index);
    }

    void removeViewFromAdapter(int index) {
        ((ReactListAdapter)this.getAdapter()).removeViewAt(index);
    }

    View getChildAtFromAdapter(int index) {
        return ((ReactListAdapter)this.getAdapter()).getView(index);
    }

    int getChildCountFromAdapter() {
        return ((ReactListAdapter)this.getAdapter()).getViewCount();
    }

    void setItemCount(int itemCount) {
        ((ReactListAdapter)this.getAdapter()).setItemCount(itemCount);
    }

    int getItemCount() {
        return this.getAdapter().getItemCount();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (super.onInterceptTouchEvent(ev)) {
            NativeGestureUtil.notifyNativeGestureStarted((View)this, (MotionEvent)ev);
            this.mDragging = true;
            ((UIManagerModule)this.getReactContext().getNativeModule(UIManagerModule.class)).getEventDispatcher().dispatchEvent((Event)ScrollEvent.obtain((int)this.getId(), (ScrollEventType)ScrollEventType.BEGIN_DRAG, (int)0, (int)this.computeVerticalScrollOffset(), (float)0.0f, (float)0.0f, (int)this.getWidth(), (int)this.computeVerticalScrollRange(), (int)this.getWidth(), (int)this.getHeight()));
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int action = ev.getAction() & 0xFF;
        if (action == 1 && this.mDragging) {
            this.mDragging = false;
            this.mVelocityHelper.calculateVelocity(ev);
            ((UIManagerModule)this.getReactContext().getNativeModule(UIManagerModule.class)).getEventDispatcher().dispatchEvent((Event)ScrollEvent.obtain((int)this.getId(), (ScrollEventType)ScrollEventType.END_DRAG, (int)0, (int)this.computeVerticalScrollOffset(), (float)this.mVelocityHelper.getXVelocity(), (float)this.mVelocityHelper.getYVelocity(), (int)this.getWidth(), (int)this.computeVerticalScrollRange(), (int)this.getWidth(), (int)this.getHeight()));
        }
        return super.onTouchEvent(ev);
    }

    public void requestLayout() {
        super.requestLayout();
        if (!this.mRequestedLayout) {
            this.mRequestedLayout = true;
            this.post(new Runnable(){

                @Override
                public void run() {
                    RecyclerViewBackedScrollView.this.mRequestedLayout = false;
                    RecyclerViewBackedScrollView.this.layout(RecyclerViewBackedScrollView.this.getLeft(), RecyclerViewBackedScrollView.this.getTop(), RecyclerViewBackedScrollView.this.getRight(), RecyclerViewBackedScrollView.this.getBottom());
                    RecyclerViewBackedScrollView.this.onLayout(false, RecyclerViewBackedScrollView.this.getLeft(), RecyclerViewBackedScrollView.this.getTop(), RecyclerViewBackedScrollView.this.getRight(), RecyclerViewBackedScrollView.this.getBottom());
                }
            });
        }
    }

    public void scrollToPosition(int position) {
        this.scrollToPosition(position, new ScrollOptions());
    }

    public void scrollToPosition(int position, ScrollOptions options) {
        if (options.viewPosition != null) {
            LinearLayoutManager layoutManager = (LinearLayoutManager)this.getLayoutManager();
            ReactListAdapter adapter = (ReactListAdapter)this.getAdapter();
            RecyclerViewItemView view = adapter.getViewByItemIndex(position);
            if (view != null) {
                int viewHeight = view.getHeight();
                if (viewHeight == 0) {
                    view.addOnLayoutChangeListener(new View.OnLayoutChangeListener((View)view, position, options){
                        final /* synthetic */ View val$view;
                        final /* synthetic */ int val$position;
                        final /* synthetic */ ScrollOptions val$options;
                        {
                            this.val$view = view;
                            this.val$position = n;
                            this.val$options = scrollOptions;
                        }

                        public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                            Log.d((String)RecyclerViewBackedScrollView.TAG, (String)("layout changed for scrolled view to height: " + (bottom - top)));
                            this.val$view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                            RecyclerViewBackedScrollView.this.scrollToPosition(this.val$position, this.val$options);
                        }
                    });
                    return;
                }
                int boxStart = layoutManager.getPaddingTop();
                int boxEnd = layoutManager.getHeight() - layoutManager.getPaddingBottom();
                int boxHeight = boxEnd - boxStart;
                float viewOffset = options.viewOffset != null ? PixelUtil.toPixelFromDIP((float)options.viewOffset.floatValue()) : 0.0f;
                int offset = (int)((float)(boxHeight - viewHeight) * options.viewPosition.floatValue() + viewOffset);
                layoutManager.scrollToPositionWithOffset(position, offset);
                Log.d((String)TAG, (String)("scrollToPosition position: " + position + ", viewHeight: " + viewHeight + ", boxHeight: " + boxHeight + ", viewOffset: " + viewOffset + ", offset: " + offset + ", viewMeasuredHeight: " + view.getMeasuredHeight()));
                return;
            }
        }
        super.scrollToPosition(position);
    }

    public void smoothScrollToPosition(int position) {
        this.smoothScrollToPosition(position, new ScrollOptions());
    }

    public void smoothScrollToPosition(int position, final ScrollOptions options) {
        LinearSmoothScroller smoothScroller = new LinearSmoothScroller(this.getContext()){

            protected int getVerticalSnapPreference() {
                return -1;
            }

            public PointF computeScrollVectorForPosition(int targetPosition) {
                return ((LinearLayoutManager)this.getLayoutManager()).computeScrollVectorForPosition(targetPosition);
            }

            protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
                if (options.millisecondsPerInch != null) {
                    return options.millisecondsPerInch.floatValue() / (float)displayMetrics.densityDpi;
                }
                return super.calculateSpeedPerPixel(displayMetrics);
            }

            public int calculateDtToFit(int viewStart, int viewEnd, int boxStart, int boxEnd, int snapPreference) {
                int calc = super.calculateDtToFit(viewStart, viewEnd, boxStart, boxEnd, snapPreference);
                if (options.viewPosition != null) {
                    int viewHeight = viewEnd - viewStart;
                    int boxHeight = boxEnd - boxStart;
                    float viewOffset = options.viewOffset != null ? PixelUtil.toPixelFromDIP((float)options.viewOffset.floatValue()) : 0.0f;
                    float target = (float)boxStart + (float)(boxHeight - viewHeight) * options.viewPosition.floatValue() + viewOffset;
                    return (int)(target - (float)viewStart);
                }
                return super.calculateDtToFit(viewStart, viewEnd, boxStart, boxEnd, snapPreference);
            }
        };
        smoothScroller.setTargetPosition(position);
        this.getLayoutManager().startSmoothScroll((RecyclerView.SmoothScroller)smoothScroller);
    }

    public void setItemAnimatorEnabled(boolean enabled) {
        if (enabled) {
            DefaultItemAnimator animator = new DefaultItemAnimator();
            animator.setSupportsChangeAnimations(false);
            this.setItemAnimator((RecyclerView.ItemAnimator)animator);
        } else {
            this.setItemAnimator(null);
        }
    }

    static class ReactListAdapter
    extends RecyclerView.Adapter<ConcreteViewHolder> {
        private final List<RecyclerViewItemView> mViews = new ArrayList<RecyclerViewItemView>();
        private final RecyclerViewBackedScrollView mScrollView;
        private int mItemCount = 0;

        public ReactListAdapter(RecyclerViewBackedScrollView scrollView) {
            this.mScrollView = scrollView;
        }

        public void addView(RecyclerViewItemView child, int index) {
            this.mViews.add(index, child);
            int itemIndex = child.getItemIndex();
            this.notifyItemChanged(itemIndex);
        }

        public void removeViewAt(int index) {
            RecyclerViewItemView child = this.mViews.get(index);
            if (child != null) {
                this.mViews.remove(index);
            }
        }

        public int getViewCount() {
            return this.mViews.size();
        }

        public ConcreteViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            return new ConcreteViewHolder((View)new RecyclableWrapperViewGroup(parent.getContext(), this));
        }

        public void onBindViewHolder(ConcreteViewHolder holder, int position) {
            RecyclableWrapperViewGroup vg = (RecyclableWrapperViewGroup)holder.itemView;
            RecyclerViewItemView row = this.getViewByItemIndex(position);
            if (row != null) {
                Log.d((String)RecyclerViewBackedScrollView.TAG, (String)("Bound position: " + position));
            } else {
                Log.d((String)RecyclerViewBackedScrollView.TAG, (String)("Bound position: " + position + " but no view found"));
            }
            if (row != null && row.getParent() != vg) {
                if (row.getParent() != null) {
                    ((ViewGroup)row.getParent()).removeView((View)row);
                }
                vg.addView((View)row, 0);
            }
        }

        public void onViewRecycled(ConcreteViewHolder holder) {
            super.onViewRecycled((RecyclerView.ViewHolder)holder);
            ((RecyclableWrapperViewGroup)holder.itemView).removeAllViews();
        }

        public int getItemCount() {
            return this.mItemCount;
        }

        public void setItemCount(int itemCount) {
            this.mItemCount = itemCount;
        }

        public View getView(int index) {
            return (View)this.mViews.get(index);
        }

        public RecyclerViewItemView getViewByItemIndex(int position) {
            for (int i = 0; i < this.mViews.size(); ++i) {
                if (this.mViews.get(i).getItemIndex() != position) continue;
                return this.mViews.get(i);
            }
            return null;
        }
    }

    static class RecyclableWrapperViewGroup
    extends ViewGroup {
        private ReactListAdapter mAdapter;
        private int mLastMeasuredWidth;
        private int mLastMeasuredHeight;
        private View.OnLayoutChangeListener mChildLayoutChangeListener = new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                int oldHeight = oldBottom - oldTop;
                int newHeight = bottom - top;
                if (oldHeight != newHeight && RecyclableWrapperViewGroup.this.getParent() != null) {
                    RecyclableWrapperViewGroup.this.requestLayout();
                    RecyclableWrapperViewGroup.this.getParent().requestLayout();
                }
            }
        };

        public RecyclableWrapperViewGroup(Context context, ReactListAdapter adapter) {
            super(context);
            this.mAdapter = adapter;
            this.mLastMeasuredHeight = 10;
            this.mLastMeasuredWidth = 10;
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
        }

        public void onViewAdded(View child) {
            super.onViewAdded(child);
            child.addOnLayoutChangeListener(this.mChildLayoutChangeListener);
        }

        public void onViewRemoved(View child) {
            super.onViewRemoved(child);
            child.removeOnLayoutChangeListener(this.mChildLayoutChangeListener);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            if (this.getChildCount() > 0) {
                View child = this.getChildAt(0);
                this.mLastMeasuredWidth = child.getMeasuredWidth();
                this.mLastMeasuredHeight = child.getMeasuredHeight();
                this.setMeasuredDimension(this.mLastMeasuredWidth, this.mLastMeasuredHeight);
            } else {
                this.setMeasuredDimension(this.mLastMeasuredWidth, this.mLastMeasuredHeight);
            }
        }

        public ReactListAdapter getAdapter() {
            return this.mAdapter;
        }

        public boolean onTouchEvent(MotionEvent event) {
            return true;
        }
    }

    private static class ConcreteViewHolder
    extends RecyclerView.ViewHolder {
        public ConcreteViewHolder(View itemView) {
            super(itemView);
        }
    }

    static class ScrollOptions {
        @Nullable
        Float millisecondsPerInch;
        @Nullable
        Float viewPosition;
        @Nullable
        Float viewOffset;

        ScrollOptions() {
        }
    }
}

