/*
 * Decompiled with CFR 0.152.
 */
package com.github.godness84.RNRecyclerViewList;

import android.content.Context;
import android.view.View;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.scroll.ScrollEventType;
import com.github.godness84.RNRecyclerViewList.RecyclerViewBackedScrollView;
import com.github.godness84.RNRecyclerViewList.RecyclerViewItemView;
import java.util.Map;
import javax.annotation.Nullable;

public class RecyclerViewBackedScrollViewManager
extends ViewGroupManager<RecyclerViewBackedScrollView> {
    public static final String REACT_CLASS = "AndroidRecyclerViewBackedScrollView";
    public static final int COMMAND_NOTIFY_ITEM_RANGE_INSERTED = 1;
    public static final int COMMAND_NOTIFY_ITEM_RANGE_REMOVED = 2;
    public static final int COMMAND_NOTIFY_DATASET_CHANGED = 3;
    public static final int COMMAND_SCROLL_TO_INDEX = 4;
    private static final String TAG = "RecyclerViewManager";

    public String getName() {
        return REACT_CLASS;
    }

    protected RecyclerViewBackedScrollView createViewInstance(ThemedReactContext reactContext) {
        return new RecyclerViewBackedScrollView((Context)reactContext);
    }

    public void addView(RecyclerViewBackedScrollView parent, View child, int index) {
        Assertions.assertCondition((boolean)(child instanceof RecyclerViewItemView), (String)"Views attached to RecyclerViewBackedScrollView must be RecyclerViewItemView views.");
        RecyclerViewItemView item = (RecyclerViewItemView)child;
        parent.addViewToAdapter(item, index);
    }

    public int getChildCount(RecyclerViewBackedScrollView parent) {
        return parent.getChildCountFromAdapter();
    }

    public View getChildAt(RecyclerViewBackedScrollView parent, int index) {
        return parent.getChildAtFromAdapter(index);
    }

    public void removeViewAt(RecyclerViewBackedScrollView parent, int index) {
        parent.removeViewFromAdapter(index);
    }

    @ReactProp(name="itemCount")
    public void setItemCount(RecyclerViewBackedScrollView parent, int itemCount) {
        parent.setItemCount(itemCount);
        parent.getAdapter().notifyDataSetChanged();
    }

    @ReactProp(name="itemAnimatorEnabled", defaultBoolean=true)
    public void setItemAnimatorEnabled(RecyclerViewBackedScrollView parent, boolean enabled) {
        parent.setItemAnimatorEnabled(enabled);
    }

    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of((Object)"notifyItemRangeInserted", (Object)1, (Object)"notifyItemRangeRemoved", (Object)2, (Object)"notifyDataSetChanged", (Object)3, (Object)"scrollToIndex", (Object)4);
    }

    public void receiveCommand(RecyclerViewBackedScrollView parent, int commandType, @Nullable ReadableArray args) {
        Assertions.assertNotNull((Object)((Object)parent));
        Assertions.assertNotNull((Object)args);
        switch (commandType) {
            case 1: {
                int position = args.getInt(0);
                int count = args.getInt(1);
                RecyclerViewBackedScrollView.ReactListAdapter adapter = (RecyclerViewBackedScrollView.ReactListAdapter)parent.getAdapter();
                adapter.setItemCount(adapter.getItemCount() + count);
                adapter.notifyItemRangeInserted(position, count);
                return;
            }
            case 2: {
                int position = args.getInt(0);
                int count = args.getInt(1);
                RecyclerViewBackedScrollView.ReactListAdapter adapter = (RecyclerViewBackedScrollView.ReactListAdapter)parent.getAdapter();
                adapter.setItemCount(adapter.getItemCount() - count);
                adapter.notifyItemRangeRemoved(position, count);
                return;
            }
            case 3: {
                int itemCount = args.getInt(0);
                RecyclerViewBackedScrollView.ReactListAdapter adapter = (RecyclerViewBackedScrollView.ReactListAdapter)parent.getAdapter();
                adapter.setItemCount(itemCount);
                parent.getAdapter().notifyDataSetChanged();
                return;
            }
            case 4: {
                boolean animated = args.getBoolean(0);
                int index = args.getInt(1);
                RecyclerViewBackedScrollView.ScrollOptions options = new RecyclerViewBackedScrollView.ScrollOptions();
                options.millisecondsPerInch = args.isNull(2) ? null : Float.valueOf((float)args.getDouble(2));
                options.viewPosition = args.isNull(3) ? null : Float.valueOf((float)args.getDouble(3));
                Float f = options.viewOffset = args.isNull(4) ? null : Float.valueOf((float)args.getDouble(4));
                if (animated) {
                    parent.smoothScrollToPosition(index, options);
                } else {
                    parent.scrollToPosition(index, options);
                }
                return;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported command %d received by %s.", commandType, ((Object)((Object)this)).getClass().getSimpleName()));
    }

    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.builder().put((Object)ScrollEventType.SCROLL.getJSEventName(), (Object)MapBuilder.of((Object)"registrationName", (Object)"onScroll")).put((Object)"topContentSizeChange", (Object)MapBuilder.of((Object)"registrationName", (Object)"onContentSizeChange")).put((Object)"visibleItemsChange", (Object)MapBuilder.of((Object)"registrationName", (Object)"onVisibleItemsChange")).build();
    }
}

